/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
/*
 * ATTENZIONE!! i puntatori ora sono passati direttamente: questo
 * funziona solo su macchine che hanno i puntatori di 4 bytes
 */
# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
# include "sqltype.h"
# endif
#ifdef __cplusplus
extern "C" {
# include <stdlib.h>
# include <string.h>
# include "method.h"
# include "log.h"
}
#else
# include "method.h"
# include "log.h"
#endif

extern CORBA_Boolean CORBA_shutdown;
extern CorbaMethod methods[];

typedef struct tParam {
   short fParamType;
   short fCType;
   short fSqlType;
   unsigned long cbColDef;
   short ibScale;
   CORBA_Any *any;
   long cbValueMax;
   long pcbValue;
} Param;

typedef struct tDataIn {
   unsigned short icol;
   short fCType;
   long cbValueMax;
} DataIn;

typedef struct tDataOut {
   CORBA_Any *any;
   long pcbValue;
} DataOut;

typedef struct tCommAttr {
   long length;
   long type;
   long precision;
   long scale;
} CommAttr;

extern CORBA_TCKindDesc BindColOut_seq;
extern CORBA_TCKindDesc TCD_any_seq;
extern CORBA_TCKindDesc CommAttr_seq;
extern CORBA_TCKindDesc UShortSeq;

extern CORBA_TCKindDesc * anyType (HSTMT , unsigned short , short *);

void
i_SQLError (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[4] = malloc(5 + 1);
   argv[5] = malloc(sizeof (CORBA_Long));
   argv[6] = malloc(*(CORBA_Short *)argv[7]);
   argv[8] = malloc(sizeof (CORBA_Short));
   *((CORBA_Long *) argv[0]) = SQLError (*(HENV *) argv[1],
                                         *(HDBC *) argv[2],
                                         *(HSTMT *) argv[3],
                                          (unsigned char *)  argv[4],
                                          (CORBA_Long *) argv[5],
                                          (unsigned char *)  argv[6],
                                         *(CORBA_Short *) argv[7],
                                          (CORBA_Short *) argv[8]);
}

void
i_SQLTables (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   unsigned char *szTableType = (unsigned char *) argv[8];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[9] == SQL_NULL_DATA)
       szTableType = (unsigned char *) 0;

   *((CORBA_Long *) argv[0]) = SQLTables (*(HSTMT *) argv[1],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szTableName,
                                          *(CORBA_Short *) argv[7],
                                           szTableType,
                                          *(CORBA_Short *) argv[9]);
}

void
i_SQLExecDirect (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLExecDirect (*(HSTMT *) argv[1],
                                               (unsigned char *) argv[2],
                                              *(CORBA_Long *) argv[3]);
}

void
i_SQLExecDirectParams (void **argv)
{
   register int i;
   CORBA_Sequence *parSeq = (CORBA_Sequence *) argv[4];
   Param *par;
   long *Return;
   void *chArray;
   argv[0] = malloc(sizeof (CORBA_Long));
   Return = (CORBA_Long *)argv[0];

   for (*Return = SQL_SUCCESS, i = 0;
        *Return == SQL_SUCCESS && i < parSeq->count; i++) {
      par = (Param *)parSeq->data[i];
      if (par->any->tcIn->kind == tk_Principal)
         chArray = (void*)((CORBA_Principal *)par->any->data)->data;
      else if (par->any->tcIn->kind == tk_sequence)
         chArray = (void*)((CORBA_Sequence *)par->any->data)->data;
      else
         chArray = par->any->data;
      *Return = SQLBindParameter (*(HSTMT *) argv[1], i + 1,
                            par->fParamType,
                            par->fCType,
                            par->fSqlType,
                            par->cbColDef,
                            par->ibScale,
                            chArray,  /* rgbValue */
                            par->cbValueMax,
                            &par->pcbValue);
   }
   if (*Return == SQL_SUCCESS)
      *((CORBA_Long *) argv[0]) = SQLExecDirect (*(HSTMT *) argv[1],
                                               (unsigned char *) argv[2],
                                              *(CORBA_Long *) argv[3]);
}

void
i_SQLPrepare (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLPrepare (*(HSTMT *) argv[1],
                                           (unsigned char *) argv[2],
                                          *(CORBA_Long *) argv[3]);
}

void
i_SQLExecute (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLExecute (*(HSTMT *) argv[1]);
}

void
i_SQLExecuteParams (void **argv)
{
   register int i;
   CORBA_Sequence *parSeq = (CORBA_Sequence *) argv[2];
   Param *par;
   long *Return;
   void *chArray;
   argv[0] = malloc(sizeof (CORBA_Long));
   Return = (CORBA_Long *)argv[0];

   Log ("SQLExecuteParam n_params=%d", parSeq->count);
   for (*Return = SQL_SUCCESS, i = 0;
        *Return == SQL_SUCCESS && i < parSeq->count; i++) {
      Log ("SQLExecuteParam i=%d", i);
      par = (Param *)parSeq->data[i];
      if (par->any->tcIn->kind == tk_Principal)
         chArray = (void*)((CORBA_Principal *)par->any->data)->data;
      else if (par->any->tcIn->kind == tk_sequence)
         chArray = (void*)((CORBA_Sequence *)par->any->data)->data;
      else
         chArray = par->any->data;

      *Return = SQLBindParameter (*(HSTMT *) argv[1], i + 1,
                            par->fParamType,
                            par->fCType,
                            par->fSqlType,
                            par->cbColDef,
                            par->ibScale,
                            chArray,  /* rgbValue */
                            par->cbValueMax,
                            &par->pcbValue);
      Log ("SQLExecuteParam i=%d", par->fSqlType);
      if (par->fSqlType == SQL_CHAR)
         Log ("BindParameter rc=%ld, hstmt=%ld, data=%s",
                                                *((CORBA_Long *) argv[0]),
                                                *((CORBA_Long *) argv[1]),
                                                par->any->data);
      else
         Log ("BindParameter rc=%ld, hstmt=%ld, type=%s",
                                                *((CORBA_Long *) argv[0]),
                                                *((CORBA_Long *) argv[1]),
                                                par->fSqlType);
      Log ("SQLExecuteParam i=%d", par->fSqlType);
   }
   if (*Return == SQL_SUCCESS)
      *((CORBA_Long *) argv[0]) = SQLExecute (*(HSTMT *) argv[1]);
}

void
i_SQLNumResultCols (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof (CORBA_Short));
   *((CORBA_Long *) argv[0]) = SQLNumResultCols (*(HSTMT *) argv[1],
                                                  (CORBA_Short *) argv[2]);
}

void
i_SQLRowCount (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLRowCount (*(HSTMT *) argv[1],
                                             (CORBA_Long *) argv[2]);
}

void
i_SQLDescribeCol (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[3] = malloc(*(CORBA_Short *)argv[4]);
   argv[5] = malloc(sizeof(CORBA_Short));
   argv[6] = malloc(sizeof(CORBA_Short));
   argv[7] = malloc(sizeof(CORBA_ULong));
   argv[8] = malloc(sizeof(CORBA_Short));
   argv[9] = malloc(sizeof(CORBA_Short));

   *((CORBA_Long *) argv[0]) = SQLDescribeCol (*(HSTMT *) argv[1],
                                               *(CORBA_UShort *) argv[2],
                                                (unsigned char *) argv[3],
                                               *(CORBA_Short *) argv[4],
                                                (CORBA_Short *) argv[5],
                                                (CORBA_Short *) argv[6],
                                                (CORBA_ULong *) argv[7],
                                                (CORBA_Short *) argv[8],
                                                (CORBA_Short *) argv[9]);
}

void
i_SQLFetch (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLFetch (*(HSTMT *) argv[1]);
   if (*((CORBA_Long *) argv[0]) == SQL_SUCCESS)
      *((CORBA_Long *) argv[0]) = SQLColAttributes( *(HSTMT *) argv[1],
                                  0, 0, 0, 0, 0, (CORBA_Long *) argv[2]);
}

void
i_SQLExtendedFetch (void **argv)
{
   CORBA_Sequence *seqOut;
   unsigned long rowSetSize;
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[4] = malloc(sizeof (CORBA_ULong));
   // argv[5] = malloc(sizeof (CORBA_UShort));
   argv[6] = malloc(sizeof (CORBA_Long));

   
   if (*((CORBA_Long *) argv[0]) = SQLGetStmtOption (*(HSTMT *) argv[1],
                                 SQL_ROWSET_SIZE, &rowSetSize) == SQL_ERROR)
      return;
   seqOut=(CORBA_Sequence*)(argv[5]=CORBA_Object_new (&UShortSeq, rowSetSize));

   *((CORBA_Long *) argv[0]) = SQLExtendedFetch (*(HSTMT *) argv[1],
                                                 *(CORBA_UShort *) argv[2],
                                                 *(CORBA_Long *) argv[3],
                                                  (CORBA_ULong *) argv[4],
                                               (CORBA_UShort *) seqOut->data);
   if (*((CORBA_Long *) argv[0]) == SQL_SUCCESS)
      *((CORBA_Long *) argv[0]) = SQLColAttributes(*(HSTMT *) argv[1],
                                  0, 0, 0, 0, 0, (CORBA_Long *) argv[6]);
}

void
i_SQLFetchBindCol (void **argv)
{
   CORBA_Long *Return;
   CORBA_Sequence *seqOut;
   CORBA_Long numCols;
   CORBA_Sequence *seqIn = (CORBA_Sequence *) argv[2];
   CORBA_UShort i;
   DataIn *dIn;
   DataOut *dOut;
   int warning = 0;

   argv[0] = malloc(sizeof (CORBA_Long));
   Return =  (CORBA_Long *)argv[0];
   argv[3] = CORBA_Object_new (&BindColOut_seq, seqIn->count);
   seqOut = (CORBA_Sequence *) argv[3];
   for (i = 0; i < seqIn->count; i++) {
      dIn = (DataIn *)seqIn->data[i];
      dOut = (DataOut *)seqOut->data[i];
      dOut->any = (CORBA_Any *) CORBA_Object_new (&TCD_any, 0);
      dOut->any->tcIn = anyType (*(HSTMT *) argv[1], dIn->icol, &dIn->fCType);
      dOut->any->data = malloc (dIn->cbValueMax);
      memset (dOut->any->data, 0, dIn->cbValueMax);
   }
   *Return = SQLFetch (*(HSTMT *) argv[1]);
   if (*Return == SQL_SUCCESS) {
      *Return = SQLColAttributes( *(HSTMT *) argv[1], 0, 0, 0, 0, 0, &numCols);
      if (*Return == SQL_SUCCESS) {
         for (i = 0 ; i < seqOut->count; i++) {
            dIn = (DataIn *)seqIn->data[i];
            dOut = (DataOut *)seqOut->data[i];
            if (dIn->icol <= numCols) {
               if ((*Return = SQLGetData (*(HSTMT *) argv[1], dIn->icol,
                          dIn->fCType, dOut->any->data,
                          dIn->cbValueMax, &dOut->pcbValue)) == SQL_ERROR) {
                  break;
               } else if (*Return == SQL_SUCCESS_WITH_INFO) {
                  warning = 1;
               }
            }
         }
      }
   }
   if (*Return != SQL_ERROR && warning)
      *Return = SQL_SUCCESS_WITH_INFO;
}

void
i_SQLExtendedFetchBindCol (void **argv)
{
}

void
i_SQLGetData (void **argv)
{
   CORBA_Any *any;
   unsigned char *chArray;
   CORBA_TCKindDesc *tcIn = anyType (*(HSTMT *) argv[1],
                                     *(CORBA_UShort *) argv[2],
                                     (CORBA_Short *) argv[3]);
   void * intObject = CORBA_Object_new (tcIn, *(CORBA_Long *)argv[5] + 1);
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[4] = any = (CORBA_Any *) CORBA_Object_new (&TCD_any, 0);
   any->tcIn = tcIn;
   any->data = intObject;
   // ((unsigned char *) any->data)[*(CORBA_Long *)argv[5]] = 0;
   argv[6] = malloc(sizeof (CORBA_Long));

   if (tcIn->kind == tk_Principal)
       chArray = (unsigned char *) ((CORBA_Principal *) intObject)->data;
   else if (tcIn->kind == tk_sequence)
       chArray = (unsigned char *) ((CORBA_Sequence *) intObject)->data;
   else
       chArray = (unsigned char *) intObject;
   *((CORBA_Long *) argv[0]) = SQLGetData (*(HSTMT *) argv[1],
                                           *(CORBA_UShort *) argv[2],
                                           *(CORBA_Short *) argv[3],
                                            chArray,
                                           *(CORBA_Long *) argv[5],
                                            (CORBA_Long *) argv[6]);
}

# define MAXDATALEN 32767

void
i_SQLGetAllData (void **argv)
{
   int i;
   long Return = SQL_SUCCESS;
   long pcbValue;
   CORBA_Any *any;
   short fCType;
   CORBA_Sequence *seqOut;
   CORBA_Sequence *seqAttr;
   void * hstmt = (void *) *(CORBA_ULong *) argv[1];
   CORBA_Short ncol;
   unsigned char *buffer = (unsigned char *) malloc (MAXDATALEN + 1);
   CommAttr *attr;

   argv[0] = malloc(sizeof (CORBA_Long));
   if ((Return = SQLNumResultCols (hstmt, &ncol)) == SQL_ERROR)
      ncol = 1;

   argv[2] = CORBA_Object_new (&TCD_any_seq, ncol);
   seqOut = (CORBA_Sequence *) argv[2];
   argv[3] = CORBA_Object_new (&CommAttr_seq, ncol);
   seqAttr = (CORBA_Sequence *) argv[3];
   for (i = 0, Return = SQL_SUCCESS; i < ncol && Return != SQL_ERROR; i++) {
      fCType = SQL_C_DEFAULT;
      any = (CORBA_Any *) seqOut->data[i];
      attr = (CommAttr *) seqAttr->data[i];
      any->tcIn = anyType (hstmt, i + 1, &fCType);
      attr->type = fCType;
      Return = SQLGetData (hstmt, i + 1, fCType,buffer,MAXDATALEN,&pcbValue);
      attr->length = pcbValue;

      if (pcbValue < 0 || Return == SQL_ERROR) {
         any->tcIn = &TCD_null;
         any->data = 0;
      } else if (any->tcIn->kind == tk_Principal) {
         CORBA_Principal *intObject=
                (CORBA_Principal *) CORBA_Object_new(&TCD_Principal, pcbValue);
         long dummy;

         if (Return == SQL_SUCCESS_WITH_INFO) {
            memcpy (intObject->data, buffer, MAXDATALEN);
            Return = SQLGetData (hstmt, i + 1, fCType,
                                 &intObject->data[MAXDATALEN],
                                 pcbValue - MAXDATALEN, &dummy);
         } else {
            memcpy (intObject->data, buffer, pcbValue);
         }
         any->data = intObject;
      } else if (any->tcIn->kind == tk_sequence) {
         CORBA_Sequence *intObject=
                (CORBA_Sequence *) CORBA_Object_new(&TCD_sequence, pcbValue);
         long dummy;

         if (Return == SQL_SUCCESS_WITH_INFO) {
            memcpy (intObject->data, buffer, MAXDATALEN);
            Return = SQLGetData (hstmt, i + 1, fCType,
                                 &intObject->data[MAXDATALEN],
                                 pcbValue - MAXDATALEN, &dummy);
         } else {
            memcpy (intObject->data, buffer, pcbValue);
         }
         any->data = intObject;
      } else {
         any->data = malloc (pcbValue + 1);
         memcpy (any->data, buffer, pcbValue);
         ((char *) any->data)[pcbValue] = 0;
      }
      if (Return != SQL_ERROR) {
/*      
         SQLColAttributes(hstmt, i + 1, SQL_COLUMN_LENGTH,
                                        0, 0, 0, &(attr->length));
*/      
         SQLColAttributes(hstmt, i + 1, SQL_COLUMN_PRECISION,
                                        0, 0, 0, &(attr->precision));
         SQLColAttributes(hstmt, i + 1, SQL_COLUMN_SCALE,
                                        0, 0, 0, &(attr->scale));
      }
   }
   for ( ;i < ncol; i++) {
      any = (CORBA_Any *) seqOut->data[i];
      any->tcIn = &TCD_null;
      any->data = 0;
   }
   *((CORBA_Long *) argv[0]) = Return;
   free (buffer);
}

void
i_SQLFreeStmt (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLFreeStmt (*(HSTMT *) argv[1],
                                            *(CORBA_UShort *) argv[2]);
}

void
i_SQLAllocEnv (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[1] = malloc(sizeof (CORBA_ULong));
   *((CORBA_Long *) argv[0]) = SQLAllocEnv ((HENV *) argv[1]);
}

void
i_SQLAllocConnect (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof (CORBA_ULong));
   *((CORBA_Long *) argv[0]) = SQLAllocConnect (*(HENV *) argv[1],
                                                 (HDBC *) argv[2]);
   Log ("AllocConnect rc=%ld, henv=%ld, hdbc=%ld", *((CORBA_Long *) argv[0]),
                                                   *((CORBA_Long *) argv[1]),
                                                   *((CORBA_Long *) argv[2]));
}

void
i_SQLConnect (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLConnect (*(HDBC *) argv[1],
                                            (unsigned char *) argv[2],
                                           *(CORBA_Short *) argv[3],
                                            (unsigned char *) argv[4],
                                           *(CORBA_Short *) argv[5],
                                            (unsigned char *) argv[6],
                                           *(CORBA_Short *) argv[7]);
   Log ("AllocConnect rc=%ld, hdbc=%ld", *((CORBA_Long *) argv[0]),
                                         *((CORBA_Long *) argv[1]));
}

void
i_SQLAllocStmt (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof (CORBA_ULong));
   *((CORBA_Long *) argv[0]) = SQLAllocStmt (*(HDBC *) argv[1],
                                              (HSTMT *) argv[2]);
}

void
i_SQLDisconnect (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLDisconnect (*(HDBC *) argv[1]);
}

void
i_SQLFreeConnect (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLFreeConnect (*(HDBC *) argv[1]);
   CORBA_shutdown  = CORBA_True;
}

void
i_SQLFreeEnv (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLFreeEnv (*(HENV *) argv[1]);
}

void
i_SQLCancel (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLCancel (*(HSTMT *) argv[1]);
}

void
i_SQLColAttributes (void **argv)
{
   CORBA_Principal *p;
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[4] = p = (CORBA_Principal *)
                 CORBA_Object_new (&TCD_Principal, *(CORBA_Short *)argv[5]) ;
   argv[6] = malloc(sizeof (CORBA_Short));
   argv[7] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLColAttributes (*(HSTMT *) argv[1],
                                                 *(CORBA_UShort *) argv[2],
                                                 *(CORBA_UShort *) argv[3],
                                                  (unsigned char *) p->data,
                                                 *(CORBA_Short *) argv[5],
                                                  (CORBA_Short *) argv[6],
                                                  (CORBA_Long *) argv[7]);
}

void
i_SQLColumns (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   unsigned char *szColumnName = (unsigned char *) argv[8];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[9] == SQL_NULL_DATA)
       szColumnName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLColumns (*(HSTMT *) argv[1],
                                            szTableQualifier,
                                           *(CORBA_Short *) argv[3],
                                            szTableOwner,
                                           *(CORBA_Short *) argv[5],
                                            szTableName,
                                           *(CORBA_Short *) argv[7],
                                            szColumnName,
                                           *(CORBA_Short *) argv[9]);
}

void
i_SQLGetConnectOption (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[3] = malloc(256+1);
   argv[4] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLGetConnectOption (*(HDBC *) argv[1],
                                                    *(CORBA_UShort *) argv[2],
                                                     argv[3]);
   *(CORBA_Long *) argv[4] = *(CORBA_Long *) argv[3];
}

void
i_SQLSetConnectOption (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   if (argv[3])
      *((CORBA_Long *) argv[0]) = SQLSetConnectOption (*(HDBC *) argv[1],
                                                       *(CORBA_UShort *)argv[2],
                                                       (CORBA_Long)argv[3]);
   else
      *((CORBA_Long *) argv[0]) = SQLSetConnectOption (*(HDBC *) argv[1],
                                                       *(CORBA_UShort *)argv[2],
                                                       *(CORBA_Long *)argv[4]);
}

void
i_SQLGetStmtOption (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[3] = malloc(256+1);
   argv[4] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLGetStmtOption (*(HDBC *) argv[1],
                                                 *(CORBA_UShort *) argv[2],
                                                 argv[3]);
   *(CORBA_Long *) argv[4] = *(CORBA_Long *) argv[3];
}

void
i_SQLSetStmtOption (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   if (argv[3])
      *((CORBA_Long *) argv[0]) = SQLSetStmtOption (*(HDBC *) argv[1],
                                                    *(CORBA_UShort *)argv[2],
                                                     (CORBA_Long)argv[3]);
   else
      *((CORBA_Long *) argv[0]) = SQLSetStmtOption (*(HDBC *) argv[1],
                                                    *(CORBA_UShort *)argv[2],
                                                    *(CORBA_Long *)argv[4]);
}

void
i_SQLTransact (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLTransact (*(HENV *) argv[1],
                                            *(HDBC *) argv[2],
                                            *(CORBA_UShort *) argv[3]);
}

void
i_SQLStatistics (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLStatistics (*(HSTMT *) argv[1],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szTableName,
                                          *(CORBA_Short *) argv[7],
                                          *(CORBA_UShort *) argv[8],
                                          *(CORBA_UShort *) argv[9]);
}

void
i_SQLSpecialColumns (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[3];
   unsigned char *szTableOwner = (unsigned char *) argv[5];
   unsigned char *szTableName = (unsigned char *) argv[7];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[4] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[6] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[8] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLSpecialColumns (*(HSTMT *) argv[1],
                                          *(CORBA_UShort *) argv[2],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[4],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[6],
                                           szTableName,
                                          *(CORBA_Short *) argv[8],
                                          *(CORBA_UShort *) argv[9],
                                          *(CORBA_UShort *) argv[10]);
}

void
i_SQLGetTypeInfo (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   *((CORBA_Long *) argv[0]) = SQLGetTypeInfo (*(HSTMT *) argv[1],
                                               *(CORBA_Short *)argv[2]);
}

void
i_SQLGetCursorName (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(*(CORBA_Short *)argv[3]);
   argv[4] = malloc(sizeof(CORBA_Short));

   *((CORBA_Long *) argv[0]) = SQLGetCursorName (*(HSTMT *) argv[1],
                                                (unsigned char *) argv[2],
                                               *(CORBA_Short *) argv[3],
                                                (CORBA_Short *) argv[4]);
}

void
i_SQLSetCursorName (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));

   *((CORBA_Long *) argv[0]) = SQLSetCursorName (*(HSTMT *) argv[1],
                                                (unsigned char *) argv[2],
                                               *(CORBA_Short *) argv[3]);
}

void
i_SQLPutData (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));

   *((CORBA_Long *) argv[0]) = SQLPutData (*(HSTMT *) argv[1],
                                            ((CORBA_Principal *)argv[2])->data,
                                           *(CORBA_Long *)argv[3]);
}

void
i_SQLNumParams (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[2] = malloc(sizeof(CORBA_Short));

   *((CORBA_Long *) argv[0]) = SQLNumParams (*(HSTMT *) argv[1],
                                              (CORBA_Short *) argv[2]);
}

void
i_SQLBindParameter (void **argv)
{
   CORBA_Any *any = (CORBA_Any *) argv[8];
   argv[0] = malloc(sizeof (CORBA_Long));
   any->tcIn = any->tcOut;
   Log ("in BindParameter #2 [%d]", *(CORBA_UShort *)  argv[2]);
   Log ("in BindParameter #3 [%d]", *(CORBA_Short *)  argv[3]);
   Log ("in BindParameter #4 [%d]", *(CORBA_Short *)  argv[4]);
   Log ("in BindParameter #5 [%d]", *(CORBA_Short *)  argv[5]);
   Log ("in BindParameter #6 [%d]", *(CORBA_ULong *)  argv[6]);
   Log ("in BindParameter #7 [%d]", *(CORBA_Short *)  argv[7]);
   Log ("in BindParameter #8 [%s]", any->data);
   Log ("in BindParameter #9 [%d]", *(CORBA_Long *)  argv[9]);
   Log ("in BindParameter #10[%d]", *(CORBA_Long *)  argv[10]);
   *((CORBA_Long *) argv[0]) = SQLBindParameter (*(HSTMT *) argv[1],
                                           *(CORBA_UShort *)argv[2],
                                           *(CORBA_Short *) argv[3],
                                           *(CORBA_Short *) argv[4],
                                           *(CORBA_Short *) argv[5],
                                           *(CORBA_ULong *) argv[6],
                                           *(CORBA_Short *) argv[7],
                                            (unsigned char *) any->data,
                                           *(CORBA_Long *)  argv[9],
                                            (CORBA_Long *)  argv[10]);
}

void
i_SQLTablePrivileges (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLTablePrivileges (*(HSTMT *) argv[1],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szTableName,
                                          *(CORBA_Short *) argv[7]);
}

void
i_SQLColumnPrivileges (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   unsigned char *szColumnName = (unsigned char *) argv[8];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[9] == SQL_NULL_DATA)
       szColumnName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLColumnPrivileges (*(HSTMT *) argv[1],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szTableName,
                                          *(CORBA_Short *) argv[7],
                                           szColumnName,
                                          *(CORBA_Short *) argv[9]);
}

void
i_SQLPrimaryKeys (void **argv)
{
   unsigned char *szTableQualifier = (unsigned char *) argv[2];
   unsigned char *szTableOwner = (unsigned char *) argv[4];
   unsigned char *szTableName = (unsigned char *) argv[6];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szTableName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLPrimaryKeys (*(HSTMT *) argv[1],
                                           szTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szTableName,
                                          *(CORBA_Short *) argv[7]);
}

void
i_SQLForeignKeys (void **argv)
{
   unsigned char *szPkTableQualifier = (unsigned char *) argv[2];
   unsigned char *szPkTableOwner = (unsigned char *) argv[4];
   unsigned char *szPkTableName = (unsigned char *) argv[6];
   unsigned char *szFkTableQualifier = (unsigned char *) argv[8];
   unsigned char *szFkTableOwner = (unsigned char *) argv[10];
   unsigned char *szFkTableName = (unsigned char *) argv[12];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szPkTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szPkTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szPkTableName = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[9] == SQL_NULL_DATA)
       szFkTableQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[11] == SQL_NULL_DATA)
       szFkTableOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[13] == SQL_NULL_DATA)
       szFkTableName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLForeignKeys (*(HSTMT *) argv[1],
                                           szPkTableQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szPkTableOwner,
                                          *(CORBA_Short *) argv[5],
                                           szPkTableName,
                                          *(CORBA_Short *) argv[7],
                                           szFkTableQualifier,
                                          *(CORBA_Short *) argv[9],
                                           szFkTableOwner,
                                          *(CORBA_Short *) argv[11],
                                           szFkTableName,
                                          *(CORBA_Short *) argv[13]);
}

void
i_SQLProcedures (void **argv)
{
   unsigned char *szProcQualifier = (unsigned char *) argv[2];
   unsigned char *szProcOwner = (unsigned char *) argv[4];
   unsigned char *szProcName = (unsigned char *) argv[6];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szProcQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szProcOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szProcName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLProcedures (*(HSTMT *) argv[1],
                                           szProcQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szProcOwner,
                                          *(CORBA_Short *) argv[5],
                                           szProcName,
                                          *(CORBA_Short *) argv[7]);
}

void
i_SQLProcedureColumns (void **argv)
{
   unsigned char *szProcQualifier = (unsigned char *) argv[2];
   unsigned char *szProcOwner = (unsigned char *) argv[4];
   unsigned char *szProcName = (unsigned char *) argv[6];
   unsigned char *szColumnName = (unsigned char *) argv[8];
   argv[0] = malloc(sizeof (CORBA_Long));
   if (*(CORBA_Short *) argv[3] == SQL_NULL_DATA)
       szProcQualifier = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[5] == SQL_NULL_DATA)
       szProcOwner = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[7] == SQL_NULL_DATA)
       szProcName = (unsigned char *) 0;
   if (*(CORBA_Short *) argv[9] == SQL_NULL_DATA)
       szColumnName = (unsigned char *) 0;
   *((CORBA_Long *) argv[0]) = SQLProcedureColumns (*(HSTMT *) argv[1],
                                           szProcQualifier,
                                          *(CORBA_Short *) argv[3],
                                           szProcOwner,
                                          *(CORBA_Short *) argv[5],
                                           szProcName,
                                          *(CORBA_Short *) argv[7],
                                           szColumnName,
                                          *(CORBA_Short *) argv[9]);
}

void
i_SQLDescribeParam (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));
   argv[3] = malloc(sizeof(CORBA_Short));
   argv[4] = malloc(sizeof(CORBA_ULong));
   argv[5] = malloc(sizeof(CORBA_Short));
   argv[6] = malloc(sizeof(CORBA_Short));

   *((CORBA_Long *) argv[0]) = SQLDescribeParam (*(HSTMT *) argv[1],
                                           *(CORBA_UShort *)argv[2],
                                            (CORBA_Short *) argv[3],
                                            (CORBA_ULong *) argv[4],
                                            (CORBA_Short *) argv[5],
                                            (CORBA_Short *) argv[6]);
}

void
i_SQLMoreResults (void **argv)
{
   argv[0] = malloc(sizeof (CORBA_Long));

   *((CORBA_Long *) argv[0]) = SQLMoreResults (*(HSTMT *) argv[1]);
}
