/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "except.h"
#include "log.h"

static char *rcsid = "$Id: except.c,v 1.1 1999/06/03 11:41:11 picoSoft Exp $";
static char *rcsidh = except_h;

Exception *
Exception_new()
{
   Exception *this = (Exception *)malloc (sizeof(Exception));
   if (this) {
      this->code = 0;
      this->description = 0;
      this->file = 0;
      this->line = 0;
      this->status = CORBA_False;
   }
   return this;
}

void
Exception_delete(Exception *this)
{
   if (this) {
      if (this->description)
         free(this->description);
      if (this->file)
         free(this->file);
      free(this);
   }
}


void
Exception_setFull (Exception *this, ErrorCode cod,char *des, char *fil, int lin)
{
   if (this->description)
      free(this->description);
   if (this->file)
      free(this->file);
   this->code = cod;
   if (des)
      this->description = strdup(des);
   else
      this->description = strdup ("(void descr. string)");
   this->file = strdup(fil);
   this->line = lin;
   this->status = CORBA_True;
}

void
Exception_print (Exception *this)
{
   if (this->status) {
      fprintf (stderr, "Exception #%d", (int)this->code);
      if (this->description)
         fprintf (stderr, ", %s", this->description);
      if (this->file)
         fprintf (stderr, ", file=%s", this->file);
      fprintf (stderr, ", line=%d\n", this->line);
   } else {
      fprintf (stderr, "NULL Exception\n");
   }
}

void
Exception_log (Exception *this)
{
   char error[128];
   if (this->status) {
      sprintf (error, "Exception #%d", (int)this->code);
      if (this->description)
         sprintf (error, ", %s", this->description);
      if (this->file)
         sprintf (error, ", file=%s", this->file);
      sprintf (error, ", line=%d\n", this->line);
   } else {
      sprintf (error, "NULL Exception\n");
   }
   Log (error);
}


