/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picocpp - basic objects library for picoSQL 

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef pobject_h
# define pobject_h "$Id: pobject.h 1.3 98/04/17 15:51:41 picoSoft Exp $"

typedef char PClassId;

class PObject
{
public:
   static PClassId Class; 
   typedef int (PObject::*PMethod)(void);
   virtual ~PObject () { }
   virtual int IsA(const PClassId &);
   virtual const char* NameOf();
   virtual const PClassId * IAm();
};

#define PMETHODOF(o,m)  (PMethod)(&o::m)

/*
   Questa macro definisce i dati necessari per poter identificare le classi
   a runtime; va inserita nella dichiarazione della classe come public
   argomenti sono il nome della classe e il padre
*/
# define PCLASS(c,p) \
public: \
   static PClassId Class; \
   virtual int IsA(const PClassId & p1) { if (&c::Class == &p1) \
                   return 1; \
                else \
                   return p::IsA(p1); \
               } \
   virtual const char *NameOf() { return #c; } \
   virtual const PClassId * IAm() { return &c::Class; } \
private:
# define PCLASSID(c) PClassId c::Class = 0;
# endif
