/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picocpp - basic objects library for picoSQL 

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef pstring_h
# define pstring_h "$Id: pstring.h 1.2 96/09/16 15:52:08 picoSoft Exp Locker: ROOT_DOS $"

# include "pobject.h"
# include "pmemman.h"
# include "plist.h"
# include "pstack.h"

#define MAX_STRING 256

class PMemManObj;

class PString : public PObject
{
   PCLASS(PString,PObject)
protected:
   PMemManObj *data;
public:
   PString();
   PString(const char *);
   PString(const PString&);
   PString(int, char);
   ~PString();
   char& operator[](long idx) const {
         char *Return = "";
         if (idx < size())
            Return = &gets()[idx];
         return *Return;
   }
   char& operator[](int i) const { return operator[] ((long) i); }

   long size() const { return data->sizeOf() == 0 ? 0 : data->sizeOf() - 1; }
   PString operator()(long start, long len) const; // substring start=0

   PString& toUpper();
   PString& toLower();

   int operator== (const char *s) const { return(compare(s) == 0); }
   int operator!= (const char *s) const { return(!(compare(s) == 0)); }
   int operator> (const char *s) const { return(compare(s) > 0); }
   int operator< (const char *s) const { return(compare(s) < 0); }
   int operator>= (const char *s) const { return(compare(s) >= 0); }
   int operator<= (const char *s) const { return(compare(s) <= 0); }

   int operator== (const PString &s) const { return(compare(s) == 0); }
   int operator!= (const PString &s) const { return(!(compare(s) == 0)); }
   int operator> (const PString &s) const { return(compare(s) > 0); }
   int operator< (const PString &s) const { return(compare(s) < 0); }
   int operator>= (const PString &s) const { return(compare(s) >= 0); }
   int operator<= (const PString &s) const { return(compare(s) <= 0); }

   int compare(const char *) const;
   int compare(const PString &) const;
    
   long concat(const char *, long len);
   long concatTo(PString *);
   long concat(const PString *);
   long concat(char);
   friend PString operator+ (const char *, const PString&);
   friend PString operator+ (const char, const PString&);
   PString operator+ (const char *) const;
   PString operator+ (const PString&) const;
   PString operator+ (char) const;

   PString& operator+= (const PString &s) { concat(&s); return(*this); }

   PString& operator+= (const char *s);

   PString& operator+= (char c) { concat(c); return(*this); }


   long prints(const char *...);
   char *gets() const;
# ifndef _MSC_VER
   operator char *() const { return(gets()); }
# endif
   long puts(const char *, int len);
   long puts(const char *);
   long puts(const PString *);


   PString & operator= (const PString &s) { if (this != &s)
                    puts(s.gets());
                        return(*this);
                   }
   PString& operator= (const char *s) { puts(s); return(*this); }
   PString& operator= (char);
   long ToLong();
   double ToDouble();
   friend PString ToPString(long);  
};

PLIST(PString);
PCOPYLIST(PString);
PTSTACK(PString);

#endif
