/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef corba_h
#define corba_h "$Id: corba.h,v 1.3 2002/05/06 10:20:21 picoSoft Exp $"

#define TAG_INTERNET_IOP 0
#define TAG_MULTIPLE_COMPONENTS 1

#define CORBA_True (1==1)
#define CORBA_False (1==0)

typedef int             CORBA_Boolean;
typedef unsigned char   CORBA_Octet;
typedef char            CORBA_Char;
typedef CORBA_Char     *CORBA_String;

typedef short           CORBA_Short;
typedef unsigned short  CORBA_UShort;

/* WARNING! Next 2 definitions are platform dependents */

typedef long            CORBA_Long;
typedef unsigned long   CORBA_ULong;

typedef float           CORBA_Float;
typedef double          CORBA_Double;

/*
 * Kinds of typecodes.  Do not change these enum values, or duplicate
 * them if you need to add values.  They are used to index tables, and
 * if you change the values you'll need to find and update all of those
 * tables.  The values are also part of the Common Data Representation,
 * and hence are part of IIOP and other ORB protocols.
 */

typedef enum tCORBA_TCKind {
    tk_null             = 0,
    tk_void             = 1,
    tk_short            = 2,
    tk_long             = 3,
    tk_ushort           = 4,
    tk_ulong            = 5,
    tk_float            = 6,
    tk_double           = 7,
    tk_boolean          = 8,
    tk_char             = 9,
    tk_octet            = 10,
    tk_any              = 11,
    tk_TypeCode         = 12,
    tk_Principal        = 13,
    tk_objref           = 14,
    tk_struct           = 15,
    tk_union            = 16,
    tk_enum             = 17,
    tk_string           = 18,
    tk_sequence         = 19,
    tk_array            = 20,
    tk_alias            = 21,
    tk_except           = 22,
    tk_longlong         = 23,
    tk_ulonglong        = 24,
    tk_longdouble       = 25,
    tk_wchar            = 26,
    tk_wstring          = 27,
    tk_fixed            = 28,
    TC_KIND_LAST
} CORBA_TCKind;

typedef struct tCORBA_TCKindDesc {
   CORBA_TCKind kind;
   CORBA_String name;
   struct tCORBA_TCKindDesc **suppl;
   int len; /* per array e affini */
} CORBA_TCKindDesc;

extern CORBA_TCKindDesc TCD_null;
extern CORBA_TCKindDesc TCD_void;
extern CORBA_TCKindDesc TCD_short;
extern CORBA_TCKindDesc TCD_long;
extern CORBA_TCKindDesc TCD_ushort;
extern CORBA_TCKindDesc TCD_ulong;
extern CORBA_TCKindDesc TCD_float;
extern CORBA_TCKindDesc TCD_double;
extern CORBA_TCKindDesc TCD_boolean;
extern CORBA_TCKindDesc TCD_char;
extern CORBA_TCKindDesc TCD_octet;
extern CORBA_TCKindDesc TCD_any;
extern CORBA_TCKindDesc TCD_TypeCode;
extern CORBA_TCKindDesc TCD_Principal;
extern CORBA_TCKindDesc TCD_objref;
extern CORBA_TCKindDesc TCD_struct;
extern CORBA_TCKindDesc TCD_union;
extern CORBA_TCKindDesc TCD_enum;
extern CORBA_TCKindDesc TCD_string;
extern CORBA_TCKindDesc TCD_sequence;
extern CORBA_TCKindDesc TCD_array;
extern CORBA_TCKindDesc TCD_alias;
extern CORBA_TCKindDesc TCD_KIND_LAST;

extern struct tFeature {
   int size;
   int align;
   CORBA_Boolean isPnt;
} Feature[];

typedef struct tCORBA_Principal {
   CORBA_Octet *data;
   CORBA_ULong size;
} CORBA_Principal;

typedef struct tCORBA_Sequence {
   CORBA_ULong count;
   void **data;
} CORBA_Sequence;

typedef struct tCORBA_TypeCode {
   CORBA_TCKindDesc *kdesc;
   CORBA_ULong seqLen;
   CORBA_Octet endian;
   CORBA_String repositoryId;
} CORBA_TypeCode;

typedef struct tCORBA_Any {
   CORBA_TCKindDesc *tcIn;
   void *data;
   CORBA_TCKindDesc *tcOut;
} CORBA_Any;

typedef struct tCORBA_Alias { /* gli alias sono solo letti !!*/
   CORBA_String repositoryId;
   CORBA_String name;
}CORBA_Alias;

void CORBA_init ();
void CORBA_Object_calcSize (const CORBA_TCKindDesc *k, CORBA_ULong *size);
void *CORBA_Object_new (const CORBA_TCKindDesc *tk, int size);
void CORBA_Object_delete (void *This, const CORBA_TCKindDesc *tk);
void CORBA_Object_debug (void *This, const CORBA_TCKindDesc *tk);
CORBA_TCKindDesc *CORBA_TCKindDesc_dup (const CORBA_TCKindDesc *tck);
void CORBA_TCKindDesc_delete (CORBA_TCKindDesc *tck);

/* Other types are not supported at the moment */

/*
   This variable is used to shutdown gracefully the
   server after the calling of some methods.
   This system does NOT work in multithreading
*/
extern CORBA_Boolean CORBA_shutdown;

#endif

