/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef giop_h
#define giop_h "$Id: giop.h,v 1.1 1999/06/03 11:42:53 picoSoft Exp $"
# include "corba.h"
# include "message.h"

# define GIOP_MAJ_VER 1
# define GIOP_MIN_VER 0

typedef enum tMsgType {
   Request = 0,
   Reply = 1,
   CancelRequest = 2,
   LocateRequest = 3,
   LocateReply = 4,
   CloseConnection = 5,
   MessageError = 6,
   Fragment = 7
} MsgType;

typedef enum tExceptionType {
    NO_EXCEPTION = 0,
    USER_EXCEPTION,
    SYSTEM_EXCEPTION,
    LOCATION_FORWARD
} ExceptionType;


typedef struct tMessageHeader {
   struct Version {
      CORBA_Octet major;
      CORBA_Octet minor;
   } giopVersion;
   CORBA_Boolean byteOrder;
   MsgType type;
   MsgType size;
} MessageHeader;

# define GIOP_HEADERSIZE 12
CORBA_ULong GiopHeader (Message *msg, MsgType t);
CORBA_Boolean GiopCheckHeader (MessageHeader *he, Message *);
    
#endif

