/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>
# include <string.h>
# include "except.h"
# include "iiopobj.h"
# include "method.h"
# include "listener.h"
# include "log.h"

static char *rcsid = "$Id: iiopmain.c,v 1.1 1999/06/03 11:42:53 picoSoft Exp $";
static char *usage = "usage: %s [-d -r -l logfile ] port\n";
extern CorbaMethod methods[];

static void
printUsage (char *s)
{
   fprintf (stderr, usage, s);
}

# ifdef WIN32
# include <io.h>
int myMain (int argc, char *argv[]);

int WINAPI WinMain (HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, 
                    int nCmdShow) 
{
   char *pnt;
   char **argv = malloc (lstrlen (lpCmdLine) / 2 + 2); /* max args */
   int argc = 0;
   int Return;

   _setmode(_fileno (stdin), _O_BINARY);
   _setmode(_fileno (stdout), _O_BINARY);

   argv[argc++] = "iiopmain";

   for (pnt = lpCmdLine; *pnt; ) {
      while (isspace(*pnt))
         *pnt++ = 0;
      if (*pnt) {
         if (*pnt == '"') {
            argv[argc++] = ++pnt;
            while (*pnt && *pnt != '"')
               pnt++;
         } else {
            argv[argc++] = pnt;
            while (*pnt && !isspace(*pnt))
               pnt++;
         }
         if (*pnt)
            *pnt++ = '\0';
      }
   }
      
   Return = myMain (argc, argv);

   return Return;
}

int myMain (int argc, char *argv[])
# else
int
main (int argc, char *argv[])
# endif
{
   IiopObj *obj;
   Exception *ex;
   Listener *srv;
   int port = 0;
   int i, j;
   CORBA_Boolean printObjRef = CORBA_False;
   CORBA_Boolean runAsDaemon = CORBA_False;
   CORBA_String logFile = 0;
   char *prgName;

   CORBA_init();
   prgName = argv[0];
   for (i = 1, j = 0; i < argc; i++) {
      if (argv[i][0] == '-') {
         for (j = 1; argv[i][j]; j++) {
            switch(argv[i][j]) {
            case 'r':
               printObjRef = CORBA_True;
               break;
            case 'l':
               if (argv[i][j+1]) {
                  logFile = &argv[i][j+1];
                  j += strlen (&argv[i][j+1]);
               } else {
                  if (++i < argc) {
                     logFile = argv[i];
                     j = strlen (argv[i]) - 1;
                  } else {
                     printUsage (prgName);
                     return 2;
                  }
               }
               break;
            case 'd':
               fprintf (stderr, "not supported yet!\n");
               break;
            default:
               printUsage (prgName);
               return 2;
               break;
            }
         }
      } else {
         if (port == 0)
            port = atoi (argv[i]);
         else {
            printUsage (prgName);
            return 2;
         }
      }
   }
   if (port == 0) {
      printUsage (prgName);
      return 2;
   }
/*
   printf ("port=%d\n", port);
   if (logFile)
      printf ("log =%s\n", logFile);
   printf ("ref =%d\n", printObjRef);
   printf ("daem=%d\n", runAsDaemon);
*/
   if (logFile)
      SetLogFile (logFile);
   obj = IiopObj_new (port, "picoRPC", 8);
   if (printObjRef) {
      char * objref = IiopObj_toString(obj);
      printf ("%s\n", objref);
      Log (objref);
      free (objref);
      if (!runAsDaemon)
         return 0;
   }

   ex = Exception_new();
   srv = Listener_new();
   Listener_go (srv, ex, methods, obj);
   if (Exception_isException (ex))
      Exception_log (ex);

   return 0;
}

