/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.swing.PropertyPage;
import org.I00acres.isql.util.iSQLConfig;

public abstract class AbstractPropertyPage
extends JPanel
implements PropertyPage {
    private static iSQLConfig conf = iSQLConfig.getInstance();
    private Hashtable propertyMap = new Hashtable(1);
    private boolean isModified = false;
    private boolean isLoaded = false;
    private PropertyChangeHandler propertyHandler = new PropertyChangeHandler();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean hasChangedProperties() {
        return this.isModified;
    }

    public void revertChangedState() {
        this.setModified(false);
    }

    protected void applyChanges() {
    }

    protected void updatePage() {
    }

    public void loadProperties() {
        Enumeration enumeration = this.propertyMap.keys();
        while (enumeration.hasMoreElements()) {
            JComponent c = (JComponent)enumeration.nextElement();
            String p = this.getPropertyForComponent(c);
            if (c instanceof JToggleButton) {
                ((JToggleButton)c).setSelected(conf.getBooleanProperty(p, false));
                continue;
            }
            if (c instanceof JComboBox) {
                ((JComboBox)c).setSelectedItem(conf.getProperty(p, ""));
                continue;
            }
            if (!(c instanceof JTextComponent)) continue;
            ((JTextComponent)c).setText(conf.getStringProperty(p, ""));
        }
        this.updatePage();
        this.isLoaded = true;
    }

    public void revertProperties() {
        this.isLoaded = false;
        this.loadProperties();
        this.revertChangedState();
    }

    protected synchronized void setModified(boolean f) {
        this.isModified = f;
    }

    protected synchronized void setLoaded(boolean f) {
        this.isLoaded = f;
    }

    public void saveProperties() {
        Enumeration enumeration = this.propertyMap.keys();
        while (enumeration.hasMoreElements()) {
            JComponent c = (JComponent)enumeration.nextElement();
            String p = this.getPropertyForComponent(c);
            if (c instanceof JToggleButton) {
                conf.setBooleanProperty(p, ((JToggleButton)c).isSelected());
                continue;
            }
            if (c instanceof JComboBox) {
                conf.setProperty(p, ((JComboBox)c).getSelectedItem().toString());
                continue;
            }
            if (!(c instanceof JTextComponent)) continue;
            conf.setProperty(p, ((JTextComponent)c).getText());
        }
        this.applyChanges();
    }

    public final JComponent getPageComponent() {
        return this;
    }

    protected abstract void initUI();

    public final void add(Component c, Object constraints) {
        this.add(c, constraints, this.getComponentCount());
    }

    public final void add(Component c, Object constraints, int index) {
        super.add(c, constraints, index);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(c, "addActionListener", clazz);
        if (c instanceof JTextComponent) {
            Document document = ((JTextComponent)c).getDocument();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("javax.swing.event.DocumentListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.addListener(document, "addDocumentListener", clazz2);
        } else {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("javax.swing.event.DocumentListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.addListener(c, "addDocumentListener", clazz3);
        }
    }

    protected String getPropertyForComponent(JComponent c) {
        return (String)this.propertyMap.get(c);
    }

    protected void setPropertyForComponent(JComponent c, String Property) {
        this.propertyMap.put(c, Property);
    }

    private void addListener(Object c, String event, Class type) {
        try {
            c.getClass().getMethod(event, type).invoke(c, this.propertyHandler);
        }
        catch (Throwable throwable) {}
    }

    public abstract String getPropertPageName();

    private class PropertyChangeHandler
    implements ActionListener,
    DocumentListener {
        PropertyChangeHandler() {
        }

        public void removeUpdate(DocumentEvent evt) {
            if (!AbstractPropertyPage.this.isModified && AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.isModified = true;
            }
        }

        public void insertUpdate(DocumentEvent evt) {
            if (!AbstractPropertyPage.this.isModified && AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.isModified = true;
            }
        }

        public void changedUpdate(DocumentEvent evt) {
            if (!AbstractPropertyPage.this.isModified && AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.isModified = true;
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (!AbstractPropertyPage.this.isModified && AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.isModified = true;
            }
        }
    }
}

