/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing.tree;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;

public class MetaDataModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode UNCACHED_NODE = new DefaultMutableTreeNode("UNCACHED", false);
    private DefaultMutableTreeNode mRoot;
    private DatabaseMetaData mMetaData;
    private Vector mTableTypes;
    private String mCatalog;
    private String mSchema;

    public MetaDataModel(DatabaseConnection pDBC) {
        super(new DefaultMutableTreeNode(pDBC.getConnectionName(), true));
        this.mMetaData = pDBC.getDatabaseInformation();
        this.mCatalog = pDBC.getCatalog();
        this.mRoot = (DefaultMutableTreeNode)this.getRoot();
        try {
            this.setSchema(this.mMetaData.getUserName());
        }
        catch (Throwable throwable) {
            this.setSchema(null);
        }
    }

    public synchronized int getTableTypeCount() {
        try {
            return this.mTableTypes.size();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public synchronized void setCatalog(String pCatalog) {
        this.setCatalog(pCatalog, true);
    }

    public synchronized void setCatalog(String pCatalog, boolean reload) {
        this.mCatalog = pCatalog != null ? new String(pCatalog.getBytes()) : null;
        if (reload) {
            this.reload();
        }
    }

    public synchronized void reload() {
        this.mRoot.removeAllChildren();
        this.initNodes();
        this.reload(this.mRoot);
    }

    public synchronized void setSchema(String pSchema) {
        this.setSchema(pSchema, true);
    }

    public synchronized void setSchema(String pSchema, boolean reload) {
        this.mSchema = pSchema != null ? new String(pSchema.getBytes()) : null;
        if (reload) {
            this.reload();
        }
    }

    private Vector getResultSetColumn(ResultSet pRS, String pColumnName) {
        Vector<String> lColumn = new Vector<String>(0, 1);
        try {
            while (pRS.next()) {
                lColumn.add(pRS.getString(pColumnName));
            }
            pRS.close();
        }
        catch (Exception exception) {}
        return lColumn;
    }

    private void addVector(DefaultMutableTreeNode Parent, Vector pNodes, boolean hasChildren) {
        Iterator lIterator = ((AbstractList)pNodes).iterator();
        while (lIterator.hasNext()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(lIterator.next(), hasChildren);
            this.insertNodeInto(node, Parent, 0);
            if (!hasChildren) continue;
            this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
        }
    }

    private synchronized void initNodes() {
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Procedures"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_User_Data_Types"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Data_Types"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Table_Types"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Catalogs"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Schemas"), false), this.mRoot, 0);
        this.insertNodeInto(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_General_Info"), false), this.mRoot, 0);
        this.addTableTypeNodes();
    }

    public synchronized void addTableTypeNodes() {
        try {
            this.mTableTypes = this.getResultSetColumn(this.mMetaData.getTableTypes(), "TABLE_TYPE");
            Iterator mType = ((AbstractList)((Vector)this.mTableTypes.clone())).iterator();
            while (mType.hasNext()) {
                Object obj = mType.next();
                try {
                    boolean flag = this.mMetaData.getTables(this.mCatalog, this.mSchema, null, new String[]{obj.toString()}).next();
                    if (flag) continue;
                    this.mTableTypes.remove(obj);
                }
                catch (Exception exception) {
                    this.mTableTypes.remove(obj);
                    this.mMetaData.getConnection().clearWarnings();
                }
            }
            this.addVector(this.mRoot, this.mTableTypes, true);
        }
        catch (Exception exception) {}
    }

    public synchronized boolean isTableTypeNode(DefaultMutableTreeNode node) {
        try {
            if (node.getLevel() > 1) {
                return this.mTableTypes.contains(node.getPath()[1].toString());
            }
            return this.mTableTypes.contains(node.getUserObject().toString()) && !node.isRoot();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized boolean isUnacachedNode(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
            return child.getUserObject().toString().equalsIgnoreCase(UNCACHED_NODE.getUserObject().toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void loadTableTypeNode(DefaultMutableTreeNode pParentNode, String TableType) {
        pParentNode.removeAllChildren();
        try {
            Iterator lTableList = ((AbstractList)this.getResultSetColumn(this.mMetaData.getTables(this.mCatalog, this.mSchema, null, new String[]{TableType}), "TABLE_NAME")).iterator();
            while (lTableList.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(lTableList.next(), true);
                this.insertNodeInto(node, pParentNode, 0);
                this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
            }
        }
        catch (Exception exception) {}
        this.reload(pParentNode);
    }

    public void loadColumnChildNodes(DefaultMutableTreeNode pParentNode) {
        pParentNode.removeAllChildren();
        try {
            String Table = pParentNode.getPath()[2].toString();
            Iterator lTableList = ((AbstractList)this.getResultSetColumn(this.mMetaData.getColumns(this.mCatalog, this.mSchema, Table, null), "COLUMN_NAME")).iterator();
            while (lTableList.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(lTableList.next(), true);
                this.insertNodeInto(node, pParentNode, 0);
            }
        }
        catch (Exception exception) {}
        this.reload(pParentNode);
    }

    public void loadTableChildNodes(DefaultMutableTreeNode pTableNode) {
        pTableNode.removeAllChildren();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Columns"), true);
        this.insertNodeInto(node, pTableNode, 0);
        this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
        try {
            if (this.mMetaData.getIndexInfo(this.mCatalog, this.mSchema, pTableNode.toString(), false, false).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Indicies"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getPrimaryKeys(this.mCatalog, this.mSchema, pTableNode.toString()).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Primary_Keys"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getExportedKeys(this.mCatalog, this.mSchema, pTableNode.toString()).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Exported_Keys"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getImportedKeys(this.mCatalog, this.mSchema, pTableNode.toString()).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Imported_Keys"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getVersionColumns(this.mCatalog, this.mSchema, pTableNode.toString()).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Version_Columns"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getTablePrivileges(this.mCatalog, this.mSchema, pTableNode.toString()).next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Table_Privileges"), false));
            }
        }
        catch (Exception exception) {}
        try {
            if (this.mMetaData.getColumnPrivileges(this.mCatalog, this.mSchema, pTableNode.toString(), "%").next()) {
                pTableNode.add(new DefaultMutableTreeNode(iSQLUtilites.getString("JDBC_Column_Privileges"), false));
            }
        }
        catch (Exception exception) {}
        this.reload(pTableNode);
    }
}

