/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.I00acres.isql.swing.SortableHeaderRenderer;
import org.I00acres.isql.swing.table.Sortable;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLFileView;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.util.xProperties;

public abstract class iSQLUtilites {
    public static final int TABLE_DBL_CLICK = 511;
    public static final int TABLE_CTRL_CLICK = 767;
    private static ResourceBundle res;
    private static boolean isXMLAvailable;
    private static boolean isJ2EEAvailable;
    private static final iSQLConfig config;
    static /* synthetic */ Class class$0;

    static {
        isXMLAvailable = false;
        isJ2EEAvailable = false;
        config = iSQLConfig.getInstance();
        try {
            res = ResourceBundle.getBundle("org.I00acres.isql.res.ResourceStrings");
        }
        catch (Throwable throwable) {
            System.err.println("** Fatal Error ** iSQL-Viewer Resource Strings are unavailable Exiting....");
            System.exit(-1);
        }
        try {
            Class.forName("javax.sql.DataSource", false, config.getXtraClassLoader());
            isJ2EEAvailable = true;
        }
        catch (Throwable throwable) {
            isJ2EEAvailable = false;
        }
    }

    public static boolean isJ2EEAvailable() {
        return isJ2EEAvailable;
    }

    public static void setLookAndFeel(String classname) {
        try {
            Class<?> c = Class.forName(classname, true, config.getXtraClassLoader());
            LookAndFeel laf = (LookAndFeel)c.newInstance();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                MetalLookAndFeel mlaf = (MetalLookAndFeel)UIManager.getLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, iSQLUtilites.getString("LAF_Error", classname));
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable t2) {
                iSQLUtilites.HandleException(t2, null, true);
                System.exit(-1);
            }
        }
    }

    public static void lockComponentToPerferredSize(JComponent c) {
        Dimension prefSize = c.getPreferredSize();
        c.setMaximumSize(prefSize);
        c.setMinimumSize(prefSize);
    }

    public static KeyStroke getLocalKeyStroke(String str) {
        return iSQLUtilites.getLocalKeyStroke(res, str);
    }

    public static KeyStroke getLocalKeyStroke(ResourceBundle bundle, String str) {
        try {
            return KeyStroke.getKeyStroke(bundle.getString(str));
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, "Couldn't Load Local Keystroke definition", false);
            return null;
        }
    }

    public static String getString(String str, String params) {
        return iSQLUtilites.getString(str, new String[]{params});
    }

    public static String getString(String str, String[] params) {
        StringBuffer buff = new StringBuffer(iSQLUtilites.getString(str));
        String s = buff.toString();
        int end = 0;
        int idx0 = 0;
        int idx1 = 0;
        end = s.lastIndexOf(36);
        if (end >= 0 && params != null) {
            while (idx0 <= end && end < s.length() - 1) {
                idx0 = s.indexOf(36, idx1);
                idx1 = idx0 + 1;
                while (idx1 < s.length()) {
                    if (!Character.isDigit(s.charAt(idx1))) break;
                    ++idx1;
                }
                try {
                    int x = -1;
                    x = Integer.parseInt(s.substring(idx0 + 1, idx1));
                    buff.replace(idx0, idx1, params[x]);
                    s = buff.toString();
                    end = s.lastIndexOf(36);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        buff.replace(idx0, idx1, "");
                        s = buff.toString();
                        end = s.lastIndexOf(36);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return buff.toString();
    }

    public static String getString(String str) {
        try {
            return res.getString(str);
        }
        catch (Throwable throwable) {
            System.out.println("** Warning ** Resource String [" + str + "] is not available.");
            return str;
        }
    }

    public static final URL getResourceURL(String item) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.I00acres.isql.iSQLViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResource("/org/I00acres/isql/res/".concat(item));
    }

    public static final Icon loadToolbarIconResource(String img) {
        int size = config.getBooleanProperty("General.UseLargeIcons") ? 24 : 16;
        return iSQLUtilites.loadIconResource(String.valueOf(img) + size);
    }

    public static final Icon loadIconResource(String img) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.I00acres.isql.iSQLViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new ImageIcon(clazz.getResource("/org/I00acres/isql/icons/" + img + ".png"));
        }
        catch (Throwable throwable) {
            System.err.println(iSQLUtilites.getString("Image_Load_Error", img));
            return UIManager.getIcon("InternalFrame.icon");
        }
    }

    public static void optimizeTableView(JTable Table) {
        if (Table == null) {
            return;
        }
        if (!(Table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jvp = (JViewport)Table.getParent();
        TableModel ref = Table.getModel();
        Table.setAutoResizeMode(0);
        Table.setModel(ref);
        int i = 0;
        while (i < Table.getColumnCount()) {
            Table.getColumnModel().getColumn(i).sizeWidthToFit();
            ++i;
        }
        JTable jTable = Table;
        synchronized (jTable) {
            if (Table.getPreferredSize().getWidth() <= jvp.getPreferredSize().getWidth()) {
                Table.setAutoResizeMode(4);
            }
        }
    }

    public static synchronized void removeSelectedColumns(JTable table) {
        if (table == null) {
            return;
        }
        DefaultTableModel cfr_ignored_0 = (DefaultTableModel)table.getModel();
        int[] cols = table.getSelectedColumns();
        int i = cols.length - 1;
        while (i >= 0) {
            table.removeColumn(table.getColumnModel().getColumn(cols[i]));
            --i;
        }
        cols = null;
        iSQLUtilites.optimizeTableView(table);
    }

    public static File saveSystemFile(Component owner) {
        JFileChooser jfc = new JFileChooser(config.getProperty("Session.LastFileLoc", System.getProperty("user.home")));
        jfc.setFileView(new iSQLFileView());
        jfc.setFileHidingEnabled(!config.getBooleanProperty("General.ShowHiddenFiles"));
        int res = jfc.showSaveDialog(owner);
        config.setProperty("Session.LastFileLoc", jfc.getCurrentDirectory().getAbsolutePath());
        if (res == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    public static File getSystemFile(Component owner) {
        JFileChooser jfc = new JFileChooser(config.getProperty("Session.LastFileLoc", System.getProperty("user.home")));
        jfc.setFileView(new iSQLFileView());
        jfc.setFileHidingEnabled(!config.getBooleanProperty("General.ShowHiddenFiles"));
        int res = jfc.showOpenDialog(owner);
        config.setProperty("Session.LastFileLoc", jfc.getCurrentDirectory().getAbsolutePath());
        if (res == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static synchronized void removeSelectedRows(JTable table) {
        if (table == null) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        int[] rows = table.getSelectedRows();
        int i = rows.length - 1;
        while (i >= 0) {
            model.removeRow(rows[i]);
            --i;
        }
        rows = null;
        model = null;
    }

    public static void HandleException(Throwable t) {
        iSQLUtilites.HandleException(t, null, false);
    }

    public static void HandleException(Throwable t, String msg) {
        iSQLUtilites.HandleException(t, msg, false);
    }

    public static void HandleException(Throwable t, String message, boolean debug) {
        if (message != null) {
            System.out.println(message);
        }
        String n = t.getClass().getName();
        n = n.substring(n.lastIndexOf(46) + 1);
        String s = iSQLUtilites.getString("Error");
        if (t instanceof Error) {
            s = iSQLUtilites.getString("Error");
        } else if (t instanceof RuntimeException) {
            s = iSQLUtilites.getString("Runtime_Exception");
        } else if (t instanceof Exception) {
            s = iSQLUtilites.getString("Exception");
        }
        if (t.getLocalizedMessage() != null) {
            System.out.println(String.valueOf(s) + " :: " + n + "(" + t.getLocalizedMessage().trim() + ")");
        } else {
            System.out.println(String.valueOf(s) + " :: " + n + "()");
        }
        if (debug) {
            t.printStackTrace();
        }
    }

    public static void showExceptionPopup(Component owner, Throwable t, String Message) {
        StringBuffer buff = new StringBuffer("");
        if (Message != null) {
            buff.append(String.valueOf(Message) + "\n");
        }
        String n = t.getClass().getName();
        n = n.substring(n.lastIndexOf(46) + 1);
        if (t.getLocalizedMessage() != null) {
            buff.append(String.valueOf(n) + "::(" + t.getLocalizedMessage().trim() + ")");
        } else {
            buff.append(String.valueOf(n) + "::()");
        }
        JOptionPane.showMessageDialog(owner, buff, iSQLUtilites.getString("Error"), 0);
    }

    public static KeyStroke createKeyStroke(int VK, int Mask) {
        return KeyStroke.getKeyStroke(VK, Mask, false);
    }

    public static void configureDatabaseConnection(xProperties xConfig) {
        DatabaseConnection.setFetchMode(xConfig.getBooleanProperty("JDBC.FetchReverse"));
        DatabaseConnection.setEscapeProcessingOn(xConfig.getBooleanProperty("JDBC.EscapeProcess"));
        DatabaseConnection.setLoginTimeout(xConfig.getIntProperty("JDBC.Login-TimeOut"));
        DatabaseConnection.setQueryTimeout(xConfig.getIntProperty("JDBC.Time-Out"));
        DatabaseConnection.setAutoReconnect(xConfig.getBooleanProperty("JDBC.Auto-Connect"));
        DatabaseConnection.setDebugOn(xConfig.getBooleanProperty("JDBC.Debug-Mode"));
        DatabaseConnection.setQueryEchoOn(xConfig.getBooleanProperty("JDBC.Log-Queries"));
        DatabaseConnection.setVerboseOn(xConfig.getBooleanProperty("JDBC.Verbose"));
    }

    public static void initLogging() {
        try {
            DriverManager.setLogWriter(null);
            String[] mComponentIDs = new String[]{"JDBC", "System.err"};
            int i = 0;
            while (i < mComponentIDs.length) {
                String fd;
                if (((Hashtable)config).containsKey("General.Log." + mComponentIDs[i]) && (fd = config.getStringProperty("General.Log." + mComponentIDs[i])).trim().length() != 0) {
                    boolean append = config.getBooleanProperty("General.Log." + mComponentIDs[i] + ".Append", false);
                    File f = new File(fd);
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    if (f.canWrite()) {
                        FileOutputStream fos = new FileOutputStream(fd, append);
                        switch (i) {
                            case 0: {
                                DriverManager.setLogWriter(new PrintWriter(fos, true));
                                break;
                            }
                            case 1: {
                                System.setErr(new PrintStream(fos, true));
                                break;
                            }
                            case 2: {
                                System.setOut(new PrintStream(fos, true));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public static void copySelectedCellsToClipBoard(JTable table) {
        if (table == null) {
            return;
        }
        StringBuffer buff = new StringBuffer("");
        try {
            table.getCellEditor().cancelCellEditing();
        }
        catch (Throwable throwable) {}
        StringBuffer row = new StringBuffer("");
        int r = 0;
        while (r < table.getRowCount()) {
            int c = 0;
            while (c < table.getColumnCount()) {
                if (table.isCellSelected(r, c)) {
                    row.append(table.getValueAt(r, c) + "\t");
                }
                ++c;
            }
            if (row.toString().trim().length() >= 1) {
                buff.append((Object)row);
                buff.append(System.getProperty("line.seperator", "\n"));
            }
            row.setLength(0);
            ++r;
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(buff.toString().trim());
        cb.setContents(ss, ss);
    }

    public static void restoreSystemOut() {
        PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
        System.setOut(out);
    }

    public static void restoreSystemErr() {
        PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.err));
        System.setErr(out);
    }

    public static class TableMouseAdapter
    extends MouseAdapter {
        private ActionListener actionFwd;

        public TableMouseAdapter(ActionListener notifyer) {
            this.actionFwd = notifyer;
        }

        public void mousePressed(MouseEvent e) {
            boolean isCtrlClick;
            Object src = e.getSource();
            boolean isShiftClick = (e.getModifiers() & 1) == 1;
            boolean bl = isCtrlClick = (e.getModifiers() & 2) == 2;
            if (src instanceof JTable) {
                JTable table = (JTable)e.getSource();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && !isShiftClick & !isCtrlClick) {
                    table.setRowSelectionAllowed(!table.getRowSelectionAllowed());
                    table.setColumnSelectionAllowed(!table.getColumnSelectionAllowed());
                    table.repaint();
                    if (this.actionFwd != null) {
                        this.actionFwd.actionPerformed(new ActionEvent(table, 511, ""));
                    }
                } else if (e.getClickCount() == 1 && isCtrlClick) {
                    int row = table.getSelectedRow();
                    int col = table.getSelectedColumn();
                    if (row < 0 || col < 0) {
                        return;
                    }
                    if (row >= 0 && col >= 0) {
                        table.clearSelection();
                    }
                    if (this.actionFwd != null) {
                        this.actionFwd.actionPerformed(new ActionEvent(table, 767, Integer.toString(col), row));
                    }
                } else if (SwingUtilities.isRightMouseButton(e) && table.getClientProperty("JPopupMenu") != null) {
                    JPopupMenu popupMenu = (JPopupMenu)table.getClientProperty("JPopupMenu");
                    popupMenu.show(table, e.getX(), e.getY());
                }
            } else if (src instanceof JTableHeader) {
                JTableHeader th = (JTableHeader)e.getSource();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && th.getTable().getModel() instanceof Sortable && th.getDefaultRenderer() instanceof SortableHeaderRenderer) {
                    int idx = th.columnAtPoint(e.getPoint());
                    int sci = ((SortableHeaderRenderer)th.getDefaultRenderer()).getRenderedSortedColumn();
                    boolean asc = ((SortableHeaderRenderer)th.getDefaultRenderer()).isAscending();
                    if (sci != idx) {
                        ((SortableHeaderRenderer)th.getDefaultRenderer()).setSortedColumn(idx, th.getTable(), true);
                    } else {
                        ((SortableHeaderRenderer)th.getDefaultRenderer()).setSortedColumn(sci, th.getTable(), !asc);
                    }
                    asc = ((SortableHeaderRenderer)th.getDefaultRenderer()).isAscending();
                    idx = ((SortableHeaderRenderer)th.getDefaultRenderer()).getSortedColumn();
                    Sortable mdl = (Sortable)((Object)th.getTable().getModel());
                    mdl.sort(idx, asc);
                }
            }
        }
    }
}

