/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.PicoConnection;
import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoResultSet;
import IT.picosoft.jdbc.PicoSQLWarning;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class PicoStatement
implements Statement {
    protected PicoDbApi odbcApi;
    protected OdbcStatement hStmt;
    protected SQLWarning lastWarning = null;
    protected ResultSet myResultSet;
    protected PicoConnection myConnection;

    public PicoStatement(PicoConnection picoConnection, PicoDbApi picoDbApi) throws SQLException {
        this.myConnection = picoConnection;
        this.odbcApi = picoDbApi;
        this.hStmt = new OdbcStatement(this.odbcApi, this.myConnection.getHDBC());
    }

    OdbcStatement getHSTMT() {
        return this.hStmt;
    }

    public void addBatch(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void cancel() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.cancel");
        }
        this.clearWarnings();
        try {
            this.odbcApi.SQLCancel(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected synchronized void clearMyResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.close hStmt=" + this.hStmt + ", rs=" + this.myResultSet + ", this=" + this);
        }
        if (!this.myConnection.isClosed()) {
            this.clearMyResultSet();
            try {
                this.clearWarnings();
                if (!this.hStmt.isDropped()) {
                    this.hStmt.drop();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute(String string) throws SQLException {
        boolean bl = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.execute (" + string + ")");
        }
        this.clearWarnings();
        this.reset();
        this.lockIfNecessary(string);
        try {
            this.odbcApi.SQLExecDirect(this.hStmt, string);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        int n = -1;
        n = this.getColumnCount();
        if (n > 0) {
            bl = true;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.execute nCol=" + n);
        }
        return bl;
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.executeQuery (" + string + ")");
        }
        ResultSet resultSet = null;
        if (!this.execute(string)) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.executeUpdate (" + string + ")");
        }
        int n = -1;
        if (this.execute(string)) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Statement.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int getColumnCount() throws SQLException {
        int n = 0;
        try {
            n = this.odbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxFieldSize() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getMaxFieldSize");
        }
        return this.getStmtOption((short)3);
    }

    public int getMaxRows() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getMaxRows");
        }
        return this.getStmtOption((short)1);
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getQueryTimeout");
        }
        return this.getStmtOption((short)0);
    }

    public ResultSet getResultSet() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getResultSet");
        }
        this.myResultSet = this.getResultSet(true);
        return this.myResultSet;
    }

    protected ResultSet getResultSet(boolean bl) throws SQLException {
        if (this.myResultSet != null) {
            throw new SQLException("Invalid state for getResultSet");
        }
        Object var2_2 = null;
        int n = 1;
        if (bl) {
            n = this.getColumnCount();
        }
        if (n > 0) {
            this.myResultSet = new PicoResultSet(this.odbcApi, this);
        } else {
            this.clearMyResultSet();
        }
        return this.myResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    protected int getRowCount() throws SQLException {
        int n = 0;
        try {
            n = this.odbcApi.SQLRowCount(this.hStmt);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    protected int getStmtOption(short s) throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.odbcApi.SQLGetStmtOption(this.hStmt, s);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return n;
    }

    public int getUpdateCount() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getUpdateCount");
        }
        int n = -1;
        if (this.getColumnCount() == 0) {
            n = this.getRowCount();
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getWarnings");
        }
        return this.lastWarning;
    }

    protected boolean lockIfNecessary(String string) throws SQLException {
        boolean bl = false;
        String string2 = string.toUpperCase();
        int n = string2.indexOf(" FOR UPDATE");
        if (n > 0) {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("Setting concurrency for update");
            }
            try {
                this.odbcApi.SQLSetStmtOption(this.hStmt, (short)7, 2);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            bl = true;
        }
        return bl;
    }

    protected void reset() throws SQLException {
        this.clearWarnings();
        if (this.myResultSet != null) {
            this.clearMyResultSet();
        } else {
            this.hStmt.close();
        }
    }

    public void setCursorName(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setEscapeProcessing (" + bl + ")");
        }
        int n = 0;
        if (!bl) {
            n = 1;
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)2, n);
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setMaxFieldSize (" + n + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)3, n);
    }

    public void setMaxRows(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setMaxRows (" + n + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)1, n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setQueryTimeout (" + n + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)0, n);
    }

    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.lastWarning = sQLWarning;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

