/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.I00acres.isql.swing.AbstractTableTool;
import org.I00acres.isql.swing.TableSelector;
import org.I00acres.isql.swing.table.IndexWizardModel;
import org.I00acres.isql.util.iSQLUtilites;

public class frmIndexWizard
extends AbstractTableTool
implements ActionListener,
TableModelListener,
CaretListener,
ChangeListener {
    private final Insets ins = new Insets(0, 0, 0, 0);
    private IndexWizardModel mTableModel = new IndexWizardModel();
    private JTable tabColumList = new JTable(this.mTableModel);
    private JTextField txtIndexName = new JTextField(16);
    private JPanel toolBox = new JPanel(new GridBagLayout());
    private TableSelector tableSelector = null;
    private JCheckBox mIsUnique = new JCheckBox();
    private StringBuffer mSQLBuffer = new StringBuffer();
    private boolean isEnabled = true;

    public frmIndexWizard() {
        try {
            this.initUI();
        }
        catch (Throwable throwable) {}
    }

    protected void connectionUpdated() {
        if (this.databaseConnection != null) {
            try {
                this.tableSelector = new TableSelector(this.databaseConnection.getDatabaseInformation(), true);
                this.mTableModel.setMetaData(this.databaseConnection.getDatabaseInformation());
                this.tableSelector.addChangeListener(this);
                this.toolBox.add((Component)this.tableSelector, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, this.ins, 0, 0));
            }
            catch (Throwable throwable) {}
        } else {
            this.tableSelector.updateMetaData(null);
        }
    }

    protected String getSQL() {
        return this.mSQLBuffer.toString();
    }

    public boolean validateTool() {
        return true;
    }

    protected void setToolEnabled(boolean f) {
        this.isEnabled = f;
        this.mIsUnique.setEnabled(f);
        this.tableSelector.setEnabled(f);
        this.tabColumList.setEnabled(f);
    }

    public void reset() {
        super.reset();
        this.txtIndexName.setText("");
        this.mIsUnique.setSelected(false);
        this.stateChanged(null);
        this.synch();
    }

    public String getToolName() {
        return iSQLUtilites.getString("Index_Wizard_Tool_Name");
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.isEnabled) {
            return;
        }
        Object src = evt.getSource();
        if (src == this.mIsUnique) {
            this.tableChanged(null);
            this.tabColumList.clearSelection();
        }
    }

    private synchronized void initUI() throws Exception {
        this.setLayout(new BorderLayout());
        this.mIsUnique.addActionListener(this);
        this.mIsUnique.setText(iSQLUtilites.getString("Create_Unique_Index"));
        this.toolBox.add((Component)new JLabel(iSQLUtilites.getString("Index_Name"), this.toIcon(), 2), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.ins, 0, 0));
        this.toolBox.add((Component)this.txtIndexName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, this.ins, 0, 0));
        this.toolBox.add((Component)this.mIsUnique, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, this.ins, 0, 0));
        this.txtIndexName.addCaretListener(this);
        this.tabColumList.setAutoResizeMode(4);
        this.add((Component)this.toolBox, "North");
        this.add((Component)new JScrollPane(this.tabColumList), "Center");
        this.mTableModel.addTableModelListener(this);
        this.mTableModel.setRowCount(0);
    }

    public void caretUpdate(CaretEvent e) {
        this.tableChanged(null);
    }

    public Icon toIcon() {
        return iSQLUtilites.loadIconResource("Information16");
    }

    public void tableChanged(TableModelEvent e) {
        if (!this.isEnabled) {
            return;
        }
        this.mSQLBuffer.setLength(0);
        String[] params = new String[]{this.mIsUnique.isSelected() ? iSQLUtilites.getString("SQL_UNIQUE") : "", this.txtIndexName.getText(), this.tableSelector.getSelectedTable()};
        this.mSQLBuffer.append(iSQLUtilites.getString("SQL_CREATE_INDEX", params));
        this.mSQLBuffer.append(" ( ");
        int i = 0;
        while (i < this.mTableModel.getRowCount()) {
            Boolean b = (Boolean)this.mTableModel.getValueAt(i, 1);
            if (b.booleanValue()) {
                this.mSQLBuffer.append(this.mTableModel.getValueAt(i, 0));
                this.mSQLBuffer.append(",");
            }
            ++i;
        }
        this.mSQLBuffer.setCharAt(this.mSQLBuffer.length() - 1, ' ');
        this.mSQLBuffer.append(")");
        this.updateSQL(this.mSQLBuffer.toString());
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.isEnabled) {
            return;
        }
        try {
            this.mTableModel.setCatalog(this.tableSelector.getSelectedCatalog());
            this.mTableModel.setSchema(this.tableSelector.getSelectedSchema());
            this.mTableModel.updateData(this.tableSelector.getSelectedTable());
        }
        catch (Throwable throwable) {}
    }
}

