/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.swing.CompoundIcon;

public class ResultSetContainer
extends JTabbedPane {
    public static final int ACTION_TAB_DBL_CLICKED = 64768;
    protected int maxtabcount = -1;
    private Hashtable iconCache;
    protected static final Icon lock = iSQLUtilites.loadIconResource("Lock16");
    protected static final Icon xicon = new TabCloseIcon();
    private transient Vector actionListeners;

    public ResultSetContainer() {
        this(1, 5);
    }

    public ResultSetContainer(int tabplacement) {
        this(tabplacement, 5);
    }

    public synchronized void removeAllTabs() {
        ResultSetContainer resultSetContainer = this;
        synchronized (resultSetContainer) {
            int i = this.getTabCount() - 1;
            while (i >= 0) {
                this.removeTabAt(i);
                --i;
            }
        }
    }

    public synchronized void removeUnlockedTabs() {
        ResultSetContainer resultSetContainer = this;
        synchronized (resultSetContainer) {
            int i = this.getTabCount() - 1;
            while (i >= 0) {
                if (!this.isTabLocked(i)) {
                    this.removeTabAt(i);
                }
                --i;
            }
        }
    }

    public String getSelectedToolTip() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            return this.getToolTipTextAt(tab);
        }
        return "";
    }

    public ResultSetContainer(int TabPlacement, int MaxTabCount) {
        super(TabPlacement);
        this.maxtabcount = MaxTabCount;
        this.iconCache = new Hashtable(this.maxtabcount);
        ResultContainerMouseAdapter ma = new ResultContainerMouseAdapter();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    public void addTab(String s, Component c) {
        this.addTab(s, null, c, null);
    }

    public void addTab(String s, Icon icon, Component c) {
        this.addTab(s, new CompoundIcon(xicon, icon), c, null);
    }

    public void setIconAt(int idx, Icon ico) {
        ((CompoundIcon)this.getIconAt(idx)).setRightIcon(ico);
        this.repaint(25L);
    }

    /*
     * Unable to fully structure code
     */
    public void setMaxTabCount(int newMax) {
        block2: {
            if (newMax < 1) {
                throw new IllegalArgumentException(Integer.toString(newMax));
            }
            if (newMax < this.maxtabcount) ** GOTO lbl7
            this.maxtabcount = newMax;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.removeTabAt(0);
lbl7:
                // 2 sources

                ** while (this.maxtabcount > newMax && this.getTabCount() > newMax)
            }
lbl8:
            // 1 sources

            this.maxtabcount = newMax;
        }
    }

    public void addTab(String s, Icon icon, Component c, String tip) {
        if (this.getTabCount() <= this.maxtabcount) {
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("isLocked", Boolean.FALSE);
            }
            super.addTab(s, new CompoundIcon(xicon, icon), c, tip);
        } else {
            int tab = this.locateFirstUnlockedTab();
            if (tab == -1) {
                this.removeTabAt(0);
            } else {
                this.removeTabAt(tab);
            }
            super.addTab(s, new CompoundIcon(xicon, icon), c, tip);
        }
    }

    public void removeSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.removeTabAt(tab);
        }
        this.fireStateChanged();
    }

    public void lockSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.lockTab(tab);
        }
    }

    public void unlockSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.unlockTab(tab);
        }
    }

    public void removeTabAt(int i) {
        this.iconCache.remove(this.getComponentAt(i));
        super.removeTabAt(i);
        this.fireStateChanged();
    }

    public boolean isTabLocked(int i) {
        if (i >= 0) {
            Component c = this.getComponent(i);
            if (c instanceof JComponent) {
                try {
                    return (Boolean)((JComponent)c).getClientProperty("isLocked");
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            return false;
        }
        throw new IllegalArgumentException(Integer.toString(i));
    }

    public void unlockTab(int i) {
        Component c;
        if (i >= 0 && this.isTabLocked(i) && (c = this.getComponent(i)) instanceof JComponent) {
            ((JComponent)this.getComponent(i)).putClientProperty("isLocked", Boolean.FALSE);
            this.setIconAt(i, (Icon)this.iconCache.get(this.getComponent(i)));
        }
    }

    public void lockTab(int i) {
        if (i >= 0 && !this.isTabLocked(i)) {
            Component c = this.getComponent(i);
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("isLocked", Boolean.TRUE);
                this.iconCache.put(c, ((CompoundIcon)this.getIconAt(i)).getRightIcon());
                this.setIconAt(i, lock);
            } else {
                throw new IllegalComponentStateException(iSQLUtilites.getString("Resultcontainer_Component_Error"));
            }
        }
    }

    private int locateFirstUnlockedTab() {
        int i = 0;
        while (i < this.getTabCount()) {
            if (!this.isTabLocked(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
                ++i;
            }
        }
    }

    private static class TabCloseIcon
    implements Icon {
        TabCloseIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getForeground());
            g.draw3DRect(x, y + 2, 13, 13, true);
            this.drawCheck(g, x, y + 2);
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return this.getIconHeight();
        }

        protected void drawCheck(Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(4, 3, 10, 9);
            g.drawLine(4, 4, 9, 9);
            g.drawLine(3, 4, 9, 10);
            g.drawLine(3, 9, 9, 3);
            g.drawLine(4, 9, 9, 4);
            g.drawLine(4, 10, 10, 4);
            g.fillRect(5, 5, 3, 3);
            g.translate(-x, -y);
        }
    }

    private class ResultContainerMouseAdapter
    extends MouseInputAdapter {
        ResultContainerMouseAdapter() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2 && ResultSetContainer.this.getSelectedIndex() >= 0) {
                ResultSetContainer.this.fireActionPerformed(new ActionEvent(this, 64768, ResultSetContainer.this.getSelectedToolTip(), e.getModifiers()));
            }
            if (ResultSetContainer.this.getTabCount() >= 1 && e.getClickCount() == 1 && ((CompoundIcon)ResultSetContainer.this.getIconAt(0)).isOverIcon(e.getX(), e.getY())) {
                ResultSetContainer.this.removeSelectedTab();
                ResultSetContainer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (ResultSetContainer.this.getTabCount() >= 1 && ((CompoundIcon)ResultSetContainer.this.getIconAt(0)).isOverIcon(e.getX(), e.getY())) {
                ResultSetContainer.this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            if (ResultSetContainer.this.getCursor().getType() != 0) {
                ResultSetContainer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

