/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.AnySequenceHolder;
import IT.picosoft.jdbc.CommAttr_seqHolder;
import IT.picosoft.jdbc.IOR;
import IT.picosoft.jdbc.JDBCPicoDb;
import IT.picosoft.jdbc.JDBCPicoDbHelper;
import IT.picosoft.jdbc.OctetSequenceHelper;
import IT.picosoft.jdbc.OctetSequenceHolder;
import IT.picosoft.jdbc.OdbcConnection;
import IT.picosoft.jdbc.OdbcDef;
import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.Param_item;
import IT.picosoft.jdbc.PicoBoundCol;
import IT.picosoft.jdbc.PicoBoundParam;
import IT.picosoft.jdbc.PicoSQLWarning;
import IT.picosoft.jdbc.PicoUtil;
import IT.picosoft.jdbc.Timestamp_struct;
import IT.picosoft.jdbc.Timestamp_structHelper;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.sql.DataTruncation;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;

public class PicoDbApi {
    public static final short SQL_NTS = -3;
    private static final String id = JDBCPicoDbHelper.id();
    private static final String key = "key";
    private ORB orb;
    private int hEnv = 0;
    public String charSet;
    private JDBCPicoDb server;
    private IntHolder returnCodeHolder = new IntHolder();
    private String sqlState = "";
    private String sqlErrMess = "";

    private JDBCPicoDb getCORBAServer(String string, int n) {
        return JDBCPicoDbHelper.narrow(this.orb.string_to_object(new IOR(id, string, n, key).toString()));
    }

    public static String getLocalHost() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public PicoDbApi() {
        if (DriverManager.getLogWriter() != null) {
            Date date = new Date();
            DriverManager.println("Jdbc PicoDb thin client");
            DriverManager.println("Current Date/Time: " + date.toString());
            DriverManager.println("Loading PicoDbApi library");
            DriverManager.println("orb = " + this.orb);
        }
        this.orb = ORB.init((String[])new String[0], null);
    }

    public void finalize() {
    }

    public int SQLAllocEnv() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLAllocEnv)");
        }
        return 1;
    }

    public int SQLAllocConnect(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLAllocConnect)");
        }
        return 1;
    }

    public int SQLAllocStmt(OdbcConnection odbcConnection) throws SQLException {
        int n = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("!--(SQLAllocStmt), hDbc=" + n);
        }
        IntHolder intHolder = new IntHolder();
        this.server.SQLAllocStmt(this.returnCodeHolder, n, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("hStmt=" + intHolder.value);
        }
        return intHolder.value;
    }

    public void SQLFreeEnv(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFreeEnv), hEnv=" + n);
        }
    }

    public void SQLFreeConnect(OdbcConnection odbcConnection) throws SQLException {
        int n;
        int n2 = n = odbcConnection != null ? odbcConnection.getHDBC() : 0;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFreeConnect), hDbc=" + n);
        }
        try {
            this.server.SQLFreeConnect(this.returnCodeHolder, n);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
    }

    public void SQLFreeStmt(OdbcStatement odbcStatement, short s) throws SQLException {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("!--(SQLFreeStmt), hStmt=" + n + ", fOption=" + s);
        }
        this.server.SQLFreeStmt(this.returnCodeHolder, n, s);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public void SQLDisconnect(OdbcConnection odbcConnection) throws SQLException {
        int n = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLDisconnect), hDbc=" + n);
        }
        this.server.SQLDisconnect(this.returnCodeHolder, n);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
    }

    public int SQLConnect(String string, String string2, String string3) throws SQLException, SQLWarning {
        int n;
        String string4 = PicoDbApi.getLocalHost();
        String string5 = "9876";
        String string6 = "default";
        IntHolder intHolder = new IntHolder();
        IntHolder intHolder2 = new IntHolder();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLConnect), this=" + this + " thread = " + Thread.currentThread());
        }
        if ((n = string.indexOf(58)) >= 0) {
            string4 = string.substring(0, n);
            int n2 = string.indexOf(58, n + 1);
            if (n2 >= 0) {
                string5 = string.substring(n + 1, n2);
                string6 = string.substring(n2 + 1);
            } else {
                string5 = string.substring(n);
            }
        } else {
            string4 = string;
        }
        if (string4.charAt(0) == '@') {
            string4 = string4.substring(1);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + string4 + " " + string5);
        }
        this.server = this.getCORBAServer(string4, Integer.parseInt(string5));
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + this.server + "," + this.hEnv);
        }
        if (this.hEnv == 0) {
            this.server.SQLAllocEnv(this.returnCodeHolder, intHolder2);
            if (this.returnCodeHolder.value == -1) {
                this.standardError(this.returnCodeHolder.value, 0, 0, 0);
            }
            this.hEnv = intHolder2.value;
        }
        this.server.SQLAllocConnect(this.returnCodeHolder, this.hEnv, intHolder);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Debug " + this.hEnv + "," + intHolder);
        }
        if (this.returnCodeHolder.value == -1) {
            this.standardError(this.returnCodeHolder.value, 0, intHolder.value, 0);
        } else {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLAlloc), hDbc=" + intHolder.value + ",rc=" + this.returnCodeHolder.value);
            }
            if (this.returnCodeHolder.value != 0) {
                this.standardError(this.returnCodeHolder.value, 0, 0, 0);
            }
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLConnect), hDbc=" + intHolder.value + ", dsn=" + string6 + ", user=" + string2 + ", pass=" + string3 + ", host=" + string4 + ", port=" + string5);
            }
            this.server.SQLConnect(this.returnCodeHolder, intHolder.value, string6, (short)-3, string2, (short)-3, string3, (short)-3);
            if (this.returnCodeHolder.value != 0) {
                this.standardError(this.returnCodeHolder.value, 0, intHolder.value, 0);
            }
        }
        return intHolder.value;
    }

    public void SQLCancel(OdbcStatement odbcStatement) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLCancel), hStmt=" + n);
        }
        this.server.SQLCancel(this.returnCodeHolder, n);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public int SQLColAttributes(OdbcStatement odbcStatement, int n, short s) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLColAttributes int), hStmt=" + n2 + ", icol=" + n + ", type=" + s);
        }
        OctetSequenceHolder octetSequenceHolder = new OctetSequenceHolder(new byte[2]);
        ShortHolder shortHolder = new ShortHolder();
        IntHolder intHolder = new IntHolder();
        short s2 = 2;
        this.server.SQLColAttributes(this.returnCodeHolder, n2, (short)n, s, octetSequenceHolder, s2, shortHolder, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value (int)=" + intHolder.value);
        }
        return intHolder.value;
    }

    public String SQLColAttributesString(OdbcStatement odbcStatement, int n, short s) throws SQLException, PicoSQLWarning {
        String string;
        block4: {
            int n2 = odbcStatement.getHSTMT();
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("(SQLColAttributes String), hStmt=" + n2 + ", icol=" + n + ", type=" + s);
            }
            OctetSequenceHolder octetSequenceHolder = new OctetSequenceHolder(new byte[128]);
            ShortHolder shortHolder = new ShortHolder();
            IntHolder intHolder = new IntHolder();
            short s2 = 128;
            this.server.SQLColAttributes(this.returnCodeHolder, n2, (short)n, s, octetSequenceHolder, s2, shortHolder, intHolder);
            string = new String();
            try {
                string = PicoUtil.BytesToChars(this.charSet, octetSequenceHolder.value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (DriverManager.getLogWriter() == null) break block4;
                DriverManager.println(unsupportedEncodingException.toString());
            }
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value (String)=" + string.trim());
        }
        return string.trim();
    }

    public void SQLColumns(OdbcStatement odbcStatement, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLColumns), hStmt=" + n + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", colType=" + string4);
        }
        this.server.SQLColumns(this.returnCodeHolder, n, string == null ? "" : string, string == null ? (short)-1 : -3, string2 == null ? "" : string2, string2 == null ? (short)-1 : -3, string3 == null ? "%" : string3, string3 == null ? (short)-1 : -3, string4 == null ? "" : string4, string4 == null ? (short)-1 : -3);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public void SQLExecDirect(OdbcStatement odbcStatement, String string) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLExecDirect), hStmt=" + n + ", szSqlStr=" + string);
        }
        this.server.SQLExecDirect(this.returnCodeHolder, n, string, -3);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public boolean SQLExecute(OdbcStatement odbcStatement) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLExecute), hStmt=" + n);
        }
        this.server.SQLExecute(this.returnCodeHolder, n);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        return true;
    }

    public boolean SQLExecuteParams(OdbcStatement odbcStatement, Vector vector) throws SQLException, SQLWarning {
        int n;
        int n2 = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLExecuteParams), hStmt=" + n2);
        }
        if (vector != null) {
            n = 1;
            while (n < vector.size()) {
                if (vector.get(n) == null) break;
                ++n;
            }
            --n;
        } else {
            n = 0;
        }
        Param_item[] param_itemArray = new Param_item[n];
        int n3 = 0;
        while (n3 < n) {
            PicoBoundParam picoBoundParam = (PicoBoundParam)vector.get(n3 + 1);
            param_itemArray[n3] = new Param_item();
            param_itemArray[n3].fParamType = picoBoundParam.fInputOutput;
            param_itemArray[n3].fSqlType = picoBoundParam.fSqlType;
            param_itemArray[n3].ibScale = (short)picoBoundParam.ibScale;
            param_itemArray[n3].rgbValue = this.orb.create_any();
            switch (picoBoundParam.fSqlType) {
                case 0: {
                    param_itemArray[n3].fSqlType = 1;
                    param_itemArray[n3].fCType = 1;
                    param_itemArray[n3].cbColDef = 1;
                    param_itemArray[n3].cbValueMax = 1;
                    param_itemArray[n3].rgbValue.insert_string("");
                    param_itemArray[n3].pcbValue = -1;
                    break;
                }
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    param_itemArray[n3].fCType = 1;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 1;
                        param_itemArray[n3].cbValueMax = 1;
                        param_itemArray[n3].rgbValue.insert_string("");
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbValueMax = param_itemArray[n3].cbColDef = picoBoundParam.rgbValue.toString().length();
                    param_itemArray[n3].rgbValue.insert_string(picoBoundParam.rgbValue.toString());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case -7: {
                    param_itemArray[n3].fCType = (short)-7;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 1;
                        param_itemArray[n3].cbValueMax = 1;
                        param_itemArray[n3].rgbValue.insert_octet((byte)0);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 1;
                    param_itemArray[n3].cbValueMax = 1;
                    param_itemArray[n3].rgbValue.insert_octet((byte)((Boolean)picoBoundParam.rgbValue != false ? 1 : 0));
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case -6: {
                    param_itemArray[n3].fCType = 1;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 1;
                        param_itemArray[n3].cbValueMax = 1;
                        param_itemArray[n3].rgbValue.insert_octet((byte)0);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 1;
                    param_itemArray[n3].cbValueMax = 1;
                    param_itemArray[n3].rgbValue.insert_octet(((Byte)picoBoundParam.rgbValue).byteValue());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case 5: {
                    param_itemArray[n3].fCType = (short)5;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 2;
                        param_itemArray[n3].cbValueMax = 2;
                        param_itemArray[n3].rgbValue.insert_short((short)0);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 2;
                    param_itemArray[n3].cbValueMax = 2;
                    param_itemArray[n3].rgbValue.insert_short(((Integer)picoBoundParam.rgbValue).shortValue());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case 4: {
                    param_itemArray[n3].fCType = (short)4;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 4;
                        param_itemArray[n3].cbValueMax = 4;
                        param_itemArray[n3].rgbValue.insert_long(0);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 4;
                    param_itemArray[n3].cbValueMax = 4;
                    param_itemArray[n3].rgbValue.insert_long(((Integer)picoBoundParam.rgbValue).intValue());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case 7: {
                    param_itemArray[n3].fCType = (short)7;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 4;
                        param_itemArray[n3].cbValueMax = 4;
                        param_itemArray[n3].rgbValue.insert_float(0.0f);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 4;
                    param_itemArray[n3].cbValueMax = 4;
                    param_itemArray[n3].rgbValue.insert_float(((Float)picoBoundParam.rgbValue).floatValue());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case 6: 
                case 8: {
                    param_itemArray[n3].fCType = (short)8;
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 8;
                        param_itemArray[n3].cbValueMax = 8;
                        param_itemArray[n3].rgbValue.insert_double(0.0);
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 8;
                    param_itemArray[n3].cbValueMax = 8;
                    param_itemArray[n3].rgbValue.insert_double(((Double)picoBoundParam.rgbValue).doubleValue());
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    param_itemArray[n3].fCType = (short)-2;
                    OctetSequenceHelper.insert(param_itemArray[n3].rgbValue, (byte[])picoBoundParam.rgbValue);
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 1;
                        param_itemArray[n3].cbValueMax = 1;
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = ((byte[])picoBoundParam.rgbValue).length;
                    param_itemArray[n3].cbValueMax = Integer.MAX_VALUE;
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (picoBoundParam.rgbValue != null) {
                        Timestamp_struct timestamp_struct = new Timestamp_struct();
                        Calendar calendar = picoBoundParam.cal == null ? Calendar.getInstance() : picoBoundParam.cal;
                        calendar.setTime((Date)picoBoundParam.rgbValue);
                        timestamp_struct.year = (short)calendar.get(1);
                        timestamp_struct.month = (short)(calendar.get(2) + 1);
                        timestamp_struct.day = (short)calendar.get(5);
                        timestamp_struct.hour = (short)calendar.get(11);
                        timestamp_struct.minute = (short)calendar.get(12);
                        timestamp_struct.second = (short)calendar.get(13);
                        timestamp_struct.fraction = (short)calendar.get(14);
                        param_itemArray[n3].fCType = (short)11;
                        param_itemArray[n3].fSqlType = (short)11;
                        Timestamp_structHelper.insert(param_itemArray[n3].rgbValue, timestamp_struct);
                    }
                    if (picoBoundParam.rgbValue == null) {
                        param_itemArray[n3].cbColDef = 1;
                        param_itemArray[n3].cbValueMax = 1;
                        param_itemArray[n3].fCType = (short)11;
                        param_itemArray[n3].fSqlType = (short)11;
                        param_itemArray[n3].pcbValue = -1;
                        break;
                    }
                    param_itemArray[n3].cbColDef = 16;
                    param_itemArray[n3].cbValueMax = 16;
                    param_itemArray[n3].pcbValue = param_itemArray[n3].cbColDef;
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type in SQLEcecuteParams=" + picoBoundParam.fSqlType);
                }
            }
            ++n3;
        }
        this.server.SQLExecuteParams(this.returnCodeHolder, n2, param_itemArray);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        return true;
    }

    public boolean SQLFetch(OdbcStatement odbcStatement) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        boolean bl = true;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), hStmt=" + n);
        }
        IntHolder intHolder = new IntHolder();
        this.server.SQLFetch(this.returnCodeHolder, n, intHolder);
        if (this.returnCodeHolder.value == 100) {
            bl = false;
        } else if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), ret=" + this.returnCodeHolder.value + "col=" + intHolder.value);
        }
        return bl;
    }

    public boolean SQLFetch(OdbcStatement odbcStatement, int[] nArray) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        boolean bl = true;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), hStmt=" + n);
        }
        IntHolder intHolder = new IntHolder();
        this.server.SQLFetch(this.returnCodeHolder, n, intHolder);
        if (this.returnCodeHolder.value == 100) {
            bl = false;
        } else if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        nArray[0] = intHolder.value;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLFetch), ret=" + this.returnCodeHolder.value + "col=" + intHolder.value);
        }
        return bl;
    }

    public int SQLGetConnectOption(OdbcConnection odbcConnection, short s) throws SQLException {
        int n = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetConnectOption), hDbc=" + n + ", fOption=" + s);
        }
        IntHolder intHolder = new IntHolder();
        StringHolder stringHolder = new StringHolder();
        this.server.SQLGetConnectOption(this.returnCodeHolder, n, s, stringHolder, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("option value (int)=" + intHolder.value);
        }
        return intHolder.value;
    }

    public String SQLGetConnectOptionString(OdbcConnection odbcConnection, short s) throws SQLException {
        int n = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetConnectOption), hDbc=" + n + ", fOption=" + s);
        }
        IntHolder intHolder = new IntHolder();
        StringHolder stringHolder = new StringHolder();
        this.server.SQLGetConnectOption(this.returnCodeHolder, n, s, stringHolder, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("option value (int)=" + stringHolder.value.trim());
        }
        return stringHolder.value.trim();
    }

    public String SQLGetCursorName(OdbcStatement odbcStatement) throws SQLException, PicoSQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetCursorName), hStmt=" + n);
        }
        StringHolder stringHolder = new StringHolder();
        ShortHolder shortHolder = new ShortHolder();
        this.server.SQLGetCursorName(this.returnCodeHolder, n, stringHolder, (short)256, shortHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        String string = stringHolder.value.trim();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + string);
        }
        return string;
    }

    public Object[] SQLGetAllData(OdbcStatement odbcStatement, PicoBoundCol[] picoBoundColArray) throws SQLException, PicoSQLWarning {
        int n = odbcStatement.getHSTMT();
        AnySequenceHolder anySequenceHolder = new AnySequenceHolder();
        CommAttr_seqHolder commAttr_seqHolder = new CommAttr_seqHolder();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetAllData), hStmt=" + n);
        }
        this.server.SQLGetAllData(this.returnCodeHolder, n, anySequenceHolder, commAttr_seqHolder);
        if (this.returnCodeHolder.value == -1) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + anySequenceHolder);
        }
        Object[] objectArray = new Object[anySequenceHolder.value.length];
        int n2 = 0;
        while (n2 < anySequenceHolder.value.length) {
            picoBoundColArray[n2].setLength(commAttr_seqHolder.value[n2].length);
            picoBoundColArray[n2].setType(OdbcDef.odbcTypeToJdbc(commAttr_seqHolder.value[n2].type));
            picoBoundColArray[n2].setPrecision(commAttr_seqHolder.value[n2].precision);
            picoBoundColArray[n2].setScale(commAttr_seqHolder.value[n2].scale);
            switch (anySequenceHolder.value[n2].type().kind().value()) {
                case 2: {
                    objectArray[n2] = new Short(anySequenceHolder.value[n2].extract_short());
                    break;
                }
                case 4: {
                    objectArray[n2] = new Short(anySequenceHolder.value[n2].extract_ushort());
                    break;
                }
                case 3: {
                    objectArray[n2] = new Integer(anySequenceHolder.value[n2].extract_long());
                    break;
                }
                case 5: {
                    objectArray[n2] = new Integer(anySequenceHolder.value[n2].extract_ulong());
                    break;
                }
                case 6: {
                    objectArray[n2] = new Float(anySequenceHolder.value[n2].extract_float());
                    break;
                }
                case 7: {
                    objectArray[n2] = new Double(anySequenceHolder.value[n2].extract_double());
                    break;
                }
                case 18: {
                    objectArray[n2] = anySequenceHolder.value[n2].extract_string();
                    break;
                }
                case 13: {
                    InputStream inputStream = anySequenceHolder.value[n2].create_input_stream();
                    int n3 = inputStream.read_long();
                    objectArray[n2] = new byte[n3];
                    inputStream.read_octet_array((byte[])objectArray[n2], 0, n3);
                    break;
                }
                case 0: {
                    objectArray[n2] = null;
                    break;
                }
                case 15: {
                    try {
                        if (!Timestamp_structHelper.type().name().equals(anySequenceHolder.value[n2].type().name())) {
                            objectArray[n2] = null;
                            throw new SQLException("Unknown struct " + anySequenceHolder.value[n2].type().name() + " col # " + n2);
                        }
                        Timestamp_struct timestamp_struct = Timestamp_structHelper.extract(anySequenceHolder.value[n2]);
                        objectArray[n2] = Timestamp.valueOf("" + timestamp_struct.year + "-" + timestamp_struct.month + "-" + timestamp_struct.day + " " + timestamp_struct.hour + ":" + timestamp_struct.minute + ":" + timestamp_struct.second + "." + PicoDbApi.fractToString(timestamp_struct.fraction));
                        break;
                    }
                    catch (BadKind badKind) {
                        objectArray[n2] = null;
                        throw new SQLException(badKind.toString());
                    }
                }
                default: {
                    objectArray[n2] = null;
                    throw new SQLException("Unknown tk type " + anySequenceHolder.value[n2].type().kind().value() + " col # " + n2);
                }
            }
            ++n2;
        }
        return objectArray;
    }

    public Double SQLGetDataDouble(OdbcStatement odbcStatement, int n) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        Double d = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Double), hStmt=" + n2 + ", icol=" + n);
        }
        AnyHolder anyHolder = new AnyHolder();
        int n3 = 0;
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n2, (short)n, (short)8, anyHolder, n3, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (intHolder.value >= 0) {
            d = new Double(anyHolder.value.extract_double());
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=" + d + ",len=" + intHolder.value);
        }
        return d;
    }

    public Float SQLGetDataFloat(OdbcStatement odbcStatement, int n) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        Float f = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Float), hStmt=" + n2 + ", icol=" + n);
        }
        AnyHolder anyHolder = new AnyHolder();
        int n3 = 0;
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n2, (short)n, (short)7, anyHolder, n3, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (intHolder.value >= 0) {
            f = new Float(anyHolder.value.extract_float());
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=" + f + ",len=" + intHolder.value);
        }
        return f;
    }

    public Integer SQLGetDataInteger(OdbcStatement odbcStatement, int n) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        Integer n3 = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Integer), hStmt=" + n2 + ", column=" + n);
        }
        AnyHolder anyHolder = new AnyHolder();
        int n4 = 0;
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n2, (short)n, (short)4, anyHolder, n4, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (intHolder.value >= 0) {
            n3 = new Integer(anyHolder.value.extract_long());
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=" + n3 + ",len=" + intHolder.value);
        }
        return n3;
    }

    public String SQLGetDataString(OdbcStatement odbcStatement, int n, int n2, boolean bl) throws SQLException, PicoSQLWarning {
        int n3 = odbcStatement.getHSTMT();
        String string = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData String), hStmt=" + n3 + ", icol=" + n + ", cbValueMax=" + n2);
        }
        AnyHolder anyHolder = new AnyHolder();
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n3, (short)n, (short)1, anyHolder, n2, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n3);
        }
        if (intHolder.value >= 0) {
            string = anyHolder.value.extract_string();
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=[" + string + "],len=" + intHolder.value);
        }
        if (bl && string != null) {
            return string.trim();
        }
        return string;
    }

    public byte[] SQLGetDataBytes(OdbcStatement odbcStatement, int n) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        byte[] byArray = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Bytes), hStmt=" + n2 + ", icol=" + n);
        }
        AnyHolder anyHolder = new AnyHolder();
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n2, (short)n, (short)-4, anyHolder, Integer.MAX_VALUE, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=[" + byArray + "],len=" + intHolder.value);
        }
        InputStream inputStream = anyHolder.value.create_input_stream();
        int n3 = inputStream.read_long();
        byArray = new byte[n3];
        inputStream.read_octet_array(byArray, 0, n3);
        return byArray;
    }

    public Timestamp SQLGetDataTimestamp(OdbcStatement odbcStatement, int n) throws SQLException, PicoSQLWarning {
        int n2 = odbcStatement.getHSTMT();
        Timestamp timestamp = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetData Timestamp), hStmt=" + n2 + ", icol=" + n);
        }
        AnyHolder anyHolder = new AnyHolder();
        IntHolder intHolder = new IntHolder();
        this.server.SQLGetData(this.returnCodeHolder, n2, (short)n, (short)11, anyHolder, 0, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("type=" + anyHolder.value.type().kind().value() + ",value=[" + timestamp + "],len=" + intHolder.value);
        }
        Timestamp_struct timestamp_struct = Timestamp_structHelper.extract(anyHolder.value);
        timestamp = Timestamp.valueOf("" + timestamp_struct.year + "-" + timestamp_struct.month + "-" + timestamp_struct.day + " " + timestamp_struct.hour + ":" + timestamp_struct.minute + ":" + timestamp_struct.second + "." + PicoDbApi.fractToString(timestamp_struct.fraction));
        return timestamp;
    }

    public int SQLGetStmtOption(OdbcStatement odbcStatement, short s) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetStmtOption), hStmt=" + n + ", fOption=" + s);
        }
        IntHolder intHolder = new IntHolder();
        StringHolder stringHolder = new StringHolder();
        this.server.SQLGetStmtOption(this.returnCodeHolder, n, s, stringHolder, intHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + intHolder.value);
        }
        return intHolder.value;
    }

    public void SQLGetTypeInfo(OdbcStatement odbcStatement, short s) throws SQLException {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLGetTypeInfo), hStmt=" + n + ", fSqlType=" + s);
        }
        this.server.SQLGetTypeInfo(this.returnCodeHolder, n, s);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public int SQLNumParams(OdbcStatement odbcStatement) throws SQLException, PicoSQLWarning {
        int n = odbcStatement.getHSTMT();
        boolean bl = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLNumParams), hStmt=" + n);
        }
        ShortHolder shortHolder = new ShortHolder();
        this.server.SQLNumResultCols(this.returnCodeHolder, n, shortHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + shortHolder.value);
        }
        return shortHolder.value;
    }

    public int SQLNumResultCols(OdbcStatement odbcStatement) throws SQLException, PicoSQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLNumResultCols), hStmt=" + n);
        }
        ShortHolder shortHolder = new ShortHolder();
        this.server.SQLNumResultCols(this.returnCodeHolder, n, shortHolder);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + shortHolder.value);
        }
        return shortHolder.value;
    }

    public void SQLPrepare(OdbcStatement odbcStatement, String string) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLPrepare), hStmt=" + n + ", szSqlStr=" + string);
        }
        this.server.SQLPrepare(this.returnCodeHolder, n, string, string.length());
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public int SQLRowCount(OdbcStatement odbcStatement) throws SQLException, PicoSQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLRowCount), hStmt=" + n);
        }
        IntHolder intHolder = new IntHolder();
        this.server.SQLRowCount(this.returnCodeHolder, n, intHolder);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("value=" + intHolder.value);
        }
        return intHolder.value;
    }

    public void SQLSetConnectOption(OdbcConnection odbcConnection, short s, int n) throws SQLException {
        int n2 = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetConnectOption), hDbc=" + n2 + ", fOption=" + s + ", vParam=" + n);
        }
        this.server.SQLSetConnectOption(this.returnCodeHolder, n2, s, "", n);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n2, 0);
        }
    }

    public void SQLSetConnectOption(OdbcConnection odbcConnection, short s, String string) throws SQLException {
        int n = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetConnectOption), hDbc=" + n + ", fOption=" + s + ", vParam=" + string);
        }
        this.server.SQLSetConnectOption(this.returnCodeHolder, n, s, string, 0);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, n, 0);
        }
    }

    public void SQLSetStmtOption(OdbcStatement odbcStatement, short s, int n) throws SQLException {
        int n2 = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSetStmtOption), hStmt=" + n2 + ", fOption=" + s + ", vParam=" + n);
        }
        this.server.SQLSetStmtOption(this.returnCodeHolder, n2, s, "", n);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
    }

    public void SQLSpecialColumns(OdbcStatement odbcStatement, short s, String string, String string2, String string3, int n, boolean bl) throws SQLException, SQLWarning {
        int n2 = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLSpecialColumns), hStmt=" + n2 + ", fColType=" + s + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", fScope=" + n + ", fNullable=" + bl);
        }
        this.server.SQLSpecialColumns(this.returnCodeHolder, n2, s, string == null ? "" : string, string == null ? (short)-1 : -3, string2 == null ? "" : string2, string2 == null ? (short)-1 : -3, string3 == null ? "%" : string3, string3 == null ? (short)-1 : -3, (short)n, bl ? (short)1 : 0);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n2);
        }
    }

    public void SQLStatistics(OdbcStatement odbcStatement, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLStatistics), hStmt=" + n + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", unique=" + bl + ", approximate=" + bl2);
        }
        this.server.SQLStatistics(this.returnCodeHolder, n, string == null ? "" : string, string == null ? (short)-1 : -3, string2 == null ? "" : string2, string2 == null ? (short)-1 : -3, string3 == null ? "%" : string3, string3 == null ? (short)-1 : -3, bl ? (short)0 : 1, bl2 ? (short)0 : 1);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public void SQLTables(OdbcStatement odbcStatement, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        int n = odbcStatement.getHSTMT();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLTables), hStmt=" + n + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", types=" + string4);
        }
        this.server.SQLTables(this.returnCodeHolder, n, string == null ? "" : string, string == null ? (short)-1 : -3, string2 == null ? "" : string2, string2 == null ? (short)-1 : -3, string3 == null ? "%" : string3, string3 == null ? (short)-1 : -3, string4 == null ? "" : string4, string4 == null ? (short)-1 : -3);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, 0, 0, n);
        }
    }

    public void SQLTransact(int n, OdbcConnection odbcConnection, short s) throws SQLException {
        int n2 = odbcConnection.getHDBC();
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLTransact), hEnv=" + n + ", hDbc=" + n2 + ", fType=" + s);
        }
        this.server.SQLTransact(this.returnCodeHolder, n, n2, s);
        if (this.returnCodeHolder.value != 0) {
            this.standardError(this.returnCodeHolder.value, n, n2, 0);
        }
    }

    public int SQLError(int n, int n2, int n3) {
        int n4;
        StringHolder stringHolder = new StringHolder();
        StringHolder stringHolder2 = new StringHolder();
        IntHolder intHolder = new IntHolder();
        ShortHolder shortHolder = new ShortHolder();
        this.server.SQLError(this.returnCodeHolder, n, n2, n3, stringHolder, intHolder, stringHolder2, (short)512, shortHolder);
        if (this.returnCodeHolder.value == 100) {
            this.sqlState = "";
            this.sqlErrMess = "";
            n4 = 0;
        } else if (this.returnCodeHolder.value == -1) {
            this.sqlState = "S10000";
            this.sqlErrMess = "General Error - Error on SQLError";
            n4 = 0;
        } else {
            this.sqlState = stringHolder.value;
            this.sqlErrMess = stringHolder2.value;
            int n5 = n4 = intHolder.value == 0 ? 9999 : intHolder.value;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("(SQLError), hEnv=" + n + ", hDbc=" + n2 + ", hStmt=" + n3 + " [" + this.sqlErrMess + "]=" + n4);
        }
        return n4;
    }

    public static SQLWarning convertWarning(PicoSQLWarning picoSQLWarning) {
        SQLWarning sQLWarning = picoSQLWarning;
        if (picoSQLWarning.getSQLState().equals("01004")) {
            sQLWarning = new DataTruncation(-1, false, true, 0, 0);
        }
        return sQLWarning;
    }

    SQLException createSQLException(int n, int n2, int n3) {
        int n4;
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        SQLException sQLException3 = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ERROR - Generating SQLException...");
        }
        while ((n4 = this.SQLError(n, n2, n3)) != 0) {
            sQLException2 = new SQLException(this.sqlErrMess, this.sqlState, n4);
            if (sQLException == null) {
                sQLException = sQLException2;
            } else {
                sQLException3.setNextException(sQLException2);
            }
            sQLException3 = sQLException2;
        }
        if (sQLException == null) {
            sQLException = new PicoSQLWarning("General Error", "S1000");
        }
        return sQLException;
    }

    PicoSQLWarning createSQLWarning(int n, int n2, int n3) {
        int n4;
        PicoSQLWarning picoSQLWarning = null;
        PicoSQLWarning picoSQLWarning2 = null;
        SQLWarning sQLWarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("WARNING - Generating SQLWarning...");
        }
        while ((n4 = this.SQLError(n, n2, n3)) != 0) {
            picoSQLWarning2 = new PicoSQLWarning(this.sqlErrMess, this.sqlState, n4);
            if (picoSQLWarning == null) {
                picoSQLWarning = picoSQLWarning2;
            } else {
                sQLWarning.setNextWarning(picoSQLWarning2);
            }
            sQLWarning = picoSQLWarning2;
        }
        if (picoSQLWarning == null) {
            picoSQLWarning = new PicoSQLWarning("General warning", "01000");
        }
        return picoSQLWarning;
    }

    void standardError(int n, int n2, int n3, int n4) throws SQLException, PicoSQLWarning {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("RETCODE = " + n);
        }
        switch (n) {
            case 0: {
                return;
            }
            case -1: {
                throw this.createSQLException(n2, n3, n4);
            }
            case 1: {
                throw this.createSQLWarning(n2, n3, n4);
            }
            case -2: {
                throw new SQLException("Invalid handle");
            }
            case 100: {
                throw new SQLException("No data found");
            }
        }
        this.throwGenericSQLException(n);
    }

    void throwGenericSQLException(int n) throws SQLException {
        String string = "Unknown return code " + n;
        String string2 = "S1000";
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ERROR - " + string2 + " " + string);
        }
        throw new SQLException(string, string2);
    }

    protected void ReleaseStoredBytes(int n, int n2) {
    }

    protected void ReleaseStoredChars(int n, int n2) {
    }

    public int bufferToInt(byte[] byArray) {
        return 0;
    }

    private static String fractToString(int n) {
        String string = "000" + n;
        return string.substring(string.length() - 3);
    }
}

