/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.swing.table.RowComparator;
import org.I00acres.isql.swing.table.Sortable;
import org.I00acres.isql.util.iSQLUtilites;

public class iSQLTableModel
extends DefaultTableModel
implements Sortable {
    public static final int TYPE_PROPERTIES = 0;
    public static final int TYPE_HASHTABLE = 1;
    public static final int TYPE_RESULTSET = 2;
    public static final int TYPE_UNKNOWN = 3;
    private boolean isEditable = false;
    private boolean isOptimized = false;
    private int type = 3;

    public iSQLTableModel(ResultSet set) {
        this.setData(set);
    }

    public iSQLTableModel(Properties props) {
        this.setData(props);
    }

    public iSQLTableModel(Hashtable table) {
        this.setData(table);
    }

    public iSQLTableModel() {
    }

    public int getModelType() {
        return this.type;
    }

    public void setData(Hashtable table) {
        this.clearTable();
        this.type = 1;
        this.addColumn(iSQLUtilites.getString("Property_Name"));
        this.addColumn(iSQLUtilites.getString("Property_Value"));
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String k = new String(enumeration.nextElement().toString());
            this.addRow(new Object[]{k, table.get(k)});
            try {
                Thread.sleep(25L);
            }
            catch (Exception exception) {}
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public int getIndexOfColumnName(String ColumnName) {
        return this.columnIdentifiers.indexOf(ColumnName);
    }

    public Properties getTableAsProperties() {
        Properties props = new Properties();
        try {
            int r = 0;
            while (r < this.getRowCount()) {
                props.setProperty(this.getValueAt(r, 0).toString(), this.getValueAt(r, 1).toString());
                ++r;
            }
        }
        catch (Exception exception) {}
        return props;
    }

    public synchronized void sort(int column, boolean asc) {
        Vector[] arr = this.dataVector.toArray(new Vector[0]);
        try {
            iSQLTableModel iSQLTableModel2 = this;
            synchronized (iSQLTableModel2) {
                Arrays.sort(arr, new RowComparator(column, asc));
            }
            this.dataVector.clear();
            this.dataVector.addAll(Arrays.asList(arr));
            this.fireTableDataChanged();
        }
        catch (Throwable throwable) {}
    }

    public void setData(Properties props) {
        this.clearTable();
        this.type = 0;
        this.addColumn(iSQLUtilites.getString("Property_Name"));
        this.addColumn(iSQLUtilites.getString("Property_Value"));
        Enumeration enumeration = ((Hashtable)props).keys();
        while (enumeration.hasMoreElements()) {
            String k = new String(enumeration.nextElement().toString());
            this.addRow(new Object[]{k, props.getProperty(k)});
            try {
                Thread.sleep(25L);
            }
            catch (Exception exception) {}
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public synchronized void allowEditing(boolean f) {
        this.isEditable = f;
    }

    public int getTrueRowCount() {
        if (this.type == 2 && this.isOptimized) {
            return this.getColumnCount() - 1;
        }
        return super.getRowCount();
    }

    public void setData(ResultSet set) {
        this.clearTable();
        this.type = 2;
        try {
            ResultSetMetaData rsmd = set.getMetaData();
            int c = 1;
            while (c <= rsmd.getColumnCount()) {
                this.addColumn(rsmd.getColumnName(c));
                ++c;
            }
            Vector<String> Row2 = new Vector<String>(rsmd.getColumnCount(), 0);
            int rowNum = 1;
            while (set.next()) {
                Row2.clear();
                int i = 1;
                while (i <= rsmd.getColumnCount()) {
                    String str = set.getString(i);
                    Row2.addElement(str == null ? "NULL" : str.trim());
                    ++i;
                }
                this.addRow((Vector)Row2.clone());
                ++rowNum;
            }
            rsmd = null;
            Row2 = null;
            this.optimizeResultSetView();
            System.gc();
            System.runFinalization();
        }
        catch (Exception exception) {}
    }

    public synchronized void optimizeResultSetView() {
        if (this.getRowCount() != 1 || this.getModelType() != 2) {
            return;
        }
        Vector col1 = (Vector)this.dataVector.get(0).clone();
        Vector col0 = (Vector)this.columnIdentifiers.clone();
        this.clearTable();
        this.isOptimized = true;
        this.type = 2;
        this.addColumn(iSQLUtilites.getString("Table_Column_Name"));
        this.addColumn(iSQLUtilites.getString("Column_Value"));
        Enumeration enumeration = col0.elements();
        Enumeration enum2 = col1.elements();
        while (enumeration.hasMoreElements()) {
            this.addRow(new Object[]{enumeration.nextElement(), enum2.nextElement()});
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
        enumeration = null;
        enum2 = null;
        col0 = null;
        col1 = null;
        System.gc();
        System.runFinalization();
    }

    public synchronized void clearTable() {
        this.isOptimized = false;
        this.type = 3;
        this.columnIdentifiers.clear();
        this.dataVector.clear();
        System.gc();
        System.runFinalization();
    }

    public boolean isCellEditable(int row, int col) {
        return this.isEditable;
    }
}

