/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.I00acres.isql.iSQLViewer;
import org.I00acres.isql.swing.AbstractTableTool;
import org.I00acres.isql.util.TableFilter;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public final class ExtensionFactory {
    private static final String TABLEFILTER_JAR_ATTR = "Table-Filter";
    private static ExtensionFactory instance;
    private static final FilenameFilter fnf;
    private static final String[] EXPORTDEFAULTS;
    private static final String[] TABLE_TOOLS;
    private static final Vector mTableToolClasses;
    private static final Vector mExportClasses;
    private Thread t = new Thread(new loadThread());
    private Hashtable mTableFilters = new Hashtable();
    private Hashtable mTableTools = new Hashtable();
    private static File[] LibraryFiles;
    private static Thread lazyCloseThread;
    private static ClassLoader cl;
    static /* synthetic */ Class class$0;

    static {
        fnf = new JarFileNameFilter();
        EXPORTDEFAULTS = new String[]{"org.I00acres.isql.util.CSVTableFilter", "org.I00acres.isql.util.ExcelTableFilter", "org.I00acres.isql.util.HTMLTableFilter", "org.I00acres.isql.util.XMLTableFilter"};
        TABLE_TOOLS = new String[]{"org.I00acres.isql.forms.frmTableWizard", "org.I00acres.isql.forms.frmIndexWizard"};
        mTableToolClasses = new Vector<String>(Arrays.asList(TABLE_TOOLS));
        mExportClasses = new Vector<String>(Arrays.asList(EXPORTDEFAULTS));
        lazyCloseThread = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.I00acres.isql.util.ExtensionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cl = clazz.getClassLoader();
        Runtime.getRuntime().addShutdownHook(new Thread(iSQLViewer.SHUT_DOWN_THREAD_GROUP, new Runnable(){

            public void run() {
                if (instance != null) {
                    if (lazyCloseThread != null) {
                        lazyCloseThread.interrupt();
                    }
                    ExtensionFactory.closeNow();
                }
            }
        }));
    }

    public static synchronized ExtensionFactory getInstance() {
        ExtensionFactory.validateState();
        return instance;
    }

    static void updateClassLoader(ClassLoader classloader) {
        cl = classloader;
    }

    public static void close() {
        if (lazyCloseThread == null) {
            lazyCloseThread = new Thread(new lazyUnloadProcess());
            lazyCloseThread.start();
        }
    }

    private static void closeNow() {
        if (instance == null) {
            return;
        }
        instance.saveFilterSettings();
        mTableToolClasses.clear();
        mExportClasses.clear();
        instance = null;
        lazyCloseThread = null;
        System.runFinalization();
    }

    private void saveFilterSettings() {
        Iterator itr = this.mTableFilters.values().iterator();
        iSQLConfig config = iSQLConfig.getInstance();
        while (itr.hasNext()) {
            TableFilter filter = (TableFilter)itr.next();
            try {
                File f = new File(iSQLConfig.getiSQLSubDir("filters"), filter.getName());
                filter.getConfiguration().store(new FileOutputStream(f), "");
            }
            catch (Exception e) {
                iSQLUtilites.HandleException(e, "Error Saving Filter Information for " + filter.getName(), true);
            }
        }
    }

    public static File[] getExtensions() {
        ExtensionFactory.validateState();
        if (LibraryFiles == null) {
            Vector<File> LibraryVector = new Vector<File>();
            File[] libs = ExtensionFactory.getLibraryFiles();
            int i = 0;
            while (i < libs.length) {
                try {
                    JarFile lib = new JarFile(libs[i]);
                    Manifest m = lib.getManifest();
                    boolean f = false;
                    if (ExtensionFactory.containsTableFilter(m)) {
                        f = true;
                        mExportClasses.add(ExtensionFactory.getTableFilter(m));
                    }
                    if (f) {
                        LibraryVector.add(libs[i]);
                    }
                    f = false;
                }
                catch (Throwable throwable) {}
                ++i;
            }
            LibraryFiles = LibraryVector.toArray(new File[0]);
            LibraryVector.clear();
            LibraryVector = null;
            Object var1_1 = null;
        }
        return LibraryFiles;
    }

    private ExtensionFactory() {
        this.t.start();
    }

    public AbstractTableTool[] getTableTools() {
        ExtensionFactory.validateState();
        return this.mTableTools.values().toArray(new AbstractTableTool[0]);
    }

    public TableFilter[] getTableFilters() {
        ExtensionFactory.validateState();
        return this.mTableFilters.values().toArray(new TableFilter[0]);
    }

    public TableFilter getTableFilter(String name) {
        ExtensionFactory.validateState();
        return (TableFilter)this.mTableFilters.get(name);
    }

    public AbstractTableTool getTableTool(String name) {
        ExtensionFactory.validateState();
        return (AbstractTableTool)this.mTableTools.get(name);
    }

    private static boolean containsTableFilter(Manifest m) {
        return m.getMainAttributes().getValue(TABLEFILTER_JAR_ATTR) != null;
    }

    private static String getTableFilter(Manifest m) {
        return m.getMainAttributes().getValue(TABLEFILTER_JAR_ATTR);
    }

    private static void validateState() {
        if (lazyCloseThread != null) {
            lazyCloseThread.interrupt();
            lazyCloseThread = null;
        }
        if (instance == null) {
            instance = new ExtensionFactory();
        }
    }

    private synchronized void clearExtensions() {
        this.mTableFilters.clear();
    }

    private void initExtensions() {
        Object tool;
        String c;
        iSQLConfig config = iSQLConfig.getInstance();
        int i = 0;
        while (i < mExportClasses.size()) {
            try {
                c = (String)mExportClasses.get(i);
                tool = (TableFilter)Class.forName(c, true, cl).newInstance();
                try {
                    File f = new File(iSQLConfig.getiSQLSubDir("filters"), tool.getName());
                    Properties props = new Properties();
                    props.load(new FileInputStream(f));
                    tool.configure(props);
                }
                catch (Throwable throwable) {}
                this.mTableFilters.put(tool.getName(), tool);
            }
            catch (Throwable throwable) {}
            ++i;
        }
        i = 0;
        while (i < mTableToolClasses.size()) {
            try {
                c = (String)mTableToolClasses.get(i);
                tool = (AbstractTableTool)Class.forName(c, true, cl).newInstance();
                this.mTableTools.put(((AbstractTableTool)tool).getToolName(), tool);
            }
            catch (Throwable t) {
                iSQLUtilites.HandleException(t, "Error Creating Table Tool" + i, true);
            }
            ++i;
        }
    }

    private static File[] getLibraryFiles() {
        iSQLConfig.getInstance();
        File extDir = iSQLConfig.getiSQLSubDir("ext");
        return extDir.listFiles(fnf);
    }

    private static class JarFileNameFilter
    implements FilenameFilter {
        JarFileNameFilter() {
        }

        public boolean accept(File parm1, String parm2) {
            int idx = parm2.lastIndexOf(46) + 1;
            String ext = parm2.substring(idx < 0 ? 0 : idx);
            return ext.equalsIgnoreCase("jar");
        }
    }

    private class loadThread
    implements Runnable {
        loadThread() {
        }

        public void run() {
            try {
                ExtensionFactory.this.initExtensions();
            }
            catch (Throwable throwable) {}
        }
    }

    private static class lazyUnloadProcess
    implements Runnable {
        private long UNLOAD_THRESHOLD = 300000L;

        lazyUnloadProcess() {
        }

        public void run() {
            try {
                lazyUnloadProcess lazyUnloadProcess2 = this;
                synchronized (lazyUnloadProcess2) {
                    this.wait(this.UNLOAD_THRESHOLD);
                }
                if (instance != null) {
                    ExtensionFactory.closeNow();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

