/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifdef __cplusplus
extern "C" {
# include "method.h"
}
#else
# include "method.h"
#endif

extern void i_SQLError (void **);
CorbaArg SQLError_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* henv */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_OUT },    /* outSqlState */
   { &TCD_long,   0, PARAM_OUT },    /* outNativeError */
   { &TCD_string, 0, PARAM_OUT },    /* outErrorMsg */
   { &TCD_short,  0, PARAM_IN  },    /* cbErrorMsgMax */
   { &TCD_short,  0, PARAM_OUT },    /* pcbErrorMsg */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLTables (void **);
CorbaArg SQLTables_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_string, 0, PARAM_IN  },    /* szTableType */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableType */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLPrepare (void **);
CorbaArg SQLPrepare_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szSqlStr */
   { &TCD_long,   0, PARAM_IN  },    /* cbSqlStr */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLExecute (void **);
CorbaArg SQLExecute_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLExecDirect (void **);
CorbaArg SQLExecDirect_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szSqlStr */
   { &TCD_long,   0, PARAM_IN  },    /* cbSqlStr */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLNumResultCols (void **);
CorbaArg SQLNumResultCols_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_short,  0, PARAM_OUT },    /* pccol */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLRowCount (void **);
CorbaArg SQLRowCount_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_long,   0, PARAM_OUT },    /* pcrow */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLDescribeCol (void **);
CorbaArg SQLDescribeCol_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* icol */
   { &TCD_string, 0, PARAM_OUT },    /* szColName */
   { &TCD_short,  0, PARAM_IN  },    /* cbColName */
   { &TCD_short,  0, PARAM_OUT },    /* pcbColNameMax */
   { &TCD_short,  0, PARAM_OUT },    /* pfSqlType */
   { &TCD_ulong,  0, PARAM_OUT },    /* pcbColDef */
   { &TCD_short,  0, PARAM_OUT },    /* pibScale */
   { &TCD_short,  0, PARAM_OUT },    /* pfNullable */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLFetch (void **);
CorbaArg SQLFetch_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_long,   0, PARAM_OUT },    /* num cols */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLExtendedFetch (void **);
CorbaArg SQLExtendedFetch_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* fetchType */
   { &TCD_long,   0, PARAM_IN  },    /* irow */
   { &TCD_ulong,  0, PARAM_OUT },    /* pcrow */
   { &TCD_ushort, 0, PARAM_OUT },    /* rgfRowStatus */
   { &TCD_long,   0, PARAM_OUT },    /* num cols */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

CORBA_TCKindDesc *BindColIn_item[] = {
   &TCD_ushort,                   /* icol */
   &TCD_short,                    /* fCType */
   &TCD_long,                     /* cbValueMax */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc BindColIn_struct = { tk_struct, "BindColIn", BindColIn_item, 0 };

CORBA_TCKindDesc *BindColIn_struct_seq[] = {
     &BindColIn_struct
};

CORBA_TCKindDesc BindColIn_seq = { tk_sequence, "BindColSeqIn", BindColIn_struct_seq, 0 };

CORBA_TCKindDesc *BindColOut_item[] = {
   &TCD_any,                      /* rgbValue */
   &TCD_long,                     /* pcbValue */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc BindColOut_struct = { tk_struct, "BindColOut", BindColOut_item, 0 };
CORBA_TCKindDesc *BindColOut_struct_seq[] = {
     &BindColOut_struct
};

CORBA_TCKindDesc BindColOut_seq = { tk_sequence, "BindColSeqOut", BindColOut_struct_seq, 0 };

extern void i_SQLFetchBindCol (void **);
CorbaArg SQLFetchBindCol_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &BindColIn_seq, 0, PARAM_IN },  /* bind col In */
   { &BindColOut_seq,0, PARAM_OUT }, /* bind col Out */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLExtendedFetchBindCol (void **);
CorbaArg SQLExtendedFetchBindCol_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* fetchType */
   { &TCD_long,   0, PARAM_IN  },    /* irow */
   { &TCD_ulong,  0, PARAM_OUT },    /* pcrow */
   { &TCD_ushort, 0, PARAM_OUT },    /* rgfRowStatus */
   { &BindColIn_seq, 0, PARAM_IN },  /* bind col In */
   { &BindColOut_seq,0, PARAM_OUT }, /* bind col Out */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLGetData (void **);
CorbaArg SQLGetData_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* icol */
   { &TCD_short,  0, PARAM_IN  },    /* fCType */
   { &TCD_any,    0, PARAM_OUT  }, /* rgbValue */
   { &TCD_long,   0, PARAM_IN  },    /* cbValueMax */
   { &TCD_long,   0, PARAM_OUT },    /* pcbValue */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

CORBA_TCKindDesc *any_seq[] = {
     &TCD_any
};

CORBA_TCKindDesc *CommAttr_item[] = {
   &TCD_long,                     /* column length */
   &TCD_long,                     /* column type */
   &TCD_long,                     /* column precision */
   &TCD_long,                     /* column scale */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc CommAttr_struct = { tk_struct, "CommAttr", CommAttr_item, 0 };

CORBA_TCKindDesc *CommAttr_struct_seq[] = {
     &CommAttr_struct
};

CORBA_TCKindDesc CommAttr_seq = { tk_sequence, "CommAttrSeq", CommAttr_struct_seq, 0 };

CORBA_TCKindDesc TCD_any_seq = { tk_sequence, "TCD_any_seq", any_seq, 0 };
extern void i_SQLGetAllData (void **);
CorbaArg SQLGetAllData_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_any_seq,0, PARAM_OUT  },   /* rgbValue */
   { &CommAttr_seq,0, PARAM_OUT  },   /* Common attribute */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLFreeStmt (void **);
CorbaArg SQLFreeStmt_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* fOption */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLAllocEnv (void **);
CorbaArg SQLAllocEnv_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_OUT },    /* phenv */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLAllocConnect (void **);
CorbaArg SQLAllocConnect_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* henv */
   { &TCD_ulong,  0, PARAM_OUT },    /* phdbc */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLConnect (void **);
CorbaArg SQLConnect_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_string, 0, PARAM_IN  },    /* szDSN */
   { &TCD_short,  0, PARAM_IN  },    /* cbDSN */
   { &TCD_string, 0, PARAM_IN  },    /* szUID */
   { &TCD_short,  0, PARAM_IN  },    /* cbUID */
   { &TCD_string, 0, PARAM_IN  },    /* szAuthStr */
   { &TCD_short,  0, PARAM_IN  },    /* cbAuthStr */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLAllocStmt (void **);
CorbaArg SQLAllocStmt_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ulong,  0, PARAM_OUT },    /* phstmt */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLDisconnect (void **);
CorbaArg SQLDisconnect_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLFreeConnect (void **);
CorbaArg SQLFreeConnect_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLFreeEnv (void **);
CorbaArg SQLFreeEnv_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* henv */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLCancel (void **);
CorbaArg SQLCancel_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLColAttributes (void **);
CorbaArg SQLColAttributes_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* icol */
   { &TCD_ushort, 0, PARAM_IN  },    /* fDescType */
   { &TCD_Principal, 0, PARAM_OUT  }, /* rgbDesc */
   { &TCD_short,  0, PARAM_IN  },    /* cbDescMax */
   { &TCD_short,  0, PARAM_OUT },    /* pcbDesc */
   { &TCD_long,   0, PARAM_OUT },    /* pfDesc */
   { &TCD_KIND_LAST, 0, END_PARAM }
};


extern void i_SQLColumns (void **);
CorbaArg SQLColumns_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_string, 0, PARAM_IN  },    /* szColumnType */
   { &TCD_short,  0, PARAM_IN  },    /* cbColumnType */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLGetConnectOption (void **);
CorbaArg SQLGetConnectOption_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ushort, 0, PARAM_IN  },    /* fOption */
   { &TCD_string, 0, PARAM_OUT },    /* pvParam-a */
   { &TCD_long  , 0, PARAM_OUT },    /* pvParam-b */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLSetConnectOption (void **);
CorbaArg SQLSetConnectOption_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ushort, 0, PARAM_IN  },    /* fOption */
   { &TCD_string, 0, PARAM_IN  },    /* pvParam-a */
   { &TCD_long  , 0, PARAM_IN  },    /* pvParam-b */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLGetStmtOption (void **);
CorbaArg SQLGetStmtOption_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ushort, 0, PARAM_IN  },    /* fOption */
   { &TCD_string, 0, PARAM_OUT },    /* pvParam-a */
   { &TCD_long  , 0, PARAM_OUT },    /* pvParam-b */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLSetStmtOption (void **);
CorbaArg SQLSetStmtOption_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ushort, 0, PARAM_IN  },    /* fOption */
   { &TCD_string, 0, PARAM_IN  },    /* pvParam-a */
   { &TCD_long  , 0, PARAM_IN  },    /* pvParam-b */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLBindParameter (void **);
CorbaArg SQLBindParameter_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* ipar */
   { &TCD_short,  0, PARAM_IN  },    /* fParamType */
   { &TCD_short,  0, PARAM_IN  },    /* fCType */
   { &TCD_short,  0, PARAM_IN  },    /* fSqlType */
   { &TCD_ulong,  0, PARAM_IN  },    /* cbColDef */
   { &TCD_short,  0, PARAM_IN  },    /* ibScale */
   { &TCD_any,    0, PARAM_IN  },    /* rgbValue */
   { &TCD_long,   0, PARAM_IN  },    /* cbValueMax */
   { &TCD_long,   0, PARAM_IN  },    /* pcbValue */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

CORBA_TCKindDesc *Param_item[] = {
   &TCD_short,                    /* fParamType */
   &TCD_short,                    /* fCType */
   &TCD_short,                    /* fSqlType */
   &TCD_ulong,                    /* cbColDef */
   &TCD_short,                    /* ibScale */
   &TCD_any,                      /* rgbValue */
   &TCD_long,                     /* cbValueMax */
   &TCD_long,                     /* pcbValue */
   &TCD_KIND_LAST
};


CORBA_TCKindDesc Param_struct = { tk_struct, "Param", Param_item, 0 };
CORBA_TCKindDesc *Param_struct_seq[] = {
     &Param_struct
};

CORBA_TCKindDesc Param_seq = { tk_sequence, "ParamSeq", Param_struct_seq, 0 };

extern void i_SQLExecuteParams (void **);
CorbaArg SQLExecuteParams_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &Param_seq  ,0, PARAM_IN  },    /* Parameters */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLExecDirectParams (void **);
CorbaArg SQLExecDirectParams_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szSqlStr */
   { &TCD_long,   0, PARAM_IN  },    /* cbSqlStr */
   { &Param_seq  ,0, PARAM_IN  },    /* Parameters */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLTransact (void **);
CorbaArg SQLTransact_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* henv */
   { &TCD_ulong,  0, PARAM_IN  },    /* hdbc */
   { &TCD_ushort, 0, PARAM_IN  },    /* fType */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLStatistics (void **);
CorbaArg SQLStatistics_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_ushort, 0, PARAM_IN  },    /* fUnique */
   { &TCD_ushort, 0, PARAM_IN  },    /* fAccuracy */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLSpecialColumns (void **);
CorbaArg SQLSpecialColumns_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_ushort, 0, PARAM_IN  },    /* fColType */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_ushort, 0, PARAM_IN  },    /* fScope */
   { &TCD_ushort, 0, PARAM_IN  },    /* fNullable */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLGetTypeInfo (void **);
CorbaArg SQLGetTypeInfo_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_short,  0, PARAM_IN  },    /* fSqlType */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLGetCursorName (void **);
CorbaArg SQLGetCursorName_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_OUT },    /* szCursor */
   { &TCD_short,  0, PARAM_IN  },    /* cbCursorMax */
   { &TCD_short,  0, PARAM_OUT },    /* pcbCursor */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLSetCursorName (void **);
CorbaArg SQLSetCursorName_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN },     /* szCursor */
   { &TCD_short,  0, PARAM_IN  },    /* cbCursor */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLNumParams (void **);
CorbaArg SQLNumParams_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_short,  0, PARAM_OUT },    /* pcpar */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLPutData (void **);
CorbaArg SQLPutData_params[] = {
   { &TCD_long,      0, PARAM_OUT }, /* Return code */
   { &TCD_ulong,     0, PARAM_IN  }, /* hstmt */
   { &TCD_Principal, 0, PARAM_IN  }, /* rgbValue */
   { &TCD_long,      0, PARAM_IN  }, /* cbValue */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLDescribeParam (void **);
CorbaArg SQLDescribeParam_params[] = {
   { &TCD_long,      0, PARAM_OUT }, /* Return code */
   { &TCD_ulong,     0, PARAM_IN  }, /* hstmt */
   { &TCD_ushort,    0, PARAM_IN  }, /* ipar */
   { &TCD_short,     0, PARAM_OUT }, /* pfSqlType */
   { &TCD_ulong,     0, PARAM_OUT }, /* pcbColDef */
   { &TCD_short,     0, PARAM_OUT }, /* pibScale */
   { &TCD_short,     0, PARAM_OUT }, /* pfNullable */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLMoreResults (void **);
CorbaArg SQLMoreResults_params[] = {
   { &TCD_long,      0, PARAM_OUT }, /* Return code */
   { &TCD_ulong,     0, PARAM_IN  }, /* hstmt */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLColumnPrivileges (void **);
CorbaArg SQLColumnPrivileges_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_string, 0, PARAM_IN  },    /* szColumnName */
   { &TCD_short,  0, PARAM_IN  },    /* cbColumnName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLForeignKeys (void **);
CorbaArg SQLForeignKeys_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szPkTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbPkTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szPkTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbPkTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szPkTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbPkTableName */
   { &TCD_string, 0, PARAM_IN  },    /* szFkTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbFkTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szFkTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbFkTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szFkTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbFkTableName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLPrimaryKeys (void **);
CorbaArg SQLPrimaryKeys_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLProcedureColumns (void **);
CorbaArg SQLProcedureColumns_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szProcQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szProcOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szProcName */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcName */
   { &TCD_string, 0, PARAM_IN  },    /* szColumnName */
   { &TCD_short,  0, PARAM_IN  },    /* cbColumnName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLProcedures (void **);
CorbaArg SQLProcedures_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szProcQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szProcOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szProcName */
   { &TCD_short,  0, PARAM_IN  },    /* cbProcName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

extern void i_SQLTablePrivileges (void **);
CorbaArg SQLTablePrivileges_params[] = {
   { &TCD_long,   0, PARAM_OUT },    /* Return code */
   { &TCD_ulong,  0, PARAM_IN  },    /* hstmt */
   { &TCD_string, 0, PARAM_IN  },    /* szTableQualifier */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableQualifier */
   { &TCD_string, 0, PARAM_IN  },    /* szTableOwner */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableOwner */
   { &TCD_string, 0, PARAM_IN  },    /* szTableName */
   { &TCD_short,  0, PARAM_IN  },    /* cbTableName */
   { &TCD_KIND_LAST, 0, END_PARAM }
};

CORBA_TCKindDesc *Timestamp_item[] = {
   &TCD_ushort,                   /* year */
   &TCD_ushort,                   /* month */
   &TCD_ushort,                   /* day */
   &TCD_ushort,                   /* hour */
   &TCD_ushort,                   /* minute */
   &TCD_ushort,                   /* second */
   &TCD_ulong,                    /* fraction */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc Timestamp_struct = { tk_struct,"Timestamp_struct",
                                                           Timestamp_item, 0 };
CORBA_TCKindDesc *Date_item[] = {
   &TCD_ushort,                   /* year */
   &TCD_ushort,                   /* month */
   &TCD_ushort,                   /* day */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc Date_struct = { tk_struct,"Date_struct", Date_item,0 };

CORBA_TCKindDesc *Time_item[] = {
   &TCD_ushort,                   /* hour */
   &TCD_ushort,                   /* minute */
   &TCD_ushort,                   /* second */
   &TCD_KIND_LAST
};

CORBA_TCKindDesc Time_struct = { tk_struct,"Time_struct", Time_item,0 };

CorbaMethod methods[] = {
   { "SQLAllocConnect", i_SQLAllocConnect, SQLAllocConnect_params },
   { "SQLAllocEnv", i_SQLAllocEnv, SQLAllocEnv_params },
   { "SQLAllocStmt", i_SQLAllocStmt, SQLAllocStmt_params },
   { "SQLBindParameter", i_SQLBindParameter, SQLBindParameter_params },
   { "SQLCancel", i_SQLCancel, SQLCancel_params },
   { "SQLColAttributes", i_SQLColAttributes, SQLColAttributes_params },
   { "SQLColumnPrivileges", i_SQLColumnPrivileges, SQLColumnPrivileges_params },
   { "SQLColumns", i_SQLColumns, SQLColumns_params },
   { "SQLConnect", i_SQLConnect, SQLConnect_params },
   { "SQLDescribeCol", i_SQLDescribeCol, SQLDescribeCol_params },
   { "SQLDescribeParam", i_SQLDescribeParam, SQLDescribeParam_params },
   { "SQLDisconnect", i_SQLDisconnect, SQLDisconnect_params },
   { "SQLError", i_SQLError, SQLError_params },
   { "SQLExecDirect", i_SQLExecDirect, SQLExecDirect_params },
   { "SQLExecDirectParams", i_SQLExecDirectParams, SQLExecDirectParams_params },
   { "SQLExecute", i_SQLExecute, SQLExecute_params },
   { "SQLExecuteParams", i_SQLExecuteParams, SQLExecuteParams_params },
   { "SQLExtendedFetch", i_SQLExtendedFetch, SQLExtendedFetch_params },
   { "SQLExtendedFetchBindCol", i_SQLExtendedFetchBindCol,
                                  SQLExtendedFetchBindCol_params },
   { "SQLFetch", i_SQLFetch, SQLFetch_params },
   { "SQLFetchBindCol", i_SQLFetchBindCol, SQLFetchBindCol_params },
   { "SQLForeignKeys", i_SQLForeignKeys, SQLForeignKeys_params },
   { "SQLFreeConnect", i_SQLFreeConnect, SQLFreeConnect_params },
   { "SQLFreeEnv", i_SQLFreeEnv, SQLFreeEnv_params },
   { "SQLFreeStmt", i_SQLFreeStmt, SQLFreeStmt_params },
   { "SQLGetConnectOption", i_SQLGetConnectOption, SQLGetConnectOption_params },
   { "SQLGetCursorName", i_SQLGetCursorName, SQLGetCursorName_params },
   { "SQLGetStmtOption", i_SQLGetStmtOption, SQLGetStmtOption_params },
   { "SQLGetData", i_SQLGetData, SQLGetData_params },
   { "SQLGetAllData", i_SQLGetAllData, SQLGetAllData_params },
   { "SQLGetTypeInfo", i_SQLGetTypeInfo, SQLGetTypeInfo_params },
   { "SQLMoreResults", i_SQLMoreResults, SQLMoreResults_params },
   { "SQLNumParams", i_SQLNumParams, SQLNumParams_params },
   { "SQLNumResultCols", i_SQLNumResultCols, SQLNumResultCols_params },
   { "SQLPrepare", i_SQLPrepare, SQLPrepare_params },
   { "SQLPrimaryKeys", i_SQLPrimaryKeys, SQLPrimaryKeys_params },
   { "SQLProcedureColumns", i_SQLProcedureColumns, SQLProcedureColumns_params },
   { "SQLProcedures", i_SQLProcedures, SQLProcedures_params },
   { "SQLPutData", i_SQLPutData, SQLPutData_params },
   { "SQLRowCount", i_SQLRowCount, SQLRowCount_params },
   { "SQLSetConnectOption", i_SQLSetConnectOption, SQLSetConnectOption_params },
   { "SQLSetCursorName", i_SQLSetCursorName, SQLSetCursorName_params },
   { "SQLSetStmtOption", i_SQLSetStmtOption, SQLSetStmtOption_params },
   { "SQLSpecialColumns", i_SQLSpecialColumns, SQLSpecialColumns_params },
   { "SQLStatistics", i_SQLStatistics, SQLStatistics_params },
   { "SQLTablePrivileges", i_SQLTablePrivileges, SQLTablePrivileges_params },
   { "SQLTables", i_SQLTables, SQLTables_params },
   { "SQLTransact", i_SQLTransact, SQLTransact_params },
   { 0, 0, 0 }
};

