/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSQL - common include files

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef odbcsql_h
# define odbcsql_h "$Id$"

# include "win4unix.h"

typedef enum {
   SQL_UNKNOWN_TYPE = 0,
   SQL_CHAR = 1,
   SQL_NUMERIC = 2,
   SQL_DECIMAL = 3,
   SQL_INTEGER = 4,
   SQL_SMALLINT = 5,
   SQL_FLOAT = 6,
   SQL_REAL = 7,
   SQL_DOUBLE = 8,
   SQL_DATE = 9,
   SQL_TIME = 10,
   SQL_TIMESTAMP = 11,
   SQL_VARCHAR = 12,
   SQL_LONGVARCHAR = -1,
   SQL_BINARY = -2,
   SQL_VARBINARY = -3,
   SQL_LONGVARBINARY = -4,
   SQL_BIGINT = -5,
   SQL_TINYINT = -6,
   SQL_BIT = -7
} SQLTypes;

#define SQL_SIGNED_OFFSET -20
#define SQL_UNSIGNED_OFFSET -22

#define SQL_C_UNKNOWN_TYPE SQL_UNKNOWN_TYPE
#define SQL_C_CHAR SQL_CHAR
#define SQL_C_BINARY SQL_BINARY
#define SQL_C_BIT SQL_BIT
#define SQL_C_DATE SQL_DATE
#define SQL_C_DOUBLE SQL_DOUBLE
#define SQL_C_FLOAT SQL_REAL
#define SQL_C_LONG SQL_INTEGER
#define SQL_C_SHORT SQL_SMALLINT
#define SQL_C_TIME SQL_TIME
#define SQL_C_TIMESTAMP SQL_TIMESTAMP
#define SQL_C_TINYINT SQL_TINYINT
#define SQL_C_STINYINT SQL_TINYINT + SQL_SIGNED_OFFSET
#define SQL_C_UTINYINT SQL_TINYINT + SQL_UNSIGNED_OFFSET
#define SQL_C_SSHORT SQL_C_SHORT + SQL_SIGNED_OFFSET
#define SQL_C_USHORT SQL_C_SHORT + SQL_UNSIGNED_OFFSET
#define SQL_C_SLONG SQL_C_LONG + SQL_SIGNED_OFFSET
#define SQL_C_ULONG SQL_C_LONG + SQL_UNSIGNED_OFFSET
#define SQL_C_DEFAULT 99
typedef int AttrCType ;

typedef void *HENV;
typedef void *HDBC;
typedef void *HSTMT; 
typedef HENV SQLHENV;
typedef HDBC SQLHDBC;
typedef HSTMT SQLHSTMT;

#define SQL_NULL_HENV ((HENV) 0)
#define SQL_NULL_HDBC ((HDBC) 0)
#define SQL_NULL_HSTMT ((HSTMT) 0)

typedef struct tTIMESTAMP_STRUCT
{
   SWORD year;
   UWORD month;
   UWORD day;
   UWORD hour;
   UWORD minute;
   UWORD second;
   UDWORD fraction;
} TIMESTAMP_STRUCT;

typedef struct tTIME_STRUCT
{
   UWORD   hour;
   UWORD   minute;
   UWORD   second;
} TIME_STRUCT;

typedef struct tDATE_STRUCT
{
   SWORD    year;
   UWORD   month;
   UWORD   day;
} DATE_STRUCT;

typedef enum {
   SQL_SUCCESS = 0,
   SQL_SUCCESS_WITH_INFO = 1,
   SQL_NO_DATA_FOUND = 100,
   SQL_ERROR = -1,
   SQL_INVALID_HANDLE = -2
} RETCODE;

typedef RETCODE SQLRETURN;
typedef short SQLSMALLINT;
typedef unsigned short SQLUSMALLINT;
typedef long SQLINTEGER;
typedef unsigned long SQLUINTEGER;
typedef void *SQLPOINTER;

#define SQL_NULL_DATA -1
#define SQL_DATA_AT_EXEC -2
#define SQL_NTS -3
#define SQL_STILL_EXECUTING 2
#define SQL_NEED_DATA 99

#define SQL_ROW_SUCCESS 0
#define SQL_ROW_DELETED 1
#define SQL_ROW_UPDATED 2
#define SQL_ROW_NOROW 3
#define SQL_ROW_ADDED 4
#define SQL_ROW_ERROR 5
#define SQL_ROW_SUCCESS_WITH_INFO 6
#define SQL_ROW_PROCEED 0
#define SQL_ROW_IGNORE  1

/* Values for SQLStatistics() */
#define SQL_QUICK 0
#define SQL_ENSURE 1

/* Values for UNIQUE argument of SQLStatistics() */
#define SQL_INDEX_UNIQUE 0
#define SQL_INDEX_ALL 1

#define SQL_MODE_READ_WRITE 0UL
#define SQL_MODE_READ_ONLY 1UL
#define SQL_MODE_DEFAULT SQL_MODE_READ_WRITE

#define SQL_ATTR_READONLY 0
#define SQL_ATTR_WRITE 1
#define SQL_ATTR_READWRITE_UNKNOWN 2


#define SQL_COMMIT 0
#define SQL_ROLLBACK 1

/************************************************/
/* Extended definitions for SQLGetInfo          */
/************************************************/

/*---------------------------------*/
/* Values in ODBC 2.0 that are not */
/* in the X/Open spec              */
/*---------------------------------*/

#define SQL_INFO_FIRST                       0
#define SQL_ACTIVE_CONNECTIONS               0  /* MAX_DRIVER_CONNECTIONS */
#define SQL_ACTIVE_STATEMENTS                1  /* MAX_CONCURRENT_ACTIVITIES */
#define SQL_DRIVER_HDBC                      3
#define SQL_DRIVER_HENV                      4
#define SQL_DRIVER_HSTMT                     5
#define SQL_DRIVER_NAME                      6
#define SQL_DRIVER_VER                       7
#define SQL_ODBC_API_CONFORMANCE             9
#define SQL_ODBC_VER                        10
#define SQL_ROW_UPDATES                     11
#define SQL_ODBC_SAG_CLI_CONFORMANCE        12
#define SQL_ODBC_SQL_CONFORMANCE            15


#define SQL_PROCEDURES                      21
#define SQL_CONCAT_NULL_BEHAVIOR            22
#define SQL_CURSOR_ROLLBACK_BEHAVIOR        24
#define SQL_EXPRESSIONS_IN_ORDERBY          27
#define SQL_MAX_OWNER_NAME_LEN              32  /* MAX_SCHEMA_NAME_LEN */
#define SQL_MAX_PROCEDURE_NAME_LEN          33
#define SQL_MAX_QUALIFIER_NAME_LEN          34  /* MAX_CATALOG_NAME_LEN */
#define SQL_MULT_RESULT_SETS                36
#define SQL_MULTIPLE_ACTIVE_TXN             37
#define SQL_OUTER_JOINS                     38
#define SQL_OWNER_TERM                      39
#define SQL_PROCEDURE_TERM                  40
#define SQL_QUALIFIER_NAME_SEPARATOR        41
#define SQL_QUALIFIER_TERM                  42
#define SQL_SCROLL_OPTIONS                  44
#define SQL_TABLE_TERM                      45
#define SQL_CONVERT_FUNCTIONS               48
#define SQL_NUMERIC_FUNCTIONS               49
#define SQL_STRING_FUNCTIONS                50
#define SQL_SYSTEM_FUNCTIONS                51
#define SQL_TIMEDATE_FUNCTIONS              52
#define SQL_CONVERT_BIGINT                  53
#define SQL_CONVERT_BINARY                  54
#define SQL_CONVERT_BIT                     55
#define SQL_CONVERT_CHAR                    56
#define SQL_CONVERT_DATE                    57
#define SQL_CONVERT_DECIMAL                 58
#define SQL_CONVERT_DOUBLE                  59
#define SQL_CONVERT_FLOAT                   60
#define SQL_CONVERT_INTEGER                 61
#define SQL_CONVERT_LONGVARCHAR             62
#define SQL_CONVERT_NUMERIC                 63
#define SQL_CONVERT_REAL                    64
#define SQL_CONVERT_SMALLINT                65
#define SQL_CONVERT_TIME                    66
#define SQL_CONVERT_TIMESTAMP               67
#define SQL_CONVERT_TINYINT                 68
#define SQL_CONVERT_VARBINARY               69
#define SQL_CONVERT_VARCHAR                 70
#define SQL_CONVERT_LONGVARBINARY           71
#define SQL_ODBC_SQL_OPT_IEF                73          /* SQL_INTEGRITY */
#define SQL_CORRELATION_NAME                74
#define SQL_NON_NULLABLE_COLUMNS            75
#define SQL_DRIVER_HLIB                     76
#define SQL_DRIVER_ODBC_VER                 77
#define SQL_LOCK_TYPES                      78
#define SQL_POS_OPERATIONS                  79
#define SQL_POSITIONED_STATEMENTS           80
#define SQL_BOOKMARK_PERSISTENCE            82
#define SQL_STATIC_SENSITIVITY              83
#define SQL_FILE_USAGE                      84
#define SQL_COLUMN_ALIAS                    87
#define SQL_GROUP_BY                        88
#define SQL_KEYWORDS                        89
#define SQL_OWNER_USAGE                     91
#define SQL_QUALIFIER_USAGE                 92
#define SQL_QUOTED_IDENTIFIER_CASE          93
#define SQL_SUBQUERIES                      95
#define SQL_UNION                           96
#define SQL_MAX_ROW_SIZE_INCLUDES_LONG      103
#define SQL_MAX_CHAR_LITERAL_LEN            108
#define SQL_TIMEDATE_ADD_INTERVALS          109
#define SQL_TIMEDATE_DIFF_INTERVALS         110
#define SQL_NEED_LONG_DATA_LEN              111
#define SQL_MAX_BINARY_LITERAL_LEN          112
#define SQL_LIKE_ESCAPE_CLAUSE              113
#define SQL_QUALIFIER_LOCATION              114

/* Information requested by SQLGetInfo() */

#define SQL_MAX_DRIVER_CONNECTIONS         0
#define SQL_MAXIMUM_DRIVER_CONNECTIONS     SQL_MAX_DRIVER_CONNECTIONS
#define SQL_MAX_CONCURRENT_ACTIVITIES      1
#define SQL_MAXIMUM_CONCURRENT_ACTIVITIES  SQL_MAX_CONCURRENT_ACTIVITIES
#define SQL_DATA_SOURCE_NAME               2
#define SQL_FETCH_DIRECTION                8
#define SQL_SERVER_NAME                    13
#define SQL_SEARCH_PATTERN_ESCAPE          14
#define SQL_DBMS_NAME                      17
#define SQL_DBMS_VER                       18
#define SQL_ACCESSIBLE_TABLES              19
#define SQL_ACCESSIBLE_PROCEDURES          20
#define SQL_CURSOR_COMMIT_BEHAVIOR         23
#define SQL_DATA_SOURCE_READ_ONLY          25
#define SQL_DEFAULT_TXN_ISOLATION          26
#define SQL_IDENTIFIER_CASE                28
#define SQL_IDENTIFIER_QUOTE_CHAR          29
#define SQL_MAX_COLUMN_NAME_LEN            30
#define SQL_MAXIMUM_COLUMN_NAME_LENGTH     SQL_MAX_COLUMN_NAME_LEN
#define SQL_MAX_CURSOR_NAME_LEN            31
#define SQL_MAXIMUM_CURSOR_NAME_LENGTH     SQL_MAX_CURSOR_NAME_LEN
#define SQL_MAX_SCHEMA_NAME_LEN            32
#define SQL_MAXIMUM_SCHEMA_NAME_LENGTH     SQL_MAX_SCHEMA_NAME_LEN
#define SQL_MAX_CATALOG_NAME_LEN           34
#define SQL_MAXIMUM_CATALOG_NAME_LENGTH    SQL_MAX_CATALOG_NAME_LEN
#define SQL_MAX_TABLE_NAME_LEN             35
#define SQL_SCROLL_CONCURRENCY             43
#define SQL_TXN_CAPABLE                    46
#define SQL_TRANSACTION_CAPABLE            SQL_TXN_CAPABLE
#define SQL_USER_NAME                      47
#define SQL_TXN_ISOLATION_OPTION           72
#define SQL_TRANSACTION_ISOLATION_OPTION   SQL_TXN_ISOLATION_OPTION
#define SQL_INTEGRITY                      73
#define SQL_GETDATA_EXTENSIONS             81
#define SQL_NULL_COLLATION                 85
#define SQL_ALTER_TABLE                    86
#define SQL_ORDER_BY_COLUMNS_IN_SELECT     90
#define SQL_SPECIAL_CHARACTERS             94
#define SQL_MAX_COLUMNS_IN_GROUP_BY        97
#define SQL_MAXIMUM_COLUMNS_IN_GROUP_BY    SQL_MAX_COLUMNS_IN_GROUP_BY
#define SQL_MAX_COLUMNS_IN_INDEX           98
#define SQL_MAXIMUM_COLUMNS_IN_INDEX       SQL_MAX_COLUMNS_IN_INDEX
#define SQL_MAX_COLUMNS_IN_ORDER_BY        99
#define SQL_MAXIMUM_COLUMNS_IN_ORDER_BY    SQL_MAX_COLUMNS_IN_ORDER_BY
#define SQL_MAX_COLUMNS_IN_SELECT          100
#define SQL_MAXIMUM_COLUMNS_IN_SELECT      SQL_MAX_COLUMNS_IN_SELECT
#define SQL_MAX_COLUMNS_IN_TABLE           101
#define SQL_MAX_INDEX_SIZE                 102
#define SQL_MAXIMUM_INDEX_SIZE             SQL_MAX_INDEX_SIZE
#define SQL_MAX_ROW_SIZE                   104
#define SQL_MAXIMUM_ROW_SIZE               SQL_MAX_ROW_SIZE
#define SQL_MAX_STATEMENT_LEN              105
#define SQL_MAXIMUM_STATEMENT_LENGTH       SQL_MAX_STATEMENT_LEN
#define SQL_MAX_TABLES_IN_SELECT           106
#define SQL_MAXIMUM_TABLES_IN_SELECT       SQL_MAX_TABLES_IN_SELECT
#define SQL_MAX_USER_NAME_LEN              107
#define SQL_MAXIMUM_USER_NAME_LENGTH       SQL_MAX_USER_NAME_LEN
#define SQL_OJ_CAPABILITIES                115
#define SQL_OUTER_JOIN_CAPABILITIES        SQL_OJ_CAPABILITIES
/* ODBCCER >= 300 */
#define SQL_ACTIVE_ENVIRONMENTS            116
#define    SQL_ALTER_DOMAIN                117

#define    SQL_SQL_CONFORMANCE             118
#define SQL_DATETIME_LITERALS              119

#define    SQL_ASYNC_MODE                  10021    /* new X/Open spec */
#define SQL_BATCH_ROW_COUNT                120
#define SQL_BATCH_SUPPORT                  121
#define SQL_CATALOG_LOCATION               SQL_QUALIFIER_LOCATION
#define SQL_CATALOG_NAME_SEPARATOR         SQL_QUALIFIER_NAME_SEPARATOR
#define SQL_CATALOG_TERM                   SQL_QUALIFIER_TERM
#define SQL_CATALOG_USAGE                  SQL_QUALIFIER_USAGE
#define SQL_CONVERT_WCHAR                  122
#define SQL_CONVERT_INTERVAL_DAY_TIME      123
#define SQL_CONVERT_INTERVAL_YEAR_MONTH    124
#define SQL_CONVERT_WLONGVARCHAR           125
#define SQL_CONVERT_WVARCHAR               126
#define SQL_CREATE_ASSERTION               127
#define SQL_CREATE_CHARACTER_SET           128
#define SQL_CREATE_COLLATION               129
#define SQL_CREATE_DOMAIN                  130
#define SQL_CREATE_SCHEMA                  131
#define SQL_CREATE_TABLE                   132
#define SQL_CREATE_TRANSLATION             133
#define SQL_CREATE_VIEW                    134
#define SQL_DRIVER_HDESC                   135
#define SQL_DROP_ASSERTION                 136
#define SQL_DROP_CHARACTER_SET             137
#define SQL_DROP_COLLATION                 138
#define SQL_DROP_DOMAIN                    139
#define SQL_DROP_SCHEMA                    140
#define SQL_DROP_TABLE                     141
#define SQL_DROP_TRANSLATION               142
#define SQL_DROP_VIEW                      143
#define SQL_DYNAMIC_CURSOR_ATTRIBUTES1     144
#define SQL_DYNAMIC_CURSOR_ATTRIBUTES2     145
#define SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1 146        
#define SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 147
#define SQL_INDEX_KEYWORDS                 148
#define SQL_INFO_SCHEMA_VIEWS              149
#define SQL_KEYSET_CURSOR_ATTRIBUTES1      150
#define SQL_KEYSET_CURSOR_ATTRIBUTES2      151
#define SQL_MAX_ASYNC_CONCURRENT_STATEMENTS 10022    /* new X/Open spec */
#define SQL_ODBC_INTERFACE_CONFORMANCE     152
#define SQL_PARAM_ARRAY_ROW_COUNTS         153
#define SQL_PARAM_ARRAY_SELECTS            154
#define SQL_SCHEMA_TERM                    SQL_OWNER_TERM
#define SQL_SCHEMA_USAGE                   SQL_OWNER_USAGE
#define SQL_SQL92_DATETIME_FUNCTIONS       155
#define SQL_SQL92_FOREIGN_KEY_DELETE_RULE  156        
#define SQL_SQL92_FOREIGN_KEY_UPDATE_RULE  157        
#define SQL_SQL92_GRANT                    158
#define SQL_SQL92_NUMERIC_VALUE_FUNCTIONS  159
#define SQL_SQL92_PREDICATES               160
#define SQL_SQL92_RELATIONAL_JOIN_OPERATORS 161
#define SQL_SQL92_REVOKE                   162
#define SQL_SQL92_ROW_VALUE_CONSTRUCTOR    163
#define SQL_SQL92_STRING_FUNCTIONS         164
#define SQL_SQL92_VALUE_EXPRESSIONS        165
#define SQL_STANDARD_CLI_CONFORMANCE       166
#define SQL_STATIC_CURSOR_ATTRIBUTES1      167    
#define SQL_STATIC_CURSOR_ATTRIBUTES2      168

#define SQL_AGGREGATE_FUNCTIONS            169
#define SQL_DDL_INDEX                      170
#define SQL_DM_VER                         171
#define SQL_INSERT_STATEMENT               172
#define SQL_UNION_STATEMENT                SQL_UNION

/* SQL_FETCH_DIRECTION bitmasks */
#define SQL_FD_FETCH_NEXT                   0x00000001L
#define SQL_FD_FETCH_FIRST                  0x00000002L
#define SQL_FD_FETCH_LAST                   0x00000004L
#define SQL_FD_FETCH_PRIOR                  0x00000008L
#define SQL_FD_FETCH_ABSOLUTE               0x00000010L
#define SQL_FD_FETCH_RELATIVE               0x00000020L

#define SQL_FN_CVT_CONVERT                  0x00000001L

#define SQL_CVT_CHAR                        0x00000001L
#define SQL_CVT_NUMERIC                     0x00000002L
#define SQL_CVT_DECIMAL                     0x00000004L
#define SQL_CVT_INTEGER                     0x00000008L
#define SQL_CVT_SMALLINT                    0x00000010L
#define SQL_CVT_FLOAT                       0x00000020L
#define SQL_CVT_REAL                        0x00000040L
#define SQL_CVT_DOUBLE                      0x00000080L
#define SQL_CVT_VARCHAR                     0x00000100L
#define SQL_CVT_LONGVARCHAR                 0x00000200L
#define SQL_CVT_BINARY                      0x00000400L
#define SQL_CVT_VARBINARY                   0x00000800L
#define SQL_CVT_BIT                         0x00001000L
#define SQL_CVT_TINYINT                     0x00002000L
#define SQL_CVT_BIGINT                      0x00004000L
#define SQL_CVT_DATE                        0x00008000L
#define SQL_CVT_TIME                        0x00010000L
#define SQL_CVT_TIMESTAMP                   0x00020000L
#define SQL_CVT_LONGVARBINARY               0x00040000L

#define SQL_FN_NUM_ABS                      0x00000001L
#define SQL_FN_NUM_ACOS                     0x00000002L
#define SQL_FN_NUM_ASIN                     0x00000004L
#define SQL_FN_NUM_ATAN                     0x00000008L
#define SQL_FN_NUM_ATAN2                    0x00000010L
#define SQL_FN_NUM_CEILING                  0x00000020L
#define SQL_FN_NUM_COS                      0x00000040L
#define SQL_FN_NUM_COT                      0x00000080L
#define SQL_FN_NUM_EXP                      0x00000100L
#define SQL_FN_NUM_FLOOR                    0x00000200L
#define SQL_FN_NUM_LOG                      0x00000400L
#define SQL_FN_NUM_MOD                      0x00000800L
#define SQL_FN_NUM_SIGN                     0x00001000L
#define SQL_FN_NUM_SIN                      0x00002000L
#define SQL_FN_NUM_SQRT                     0x00004000L
#define SQL_FN_NUM_TAN                      0x00008000L
#define SQL_FN_NUM_PI                       0x00010000L
#define SQL_FN_NUM_RAND                     0x00020000L
#define SQL_FN_NUM_DEGREES                  0x00040000L
#define SQL_FN_NUM_LOG10                    0x00080000L
#define SQL_FN_NUM_POWER                    0x00100000L
#define SQL_FN_NUM_RADIANS                  0x00200000L
#define SQL_FN_NUM_ROUND                    0x00400000L
#define SQL_FN_NUM_TRUNCATE                 0x00800000L
#define SQL_FN_STR_CONCAT                   0x00000001L
#define SQL_FN_STR_INSERT                   0x00000002L
#define SQL_FN_STR_LEFT                     0x00000004L
#define SQL_FN_STR_LTRIM                    0x00000008L
#define SQL_FN_STR_LENGTH                   0x00000010L
#define SQL_FN_STR_LOCATE                   0x00000020L
#define SQL_FN_STR_LCASE                    0x00000040L
#define SQL_FN_STR_REPEAT                   0x00000080L
#define SQL_FN_STR_REPLACE                  0x00000100L
#define SQL_FN_STR_RIGHT                    0x00000200L
#define SQL_FN_STR_RTRIM                    0x00000400L
#define SQL_FN_STR_SUBSTRING                0x00000800L
#define SQL_FN_STR_UCASE                    0x00001000L
#define SQL_FN_STR_ASCII                    0x00002000L
#define SQL_FN_STR_CHAR                     0x00004000L
#define SQL_FN_STR_DIFFERENCE               0x00008000L
#define SQL_FN_STR_LOCATE_2                 0x00010000L
#define SQL_FN_STR_SOUNDEX                  0x00020000L
#define SQL_FN_STR_SPACE                    0x00040000L

#define SQL_OJ_LEFT                         0x00000001L
#define SQL_OJ_RIGHT                        0x00000002L
#define SQL_OJ_FULL                         0x00000004L
#define SQL_OJ_NESTED                       0x00000008L
#define SQL_OJ_NOT_ORDERED                  0x00000010L
#define SQL_OJ_INNER                        0x00000020L
#define SQL_OJ_ALL_COMPARISON_OPS           0x00000040L

#define SQL_SCCO_READ_ONLY                  0x00000001L
#define SQL_SCCO_LOCK                       0x00000002L
#define SQL_SCCO_OPT_ROWVER                 0x00000004L

#define SQL_TC_NONE                         0
#define SQL_TC_DML                          1
#define SQL_TC_ALL                          2
#define SQL_TC_DDL_COMMIT                   3
#define SQL_TC_DDL_IGNORE                   4

#define SQL_SO_FORWARD_ONLY                 0x00000001L
#define SQL_SO_KEYSET_DRIVEN                0x00000002L
#define SQL_SO_DYNAMIC                      0x00000004L
#define SQL_SO_MIXED                        0x00000008L
#define SQL_SO_STATIC                       0x00000010L

#define SQL_OSC_MINIMUM                     0x0000
#define SQL_OSC_CORE                        0x0001
#define SQL_OSC_EXTENDED                    0x0002


#define SQL_OAC_NONE                        0x0000
#define SQL_OAC_LEVEL1                      0x0001
#define SQL_OAC_LEVEL2                      0x0002


#define SQL_OSCC_NOT_COMPLIANT              0x0000
#define SQL_OSCC_COMPLIANT                  0x0001


#define SQL_LCK_NO_CHANGE                   0x00000001L
#define SQL_LCK_EXCLUSIVE                   0x00000002L
#define SQL_LCK_UNLOCK                      0x00000004L

#define SQL_GD_ANY_COLUMN                   0x00000001L
#define SQL_GD_ANY_ORDER                    0x00000002L
#define SQL_GD_BLOCK                        0x00000004L
#define SQL_GD_BOUND                        0x00000008L

#define SQL_CB_DELETE                       0
#define SQL_CB_CLOSE                        1
#define SQL_CB_PRESERVE                     2

#define SQL_CB_NULL                         0x0000
#define SQL_CB_NON_NULL                     0x0001

#define SQL_TXN_READ_UNCOMMITTED            0x00000001L
#define SQL_TRANSACTION_READ_UNCOMMITTED    SQL_TXN_READ_UNCOMMITTED
#define SQL_TXN_READ_COMMITTED              0x00000002L
#define SQL_TRANSACTION_READ_COMMITTED      SQL_TXN_READ_COMMITTED
#define SQL_TXN_REPEATABLE_READ             0x00000004L
#define SQL_TRANSACTION_REPEATABLE_READ     SQL_TXN_REPEATABLE_READ
#define SQL_TXN_SERIALIZABLE                0x00000008L
#define SQL_TRANSACTION_SERIALIZABLE        SQL_TXN_SERIALIZABLE

#define SQL_IC_UPPER                        1
#define SQL_IC_LOWER                        2
#define SQL_IC_SENSITIVE                    3
#define SQL_IC_MIXED                        4

#define SQL_CN_NONE                         0x0000
#define SQL_CN_DIFFERENT                    0x0001
#define SQL_CN_ANY                          0x0002

#define SQL_DATABASE_NAME                   16

#define SQL_NNC_NULL                        0x0000
#define SQL_NNC_NON_NULL                    0x0001


#define SQL_FILE_NOT_SUPPORTED              0x0000
#define SQL_FILE_TABLE                      0x0001
#define SQL_FILE_QUALIFIER                  0x0002
#define SQL_FILE_CATALOG                    SQL_FILE_QUALIFIER 

#define SQL_GB_NOT_SUPPORTED                0x0000
#define SQL_GB_GROUP_BY_EQUALS_SELECT       0x0001
#define SQL_GB_GROUP_BY_CONTAINS_SELECT     0x0002
#define SQL_GB_NO_RELATION                  0x0003
#define SQL_SQ_COMPARISON                   0x00000001L
#define SQL_SQ_EXISTS                       0x00000002L
#define SQL_SQ_IN                           0x00000004L
#define SQL_SQ_QUANTIFIED                   0x00000008L
#define SQL_SQ_CORRELATED_SUBQUERIES        0x00000010L

#define SQL_NC_HIGH                         0
#define SQL_NC_LOW                          1

#define SQL_ACCESS_MODE                 101
#define SQL_AUTOCOMMIT                  102
#define SQL_LOGIN_TIMEOUT               103
#define SQL_OPT_TRACE                   104
#define SQL_OPT_TRACEFILE               105
#define SQL_TRANSLATE_DLL               106
#define SQL_TRANSLATE_OPTION            107
#define SQL_TXN_ISOLATION               108
#define SQL_CURRENT_QUALIFIER           109
#define SQL_ODBC_CURSORS                110
#define SQL_QUIET_MODE                  111
#define SQL_PACKET_SIZE                 112

#define SQL_QUERY_TIMEOUT               0
#define SQL_MAX_ROWS                    1
#define SQL_NOSCAN                      2
#define SQL_MAX_LENGTH                  3
#define SQL_ASYNC_ENABLE                4 /* same as SQL_ATTR_ASYNC_ENABLE */
#define SQL_BIND_TYPE                   5
#define SQL_CURSOR_TYPE                 6
#define SQL_CONCURRENCY                 7
#define SQL_KEYSET_SIZE                 8
#define SQL_ROWSET_SIZE                 9
#define SQL_SIMULATE_CURSOR             10
#define SQL_RETRIEVE_DATA               11
#define SQL_USE_BOOKMARKS               12
#define SQL_GET_BOOKMARK                13 /*      GetStmtOption Only */
#define SQL_ROW_NUMBER                  14 /*      GetStmtOption Only */

#define SQL_AUTOCOMMIT_OFF              0UL
#define SQL_AUTOCOMMIT_ON               1UL
#define SQL_AUTOCOMMIT_DEFAULT          SQL_AUTOCOMMIT_ON

#define SQL_CONCUR_READ_ONLY            1
#define SQL_CONCUR_LOCK                 2
#define SQL_CONCUR_ROWVER               3
#define SQL_CONCUR_VALUES               4
#define SQL_CONCUR_DEFAULT              SQL_CONCUR_READ_ONLY

#define SQL_CURSOR_FORWARD_ONLY         0UL
#define SQL_CURSOR_KEYSET_DRIVEN        1UL
#define SQL_CURSOR_DYNAMIC              2UL
#define SQL_CURSOR_STATIC               3UL
#define SQL_CURSOR_TYPE_DEFAULT         SQL_CURSOR_FORWARD_ONLY

#define SQL_CUR_USE_IF_NEEDED           0UL
#define SQL_CUR_USE_ODBC                1UL
#define SQL_CUR_USE_DRIVER              2UL
#define SQL_CUR_DEFAULT                 SQL_CUR_USE_DRIVER

#define SQL_NOSCAN_OFF                  0UL     /*      1.0 FALSE */
#define SQL_NOSCAN_ON                   1UL     /*      1.0 TRUE */
#define SQL_NOSCAN_DEFAULT              SQL_NOSCAN_OFF

#define SQL_ALL_TYPES       0

#define SQL_NO_NULLS        0
#define SQL_NULLABLE        1
#define SQL_NULLABLE_UNKNOWN  2

#define SQL_UNSEARCHABLE                0
#define SQL_LIKE_ONLY                   1
#define SQL_ALL_EXCEPT_LIKE             2
#define SQL_SEARCHABLE                  3
#define SQL_PRED_SEARCHABLE             SQL_SEARCHABLE


#define SQL_SCOPE_CURROW    0
#define SQL_SCOPE_TRANSACTION 1
#define SQL_SCOPE_SESSION   2

#define SQL_PC_NOT_PSEUDO               1

#define SQL_BEST_ROWID                  1
#define SQL_ROWVER                      2

#define SQL_INDEX_CLUSTERED 1
#define SQL_INDEX_HASHED    2
#define SQL_INDEX_OTHER     3

#define SQL_TABLE_STAT                  0 


#define SQL_CLOSE           0
#define SQL_DROP            1
#define SQL_UNBIND          2
#define SQL_RESET_PARAMS    3

#define SQL_SETPARAM_VALUE_MAX          (-1L)

#define SQL_COLUMN_COUNT                0
#define SQL_COLUMN_NAME                 1
#define SQL_COLUMN_TYPE                 2
#define SQL_COLUMN_LENGTH               3
#define SQL_COLUMN_PRECISION            4
#define SQL_COLUMN_SCALE                5
#define SQL_COLUMN_DISPLAY_SIZE         6
#define SQL_COLUMN_NULLABLE             7
#define SQL_COLUMN_UNSIGNED             8
#define SQL_COLUMN_MONEY                9
#define SQL_COLUMN_UPDATABLE            10
#define SQL_COLUMN_AUTO_INCREMENT       11
#define SQL_COLUMN_CASE_SENSITIVE       12
#define SQL_COLUMN_SEARCHABLE           13
#define SQL_COLUMN_TYPE_NAME            14
#define SQL_COLUMN_TABLE_NAME           15
#define SQL_COLUMN_OWNER_NAME           16
#define SQL_COLUMN_QUALIFIER_NAME       17
#define SQL_COLUMN_LABEL                18
#define SQL_COLATT_OPT_MAX              SQL_COLUMN_LABEL

#define SQL_FETCH_NEXT      1
#define SQL_FETCH_FIRST     2
#define SQL_FETCH_LAST      3
#define SQL_FETCH_PRIOR     4
#define SQL_FETCH_ABSOLUTE  5
#define SQL_FETCH_RELATIVE  6
#define SQL_FETCH_PREV      SQL_FETCH_PRIOR
#define SQL_LEN_DATA_AT_EXEC_OFFSET  (-100)
#define SQL_LEN_DATA_AT_EXEC(length) (-(length)+SQL_LEN_DATA_AT_EXEC_OFFSET)

#define SQL_PARAM_TYPE_UNKNOWN           0
#define SQL_PARAM_INPUT                  1
#define SQL_PARAM_INPUT_OUTPUT           2
#define SQL_RESULT_COL                   3
#define SQL_PARAM_OUTPUT                 4
#define SQL_RETURN_VALUE                 5

/* Options for SQLDriverConnect */
#define SQL_DRIVER_NOPROMPT             0
#define SQL_DRIVER_COMPLETE             1
#define SQL_DRIVER_PROMPT               2
#define SQL_DRIVER_COMPLETE_REQUIRED    3

/* SQL_VIEW values */
#define SQL_CV_CREATE_VIEW   0x00000001L
#define SQL_CV_CHECK_OPTION  0x00000002L
#define SQL_CV_CASCADED      0x00000004L
#define SQL_CV_LOCAL         0x00000008L

#ifdef __cplusplus
extern "C"
{
#endif

  RETCODE SQL_API SQLAllocConnect (HENV henv, HDBC FAR * phdbc);
  RETCODE SQL_API SQLAllocEnv (HENV FAR * phenv);
  RETCODE SQL_API SQLAllocStmt (HDBC hdbc, HSTMT FAR * phstmt);
  RETCODE SQL_API SQLBindCol (HSTMT hstmt, UWORD icol, SWORD fCType,
      PTR rgbValue, SDWORD cbValueMax, SDWORD FAR * pcbValue);
  RETCODE SQL_API SQLCancel (HSTMT hstmt);
  RETCODE SQL_API SQLColAttributes (HSTMT hstmt, UWORD icol, UWORD fDescType,
      PTR rgbDesc, SWORD cbDescMax, SWORD FAR * pcbDesc, SDWORD FAR * pfDesc);
  RETCODE SQL_API SQLConnect (HDBC hdbc, UCHAR FAR * szDSN, SWORD cbDSN,
      UCHAR FAR * szUID, SWORD cbUID, UCHAR FAR * szAuthStr, SWORD cbAuthStr);
  RETCODE SQL_API SQLDescribeCol (HSTMT hstmt, UWORD icol,
      UCHAR FAR * szColName, SWORD cbColNameMax, SWORD FAR * pcbColName,
      SWORD FAR * pfSqlType, UDWORD FAR * pcbColDef, SWORD FAR * pibScale,
      SWORD FAR * pfNullable);
  RETCODE SQL_API SQLDisconnect (HDBC hdbc);
  RETCODE SQL_API SQLError (HENV henv, HDBC hdbc, HSTMT hstmt,
      UCHAR FAR * szSqlState, SDWORD FAR * pfNativeError, UCHAR FAR * szErrorMsg,
      SWORD cbErrorMsgMax, SWORD FAR * pcbErrorMsg);
  RETCODE SQL_API SQLExecDirect (HSTMT hstmt, UCHAR FAR * szSqlStr,
      SDWORD cbSqlStr);
  RETCODE SQL_API SQLExecute (HSTMT hstmt);
  RETCODE SQL_API SQLFetch (HSTMT hstmt);
  RETCODE SQL_API SQLFreeConnect (HDBC hdbc);
  RETCODE SQL_API SQLFreeEnv (HENV henv);
  RETCODE SQL_API SQLFreeStmt (HSTMT hstmt, UWORD fOption);
  RETCODE SQL_API SQLGetCursorName (HSTMT hstmt, UCHAR FAR * szCursor,
      SWORD cbCursorMax, SWORD FAR * pcbCursor);
  RETCODE SQL_API SQLNumResultCols (HSTMT hstmt, SWORD FAR * pccol);
  RETCODE SQL_API SQLPrepare (HSTMT hstmt, UCHAR FAR * szSqlStr,
      SDWORD cbSqlStr);
  RETCODE SQL_API SQLRowCount (HSTMT hstmt, SDWORD FAR * pcrow);
  RETCODE SQL_API SQLSetCursorName (HSTMT hstmt, UCHAR FAR * szCursor,
      SWORD cbCursor);
  RETCODE SQL_API SQLTransact (HENV henv, HDBC hdbc, UWORD fType);

/*
 *  Depreciated ODBC 1.0 function - Use SQLBindParameter
 */
  RETCODE SQL_API SQLSetParam (HSTMT hstmt, UWORD ipar, SWORD fCType,
      SWORD fSqlType, UDWORD cbColDef, SWORD ibScale, PTR rgbValue,
      SDWORD FAR * pcbValue);
/*
 *  Level 1 function rototypes
 */
RETCODE SQL_API SQLColumns (HSTMT hstmt, UCHAR FAR * szTableQualifier,
    SWORD cbTableQualifier, UCHAR FAR * szTableOwner, SWORD cbTableOwner,
    UCHAR FAR * szTableName, SWORD cbTableName, UCHAR FAR * szColumnName,
    SWORD cbColumnName);
RETCODE SQL_API SQLDriverConnect (HDBC hdbc, HWND hwnd,
    UCHAR FAR * szConnStrIn, SWORD cbConnStrIn, UCHAR FAR * szConnStrOut,
    SWORD cbConnStrOutMax, SWORD FAR * pcbConnStrOut, UWORD fDriverCompletion);
RETCODE SQL_API SQLGetConnectOption (HDBC hdbc, UWORD fOption, PTR pvParam);
RETCODE SQL_API SQLGetData (HSTMT hstmt, UWORD icol, SWORD fCType,
    PTR rgbValue, SDWORD cbValueMax, SDWORD FAR * pcbValue);
RETCODE SQL_API SQLGetFunctions (HDBC hdbc, UWORD fFunction,
    UWORD FAR * pfExists);
RETCODE SQL_API SQLGetInfo (HDBC hdbc, UWORD fInfoType, PTR rgbInfoValue,
    SWORD cbInfoValueMax, SWORD FAR * pcbInfoValue);
RETCODE SQL_API SQLGetStmtOption (HSTMT hstmt, UWORD fOption, PTR pvParam);
RETCODE SQL_API SQLGetTypeInfo (HSTMT hstmt, SWORD fSqlType);
RETCODE SQL_API SQLParamData (HSTMT hstmt, PTR FAR * prgbValue);
RETCODE SQL_API SQLPutData (HSTMT hstmt, PTR rgbValue, SDWORD cbValue);
RETCODE SQL_API SQLSetConnectOption (HDBC hdbc, UWORD fOption, UDWORD vParam);
RETCODE SQL_API SQLSetStmtOption (HSTMT hstmt, UWORD fOption, UDWORD vParam);
RETCODE SQL_API SQLSpecialColumns (HSTMT hstmt, UWORD fColType,
    UCHAR FAR * szTableQualifier, SWORD cbTableQualifier,
    UCHAR FAR * szTableOwner, SWORD cbTableOwner, UCHAR FAR * szTableName,
    SWORD cbTableName, UWORD fScope, UWORD fNullable);
RETCODE SQL_API SQLStatistics (HSTMT hstmt, UCHAR FAR * szTableQualifier,
    SWORD cbTableQualifier, UCHAR FAR * szTableOwner, SWORD cbTableOwner,
    UCHAR FAR * szTableName, SWORD cbTableName, UWORD fUnique, UWORD fAccuracy);
RETCODE SQL_API SQLTables (HSTMT hstmt, UCHAR FAR * szTableQualifier,
    SWORD cbTableQualifier, UCHAR FAR * szTableOwner, SWORD cbTableOwner,
    UCHAR FAR * szTableName, SWORD cbTableName, UCHAR FAR * szTableType,
    SWORD cbTableType);

/*
 *  Level 2 function prototypes
 */
RETCODE SQL_API SQLBrowseConnect (HDBC hdbc, 
    UCHAR FAR * szConnStrIn, SWORD cbConnStrIn, UCHAR FAR * szConnStrOut, 
    SWORD cbConnStrOutMax, SWORD FAR * pcbConnStrOut);
RETCODE SQL_API SQLColumnPrivileges (HSTMT hstmt,
    UCHAR FAR * szTableQualifier, SWORD cbTableQualifier,
    UCHAR FAR * szTableOwner, SWORD cbTableOwner, UCHAR FAR * szTableName,
    SWORD cbTableName, UCHAR FAR * szColumnName, SWORD cbColumnName);
RETCODE SQL_API SQLDataSources (HENV henv, UWORD fDirection,
    UCHAR FAR * szDSN, SWORD cbDSNMax, SWORD FAR * pcbDSN,
    UCHAR FAR * szDescription, SWORD cbDescriptionMax,
    SWORD FAR * pcbDescription);
RETCODE SQL_API SQLDescribeParam (HSTMT hstmt, UWORD ipar,
    SWORD FAR * pfSqlType, UDWORD FAR * pcbColDef, SWORD FAR * pibScale,
    SWORD FAR * pfNullable);
RETCODE SQL_API SQLExtendedFetch (HSTMT hstmt, UWORD fFetchType, SDWORD irow,
    UDWORD FAR * pcrow, UWORD FAR * rgfRowStatus);
RETCODE SQL_API SQLForeignKeys (HSTMT hstmt, UCHAR FAR * szPkTableQualifier,
    SWORD cbPkTableQualifier, UCHAR FAR * szPkTableOwner, SWORD cbPkTableOwner,
    UCHAR FAR * szPkTableName, SWORD cbPkTableName,
    UCHAR FAR * szFkTableQualifier, SWORD cbFkTableQualifier,
    UCHAR FAR * szFkTableOwner, SWORD cbFkTableOwner, UCHAR FAR * szFkTableName,
    SWORD cbFkTableName);
RETCODE SQL_API SQLMoreResults (HSTMT hstmt);
RETCODE SQL_API SQLNativeSql (HDBC hdbc, UCHAR FAR * szSqlStrIn,
    SDWORD cbSqlStrIn, UCHAR FAR * szSqlStr, SDWORD cbSqlStrMax,
    SDWORD FAR * pcbSqlStr);
RETCODE SQL_API SQLNumParams (HSTMT hstmt, SWORD FAR * pcpar);
RETCODE SQL_API SQLParamOptions (HSTMT hstmt, UDWORD crow, UDWORD FAR * pirow);
RETCODE SQL_API SQLPrimaryKeys (HSTMT hstmt, UCHAR FAR * szTableQualifier,
    SWORD cbTableQualifier, UCHAR FAR * szTableOwner, SWORD cbTableOwner,
    UCHAR FAR * szTableName, SWORD cbTableName);
RETCODE SQL_API SQLProcedureColumns (HSTMT hstmt, UCHAR FAR * szProcQualifier,
    SWORD cbProcQualifier, UCHAR FAR * szProcOwner, SWORD cbProcOwner,
    UCHAR FAR * szProcName, SWORD cbProcName, UCHAR FAR * szColumnName,
    SWORD cbColumnName);
RETCODE SQL_API SQLProcedures (HSTMT hstmt, UCHAR FAR * szProcQualifier,
    SWORD cbProcQualifier, UCHAR FAR * szProcOwner, SWORD cbProcOwner,
    UCHAR FAR * szProcName, SWORD cbProcName);
RETCODE SQL_API SQLSetPos (HSTMT hstmt, UWORD irow, UWORD fOption, UWORD fLock);
RETCODE SQL_API SQLTablePrivileges (HSTMT hstmt, UCHAR FAR * szTableQualifier,
    SWORD cbTableQualifier, UCHAR FAR * szTableOwner, SWORD cbTableOwner,
    UCHAR FAR * szTableName, SWORD cbTableName);

/*
 *  SDK 2.0 Additional function prototypes
 */
RETCODE SQL_API SQLDrivers (HENV henv, UWORD fDirection,
    UCHAR FAR * szDriverDesc, SWORD cbDriverDescMax, SWORD FAR * pcbDriverDesc,
    UCHAR FAR * szDriverAttributes, SWORD cbDrvrAttrMax,
    SWORD FAR * pcbDrvrAttr);
RETCODE SQL_API SQLBindParameter (HSTMT hstmt, UWORD ipar, SWORD fParamType,
    SWORD fCType, SWORD fSqlType, UDWORD cbColDef, SWORD ibScale, PTR rgbValue,
    SDWORD cbValueMax, SDWORD FAR * pcbValue);

/*
 *  Depreciated - use SQLSetStmtOptions
 */
RETCODE SQL_API SQLSetScrollOptions (HSTMT hstmt, UWORD fConcurrency,
    SDWORD crowKeyset, UWORD crowRowset);


#ifdef __cplusplus
}
#endif


# endif
