/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;
import java.sql.*;
public class OdbcStatement {
   private int hStmt = 0;
   private PicoDbApi odbcApi;
   private OdbcConnection odbcCon;
   public OdbcStatement (PicoDbApi api, OdbcConnection con) throws SQLException {
      odbcApi = api;
      odbcCon = con;
      hStmt = odbcApi.SQLAllocStmt (odbcCon);
   }
   public synchronized int getHSTMT() {return hStmt;}
   public synchronized void drop () throws SQLException {
      if (hStmt != 0 && !odbcCon.isClosed())
         odbcApi.SQLFreeStmt(this, OdbcDef.SQL_DROP);
      hStmt = 0;
   }
   public synchronized void close () throws SQLException {
      if (hStmt != 0 && !odbcCon.isClosed())
         odbcApi.SQLFreeStmt(this, OdbcDef.SQL_CLOSE);
   }
   public synchronized boolean isDropped() {return hStmt == 0;}
   public void finalize() {
      try {drop();}
      catch (SQLException e) {}
   }
   synchronized public String toString() {return super.toString() + ", hStmt=" + hStmt;}
}

