/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;

import java.util.Calendar;
import java.io.InputStream;
import org.omg.CORBA.Any;

public class PicoBoundParam /* extends PicoObject */ {
   protected short fInputOutput;
   protected short fSqlType;
   protected int ibScale;
   protected Object rgbValue;

   protected InputStream paramInputStream;
   protected int paramInputStreamLen;
   protected int streamType;
   protected Calendar cal;

   public PicoBoundParam (short p_fInputOutput,short p_fSqlType,
                          int p_ibScale, Object p_rgbValue, Calendar c) {
      fInputOutput = p_fInputOutput;
      fSqlType = p_fSqlType;
      ibScale = p_ibScale;
      rgbValue = p_rgbValue;
      cal = c;
      setInputStream(null, 0);
    }

    public InputStream getInputStream() {
        return paramInputStream;
    }

    public int getInputStreamLen() {
        return paramInputStreamLen;
    }

    public int getSqlType() {
        return fSqlType;
    }

    public int getStreamType() {
        return streamType;
    }

    public boolean isOutputParameter() {
        return (fInputOutput == OdbcDef.SQL_PARAM_OUTPUT ||
                fInputOutput == OdbcDef.SQL_PARAM_INPUT_OUTPUT);
    }

    public void setInputStream(InputStream inputStream, int len) {
        paramInputStream = inputStream;
        paramInputStreamLen = len;
    }

    public void setOutputParameter(boolean isOut) {
       switch (fInputOutput) {
       default:
       case OdbcDef.SQL_PARAM_TYPE_UNKNOWN:
          if (isOut)
             fInputOutput = OdbcDef.SQL_PARAM_OUTPUT;
          break;
       case OdbcDef.SQL_PARAM_INPUT:
          if (isOut)
             fInputOutput = OdbcDef.SQL_PARAM_INPUT_OUTPUT;
          break;
       case OdbcDef.SQL_PARAM_INPUT_OUTPUT:
          if (!isOut)
             fInputOutput = OdbcDef.SQL_PARAM_INPUT;
          break;
       case OdbcDef.SQL_PARAM_OUTPUT:
          if (!isOut)
             fInputOutput = OdbcDef.SQL_PARAM_INPUT;
          break;
       }
    }

    public void setSqlType(short type) {
        fSqlType = type;
    }

    public void setStreamType(int st) {
        streamType = st;
    }
}
