/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picocpp - basic objects library for picoSQL 

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef pvector_h
# define pvector_h  "$Id: pvector.h,v 1.1 1999/03/30 08:37:57 picoSoft Exp $"
# include "pobject.h"

class PVector : public PObject {
   PCLASS(PVector,PObject)
   int numItems;
   int maxItems;
   PObject **vec;
   void alloc(int n);
public:
   PVector ();
   ~PVector ();
   void setAt (int index, PObject* obj);
   int add (PObject* obj);
   PObject *getAt (int index);
   int   size () { return numItems; }
   void  deleteAt (int index);
};

# define PVECTOR(a) \
class a##Vector : public PVector \
{ \
public: \
   int add (a * s) { return PVector::add ((PObject *) s); } \
   void setAt (int index, a * s) { PVector::setAt (index, (PObject *) s); } \
   a * getAt (int index) { return (a *) PVector::getAt (index);} \
}

# endif
