# ifndef isam_h
# define isam_h "$Id: isam.h,v 1.9 2002/05/06 11:26:34 picoSoft Exp $"

/* Machine dependant values */
typedef short INT2;
typedef unsigned short UINT2;
typedef long INT4;
typedef unsigned long UINT4;
typedef char CHAR;
typedef unsigned char UCHAR;

# define NULLSHORT   (short)0x8000U
# define NULLLONG    (long)0x80000000UL
/* */

#define CHARTYPE        0
#define CHARSIZE        1

#define INTTYPE         1
#define INTSIZE         2

#define LONGTYPE        2
#define LONGSIZE        4

#define DOUBLETYPE      3
#define DOUBLESIZE      (sizeof(double))

#define FLOATTYPE       4
#define FLOATSIZE       (sizeof(float))

#define MAXTYPE         5
#define ISDESC          0x80    /* add to make descending type  */
#define TYPEMASK        0x7F    /* type mask                    */

#define BYTEMASK  0xFF          /* mask for one byte            */
#define BYTESHFT  8             /* shift for one byte           */


void  stchar (char, char *);
void  stint (short, char *);
void  stlong (long, char *);
void  stfloat (double, char *);
void  stdbl (double, char *);

char  ldchar (char *);
short ldint (char *);
long  ldlong (char *);
double  ldfloat (char *);
double  lddbl (char *);

# define ISFIRST         0       /* first record     */
# define ISLAST          1       /* last record      */
# define ISNEXT          2       /* next record      */
# define ISPREV          3       /* previous record  */
# define ISCURR          4       /* current record   */
# define ISEQUAL         5       /* equal value      */
# define ISGREAT         6       /* greater value    */
# define ISGTEQ          7       /* >= value         */
# define ISLESS          8       /* < value          */
# define ISLTEQ          9       /* <= value         */

#define ISLOCK          0x0100   /* lock record before reading   */
#define ISAUTOLOCK      0x0200   /* automatic record lock        */
#define ISMANULOCK      0x0400   /* manual record lock           */
#define ISEXCLLOCK      0x0800   /* exclusive isam file lock     */
#define ISWAIT          0x1000   /* suspensive lock              */

#define ISINPUT         0       /* open for input only          */
#define ISOUTPUT        1       /* open for output only         */
#define ISINOUT         2       /* open for input and output    */
#define ISTRANS         4       /* open for transaction proc*/
#define ISNOLOG         8       /* no loggin for this file*/
#define ISVARLEN     0x10       /* variable length records*/
#define ISFIXLEN      0x0       /* (non-flag) fixed length records only*/

/* audit trail mode parameters */
#define AUDSETNAME      0       /* set new audit trail name     */
#define AUDGETNAME      1       /* get audit trail name         */
#define AUDSTART        2       /* start audit trail            */
#define AUDSTOP         3       /* stop audit trail             */
#define AUDINFO         4       /* audit trail running ?        */

#define MAXKEYSIZE      256     /* max number of bytes in key   */
#define NPARTS          8       /* max number of key parts      */

struct keypart
{
   short kp_start;             /* starting byte of key part    */
   short kp_leng;              /* length in bytes              */
   short kp_type;              /* type of key part             */
};

struct keydesc
{
   short k_flags;              /* flags                        */
   short k_nparts;             /* number of parts in key       */
   struct keypart
          k_part[NPARTS];      /* each key part                */
   /* the following is for internal use only   */
   short k_len;                /* length of whole key          */
   UINT4 k_rootnode;            /* pointer to rootnode          */
};

# define k_start   k_part[0].kp_start
# define k_leng    k_part[0].kp_leng
# define k_type    k_part[0].kp_type

#define ISNODUPS  000           /* no duplicates allowed and no */
                                /* compression allowed          */
#define ISDUPS    001           /* duplicates allowed           */
#define COMPRESS  016           /* all compression              */

struct dictinfo
{
   short di_nkeys;             /* number of keys defined       */
   short di_recsize;           /* data record size             */
   short di_idxsize;           /* index record size            */
   UINT4 di_nrecords;           /* number of records in file    */
};

#define EDUPL     100           /* duplicate record     */
#define ENOTOPEN  101           /* file not open        */
#define EBADARG   102           /* illegal argument     */
#define EBADKEY   103           /* illegal key desc     */
#define ETOOMANY  104           /* too many files open  */
#define EBADFILE  105           /* bad isam file format */
#define ENOTEXCL  106           /* non-exclusive access */
#define ELOCKED   107           /* record locked        */
#define EKEXISTS  108           /* key already exists   */
#define EPRIMKEY  109           /* is primary key       */
#define EENDFILE  110           /* end/begin of file    */
#define ENOREC    111           /* no record found      */
#define ENOCURR   112           /* no current record    */
#define EFLOCKED  113           /* file locked          */
#define EFNAME    114           /* file name too long   */
#define EBADMEM   116           /* can't alloc memory   */
#define EBADCOLL  117           /* bad custom collating */
#define ELOGREAD  118           /* Cannot read log file record. */
#define EBADLOG   119           /* Record format of transaction-log file cannot
                                   be recognized. */
#define ELOGOPEN  120           /* Cannot open transaction-log file. */
#define ELOGWRIT  121           /* Cannot write to transaction-log file. */
#define ENOTRANS  122           /* Not in transaction. */
#define ENOBEGIN  124           /* Beginning of transaction not found. */
/*
 * picoIsam extended error codes
 */
#define EBADOPENMODE 117        /* incompatible operation with open mode */
#define ENOTSUPP     126        /* function not supported */
#define EDISKFULL    127        /* disk full */
#define ERECCHANGED  128        /* rec changed */
#define ENOLOCKS     129        /* no more locks available */
#define EMISSINGFILE 130        /* missing file */
#define EPERMISSION  131        /* invalid permission */

/*
 * For system call errors
 *   iserrno = errno (system error code 1-99)
 *   iserrio = IO_call + IO_file
 *              IO_call  = what system call
 *              IO_file  = which file caused error
 */

#define IO_OPEN   0x10          /* open()       */
#define IO_CREA   0x20          /* creat()      */
#define IO_SEEK   0x30          /* lseek()      */
#define IO_READ   0x40          /* read()       */
#define IO_WRIT   0x50          /* write()      */
#define IO_LOCK   0x60          /* locking()    */
#define IO_IOCTL  0x70          /* ioctl()      */

extern int iserrno;             /* isam error return code       */
extern int iserrio;             /* system call error code       */
extern UINT4 isrecnum;           /* record number of last call   */
extern char isstat1;            /* cobol status characters      */
extern char isstat2;

extern char *is_errlist[];      /* X/OPEN ISAM error messages        */

struct audhead {
   char au_type[2];            /* audit record type aa,dd,rr,ww*/
   char au_time[4];            /* audit date-time              */
   char au_procid[2];          /* process id number            */
   char au_userid[2];          /* user id number               */
   char au_recnum[4];          /* record number                */
};
#define AUDHEADSIZE  14        /* num of bytes in audit header */

# define ISAM_API 

int ISAM_API isbuild (char * , int , struct keydesc *, int);
int ISAM_API iswrite (int, char *);
int ISAM_API iswrcurr (int, char *);
int ISAM_API isrewrite (int, char *);
int ISAM_API isstart (int, struct keydesc * , int , char *, int);
int ISAM_API isread (int, char * , int);
int ISAM_API isopen (char * , int);
int ISAM_API isclose (int);
int ISAM_API isdelcurr (int);
int ISAM_API isdelete (int, char *);
int ISAM_API isaddindex (int, struct keydesc *);
int ISAM_API isdelindex (int , struct keydesc *);
int ISAM_API isindexinfo (int , void *, int);
int ISAM_API iserase (char *);
int ISAM_API isrename (char *, char *);
int ISAM_API islock (int);
int ISAM_API isunlock (int);
int ISAM_API isrelease (int);
int ISAM_API isaudit (int, char *, int);
int ISAM_API islogopen (char *);
int ISAM_API islogclose ();
int ISAM_API isbegin ();
int ISAM_API iscommit ();
int ISAM_API isrollback ();
int ISAM_API isrecover ();

/*
 * picoIsam extended function for DLL
 */

UINT4 ISAM_API isGetRecnum(void);
void  ISAM_API isSetRecnum(UINT4);
int   ISAM_API isGetErrno(void);

#endif
