/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef wlockmgr_h
# define wlockmgr_h "$Id$"

#define F_RDLCK		0	/* Read lock.   */
#define F_WRLCK		1	/* Write lock.	 */
#define F_UNLCK		2	/* Remove lock. */
#define F_GETLK      5  /* Get record locking info.  */
#define F_SETLK      6  /* Set record locking info (non-blocking).  */
#define F_SETLKW     7  /* Set record locking info (blocking).	*/

struct flock  {
    short int     l_type;   /* Type of lock: F_RDLCK, F_WRLCK, or F_UNLCK.	*/
    short int     l_whence; /* Where `l_start' is relative to (like `lseek').  */
    long          l_start;  /* Offset where the lock begins.  */
    long          l_len;    /* Size of the locked area; zero means until EOF.  */
    long          l_pid;    /* Process holding the lock.  */
};

int win_fcntl_lk (int fd, int cmd, struct flock *fl);

# endif
