/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSqlNet - picoSQL client library

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef dberror_h
# define dberror_h "$Id$"

# include "pstring.h"
# include "plist.h"

# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
# include "sqltype.h"
# endif
# include "sqlhndls.h"

class DBError {
public:
   ClntHenv *henv;
   ClntHdbc *hdbc;
   ClntHstmt *hstmt;
   PString sqlState;
   long nativeError;
   PString errorMsg;
   DBError();
   DBError (ClntHenv * he, ClntHdbc *hd, ClntHstmt *hs,
      const PString &sS, long nE, const PString &eM) :
      henv(he),
      hdbc(hd),
      hstmt(hs),
      sqlState(sS),
      nativeError(nE),
      errorMsg(eM) {
   }
};

PLIST(DBError);

void AddError (ClntHenv *henv, ClntHdbc *hdbc, ClntHstmt *hstmt,
               const PString &sqlState, long nativeError, const PString &errorMsg);
RETCODE GetError (ClntHenv *henv, ClntHdbc *hdbc, ClntHstmt *hstmt,
                  unsigned char *outSqlState, long &outNativeError,
                  unsigned char * outErrorMsg, int cbErrorMsgMax, short &pcbErrorMsg);
void DelError (ClntHenv *henv, ClntHdbc *hdbc, ClntHstmt *hstmt);
# endif
