/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include "blob.h"
static char rcsidh[] = blob_h;
static char rcsid[] = "$Id$";
# include "stmtrel.h"

PCLASSID(BlobFile)
PCLASSID(BlobField)

Error
BlobFile::bopen (int mode)
{
   pbErrno = 0;
   if (pbfd < 0) {
      pbfd = pBopen ((dirName + "/" + fileName).gets(), mode);
      if (pbfd < 0 && errno == ENOENT)
         pbfd = pBbuild ((dirName + "/" + fileName).gets(), 0, 0);
      if (pbfd < 0) {
         pbErrno = errno;
         return SQL_ERROR;
      }
   }
   return SQL_SUCCESS;
}

unsigned long
BlobFile::write (unsigned char *blob, unsigned long size)
{
   unsigned long Return;
   pbErrno = 0;
   if (blob == 0 || size == 0)
      Return = 0;
   else if ((Return = pBwrite (pbfd, (char*) blob, size)) == 0)
      pbErrno = pBerrno(pbfd);
   return Return;
}

unsigned long
BlobFile::read (unsigned long blkNum, unsigned char **blob)
{
   unsigned long Return;
   pbErrno = 0;
   if (blkNum == 0)
      Return = 0;
   else if ((Return = pBread (pbfd, blkNum, (char**) blob)) == 0)
      pbErrno = pBerrno(pbfd);
   return Return;
}

unsigned long
BlobFile::rewrite (unsigned long blkNum, unsigned char *blob,
                                          unsigned long size)
{
   unsigned long Return;
   pbErrno = 0;
   if (blkNum == 0) {
      if (blob == 0 || size == 0)
         Return = 0;
      else if ((Return = pBwrite (pbfd, (char*) blob, size)) == 0)
         pbErrno = pBerrno(pbfd);
   } else if (blob == 0 || size == 0) {
      Return = 0;
      if (pBdelete (pbfd, blkNum) < 0)
         pbErrno = pBerrno(pbfd);
   } else if ((Return = pBrewrite (pbfd, blkNum, (char*) blob,size)) == 0) {
      pbErrno = pBerrno(pbfd);
   }
   return Return;
}

Error
BlobFile::remove (unsigned long blkNum)
{
   Error Return = SQL_SUCCESS;
   pbErrno = 0;
   if (blkNum != 0 && pBdelete (pbfd, blkNum) < 0) {
      pbErrno = pBerrno(pbfd);
      Return = SQL_ERROR;
   }
   return Return;
}

Error
BlobFile::erase()
{
   pbErrno = 0;
   if (pbfd >= 0)
      bclose();
   if (pBerase ((dirName + "/" + fileName).gets())) {
      pbErrno = errno;
      return SQL_ERROR;
   }
   return SQL_SUCCESS;
}

Error
BlobFile::rename(char *newName)
{
   pbErrno = 0;
   if (pbfd >= 0)
      bclose();
   if (pBrename ((dirName + "/" + fileName).gets(), newName)) {
      pbErrno = errno;
      return SQL_ERROR;
   }
   return SQL_SUCCESS;
}
