/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include <stdio.h>
# include <string.h>
# include "envirini.h"
# ifndef WIN32
# include <stdlib.h>
# include <win4unix.h>
# endif
static char rcsid[] = "$Id: envirini.cpp 5.0 1999/10/08 10:17:43 picoSoft Exp $";
static char rcsidh[] = envirini_h;

EnvirIni::EnvirIni()
{
   rc = 0;
   myKey = (HKEY) 0;
   section = strdup("");
}

void
EnvirIni::Open (const char * sec)
{
   if (strcmp (section, sec) != 0) {
      char buffer[256];
      Close();
      sprintf (buffer, "Software\\PicoSoft\\picoSQL\\%s", sec);
      rc = RegOpenKeyEx (HKEY_CURRENT_USER,buffer,0,KEY_ALL_ACCESS,&myKey);
      if (rc != 0)
         rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE,buffer,0,KEY_ALL_ACCESS,&myKey);
      free ((void*) section);
      if (rc == 0)
         section = strdup(sec);
      else
         section = strdup("");
   }
}

void
EnvirIni::Close ()
{
   if (myKey != (HKEY) 0)
      RegCloseKey (myKey);
}


EnvirIni::~EnvirIni ()
{
   Close ();
}

long
EnvirIni::Read(const char *sec, const char *key,
               char *value, const unsigned long lenValue)
{
   unsigned long Return = lenValue;
   DWORD type = REG_SZ;
   Open (sec);
   if (myKey != (HKEY) 0) {
      rc = RegQueryValueEx (myKey, key, NULL, &type, 
                                (unsigned char*) value, &Return);
      if (rc != 0)
         Return = 0;
   }
   return Return;
}

long
EnvirIni::GetLastRetCode()
{
   return rc;
}
