/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
static char rcsid[] = "$Id: options.cpp 5.0 1999/10/08 10:17:43 picoSoft Exp $";
# include "database.h"
# include "sqlpars.h"
# include "trace.h"
# include "sqltype.h"
extern "C" {

RETCODE   SQL_API SQLSetConnectOption(
   HDBC   hdbc,
   UWORD  fOption,
   UDWORD vParam)
{
   RETCODE Return = SQL_SUCCESS;

   if (hdbc == 0 ||
       !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else
      switch (fOption) {
      case SQL_ACCESS_MODE:
         ((DataBase *) hdbc)->SetAccessMode (vParam);
         break;
      case SQL_QUIET_MODE: // ODBC 2.0
         ((DataBase *) hdbc)->SetQuietMode(vParam);
         break;
      case SQL_AUTOCOMMIT:
         ((DataBase *) hdbc)->SetAutoCommit(vParam == SQL_AUTOCOMMIT_ON);
         break;
      case SQL_MAX_ROWS: // to work with ADO
         break;
      case SQL_LOGIN_TIMEOUT:
      case SQL_OPT_TRACE:
      case SQL_OPT_TRACEFILE:
      case SQL_TRANSLATE_DLL:
      case SQL_TRANSLATE_OPTION:
      case SQL_TXN_ISOLATION:
      case SQL_ODBC_CURSORS:  // start ODBC 2.0
      case SQL_PACKET_SIZE:
      case SQL_CURRENT_QUALIFIER:
      default:
         ((DataBase *) hdbc)->PrintError (E_GENERAL_ERROR_C00, "");
         Return = SQL_ERROR;
         break;
      }                
   if (Trace.isSet)
      Trace.Write ("SQLSetConnectOption(0x%lx,%d,%ld)=%d\n",
                      hdbc,
                      fOption,vParam,Return);

   return Return;
}

RETCODE   SQL_API SQLGetConnectOption(
   HDBC   hdbc,
   UWORD  fOption,
   PTR    pvParam)
{
   RETCODE Return = SQL_SUCCESS;

   if (hdbc == 0 ||
       !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else
      switch (fOption) {
      case SQL_ACCESS_MODE:
         *((UDWORD *) pvParam) = 
                    ((DataBase *) hdbc)->GetAccessMode ();
         break;
      case SQL_QUIET_MODE: // ODBC 2.0
         *((UDWORD *) pvParam) =
                    ((DataBase *) hdbc)->GetQuietMode();
         break;
      case SQL_AUTOCOMMIT:
         *((UDWORD *) pvParam) = ((DataBase *) hdbc)->IsAutocommit() ?
                                  SQL_AUTOCOMMIT_ON : SQL_AUTOCOMMIT_OFF;
         break;
      case SQL_TXN_ISOLATION:
         *((UDWORD *) pvParam) = SQL_TXN_READ_UNCOMMITTED;
         break;
      case SQL_LOGIN_TIMEOUT:
      case SQL_OPT_TRACE:
      case SQL_OPT_TRACEFILE:
      case SQL_TRANSLATE_DLL:
      case SQL_TRANSLATE_OPTION:
      case SQL_ODBC_CURSORS:  // start ODBC 2.0
      case SQL_PACKET_SIZE:
      case SQL_CURRENT_QUALIFIER:
      default:
         ((DataBase *) hdbc)->PrintError (E_GENERAL_ERROR_C00,"");
         Return = SQL_ERROR;
         break;
      }                
                 
   if (Trace.isSet)
      Trace.Write ("SQLGetConnectOption(0x%lx,%d,%ld)=%d\n",
                      hdbc,
                      fOption,pvParam,Return);
   return Return;
}                


RETCODE SQL_API SQLSetStmtOption(
    HSTMT   hstmt,
    UWORD   fOption,
    UDWORD  vParam)
{
   RETCODE Return = SQL_SUCCESS;
 
   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else 
      switch (fOption) {
      case SQL_MAX_ROWS:
         ((SqlParser *) hstmt)->SetMaxRows (vParam);
         break;
      case SQL_QUERY_TIMEOUT:
         if (vParam != 0) {
            ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_C00,"");
            Return = SQL_ERROR;
         }
         break;
      case SQL_CONCURRENCY:
         if (vParam != SQL_CONCUR_READ_ONLY ) {
            ((SqlParser *) hstmt)->PrintError (E_WARNING_S02,"");
            Return = SQL_SUCCESS_WITH_INFO;
         }
         break;
      case SQL_CURSOR_TYPE:
         if (vParam != SQL_CURSOR_FORWARD_ONLY) {
            ((SqlParser *) hstmt)->PrintError (E_WARNING_S02,"");
            Return = SQL_SUCCESS_WITH_INFO;
         }
         break;
      case SQL_NOSCAN:
         if (vParam != SQL_NOSCAN_OFF) {
            ((SqlParser *) hstmt)->PrintError (E_WARNING_S02,"");
            Return = SQL_SUCCESS_WITH_INFO;
         }
         break;
      case SQL_ROWSET_SIZE:
         ((SqlParser *) hstmt)->setRowSetSize (vParam);
         break;
      case SQL_MAX_LENGTH:
         if (vParam != 0) {
            ((SqlParser *) hstmt)->PrintError (E_WARNING_S02,"");
            Return = SQL_SUCCESS_WITH_INFO;
         }
         break;
      case SQL_ASYNC_ENABLE:
      case SQL_BIND_TYPE:
      case SQL_KEYSET_SIZE: // start ODBC 2.0
      case SQL_SIMULATE_CURSOR:
      default:
         ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_C00,"");
         Return = SQL_ERROR;
         break;
      }  
   if (Trace.isSet)
      Trace.Write ("SQLSetStmtOption(0x%lx,%d,%ld)=%d\n",
                      hstmt,
                      fOption, vParam, Return);
    return Return;
}

RETCODE SQL_API SQLGetStmtOption(
    HSTMT   hstmt,
    UWORD   fOption,
    PTR pvParam)
{
   RETCODE Return = SQL_SUCCESS;
 
   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else 
      switch (fOption) {
      case SQL_MAX_ROWS:
         *((UDWORD *) pvParam) =         
             ((SqlParser *) hstmt)->GetMaxRows ();
         break;
      case SQL_QUERY_TIMEOUT:
         *((UDWORD *) pvParam) = 0;
         break;
      case SQL_ROWSET_SIZE:
         *((UDWORD *) pvParam) =((SqlParser *) hstmt)->getRowSetSize ();
         break;
      case SQL_MAX_LENGTH:
         *((UDWORD *) pvParam) = 0;
         break;
      case SQL_CONCURRENCY:
         *((UDWORD *) pvParam) = SQL_CONCUR_READ_ONLY;
         break;
      case SQL_CURSOR_TYPE:
         *((UDWORD *) pvParam) = SQL_CURSOR_FORWARD_ONLY;
         break;
      case SQL_NOSCAN:
         *((UDWORD *) pvParam) = SQL_NOSCAN_OFF;
         break;
      case SQL_ASYNC_ENABLE:
      case SQL_BIND_TYPE:
      case SQL_KEYSET_SIZE:  // start ODBC 2.0
      case SQL_SIMULATE_CURSOR:
      case SQL_GET_BOOKMARK:
      default:
         ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_C00,"");
         Return = SQL_ERROR;
         break;
      case SQL_ROW_NUMBER:
         *((UDWORD *) pvParam) = 
                 ((SqlParser *) hstmt)->GetFetched();
         break;
      }     
   if (Trace.isSet)
      Trace.Write ("SQLGetStmtOption(0x%lx,%d,%ld)=%d\n",
                      hstmt,
                      fOption, pvParam, Return);
    return Return;
}

};
