/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef relobjec_h
# define relobjec_h "$Id: relobjec.h 5.0 1999/10/08 10:17:43 picoSoft Exp $"

# include "dberror.h"
# include "piteratr.h"

typedef unsigned char RelPerm;
static const RelPerm REL_READ = 0;
static const RelPerm REL_INSERT = 1;
static const RelPerm REL_DELETE = 2;
static const RelPerm REL_UPDATE = 4;

class RelObject : public PObject
{
   PCLASS(RelObject, PObject)
protected:
   PString       Name; 
   DataBase     *parent;
   PString       relCondWhere;
   RelPerm       Permission;
   PBool         checkOption;
public:
   RelObject (const char *n, DataBase &p);
   RelObject (const RelObject &p);
   virtual ~RelObject();
   DataBase * getParent() const { return parent; }
   PString & getName () { return Name; }
   PBool isName (const PString &s) { return  s == Name; }
   void setName (const char *s) { Name = s; }
   void PrintError (ErrNum e, const PString &submess, int syserr = 0) {
      ::PrintError (0, parent, 0, e, submess, syserr);
   }
   virtual PBool Exists() = 0; 
   void setRelCondWhere(const PString &w) { relCondWhere = w; }
   void setRelCondWhere(const char *w) { relCondWhere = w; }
   const PString &getRelCondWhere() { return relCondWhere; }
   void setReadOnly(PBool ro) {if (ro)
                                 Permission &= ~(REL_INSERT|REL_UPDATE|REL_DELETE);
                              else
                                 Permission |= (REL_INSERT|REL_UPDATE|REL_DELETE);
                             }
   PBool IsReadOnly () {
      return Permission == 0;
   }
   void setCheckOption (PBool ckopt) {
      checkOption = ckopt;
   }
   PBool getCheckOption () {
      return checkOption;
   }
   void revokePermissions(RelPerm p) {
      Permission &= ~p;
   }
   PBool hasOnePermission(RelPerm p) {
      return (Permission & p) != 0;
   }
};

PLIST(RelObject);
PITERATOR(RelObject);

# endif
