/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcConnection;
import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.PicoDatabaseMetaData;
import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoDriver;
import IT.picosoft.jdbc.PicoPreparedStatement;
import IT.picosoft.jdbc.PicoStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PicoConnection
implements Connection {
    protected PicoDbApi odbcApi = new PicoDbApi();
    protected PicoDriver myDriver;
    protected int hEnv;
    protected OdbcConnection hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String url;
    protected int odbcVer;
    protected String catalog;
    protected Hashtable statements;

    public PicoConnection(int n, PicoDriver picoDriver) {
        this.myDriver = picoDriver;
        this.hEnv = n;
        this.hDbc = null;
        this.url = null;
        this.lastWarning = null;
        this.closed = true;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.close");
        }
        if (!this.closed) {
            this.closeAllStatements();
            this.myDriver.closeConnection(this.hDbc);
            this.hDbc = null;
            this.odbcApi.finalize();
            this.odbcApi = null;
            this.closed = true;
        }
        this.url = null;
    }

    public synchronized void closeAllStatements() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println(this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Enumeration enumeration = this.statements.keys();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statement.close();
        }
    }

    public void commit() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.commit");
        }
        this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    public Statement createStatement() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.createStatement");
        }
        PicoStatement picoStatement = new PicoStatement(this, this.odbcApi);
        this.registerStatement(picoStatement);
        return picoStatement;
    }

    public Statement createStatement(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public void deregisterStatement(Statement statement) {
        if (this.statements.get(statement) != null) {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("deregistering Statement " + statement);
            }
            this.statements.remove(statement);
        }
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Connection.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean getAutoCommit() throws SQLException {
        boolean bl = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getAutoCommit");
        }
        this.validateConnection();
        int n = this.odbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public OdbcConnection getHDBC() {
        return this.hDbc;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getMetaData");
        }
        this.validateConnection();
        PicoDatabaseMetaData picoDatabaseMetaData = new PicoDatabaseMetaData(this.odbcApi, this);
        return picoDatabaseMetaData;
    }

    public int getTransactionIsolation() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getTransactionIsolation");
        }
        this.validateConnection();
        return this.odbcApi.SQLGetConnectOption(this.hDbc, (short)108);
    }

    public Map getTypeMap() {
        throw new UnsupportedOperationException();
    }

    public String getURL() {
        return this.url;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    public void initialize(String string, Properties properties, int n) throws SQLException {
        DatabaseMetaData databaseMetaData;
        String string2 = properties.getProperty("user", "");
        String string3 = properties.getProperty("password", "");
        this.odbcApi.charSet = properties.getProperty("charSet", System.getProperty("file.encoding"));
        try {
            this.hDbc = new OdbcConnection(this.odbcApi, string, string2, string3);
        }
        catch (SQLException sQLException) {
            try {
                this.odbcApi.SQLFreeConnect(this.hDbc);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.hDbc = null;
            throw sQLException;
        }
        this.closed = false;
        this.statements = new Hashtable();
        if (DriverManager.getLogWriter() != null && (databaseMetaData = this.getMetaData()) != null) {
            DriverManager.println("Driver name:   " + databaseMetaData.getDriverName());
            DriverManager.println("Driver version: " + databaseMetaData.getDriverVersion());
        }
        this.catalog = string;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.isReadOnly");
        }
        boolean bl = false;
        this.validateConnection();
        int n = this.odbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public String nativeSQL(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.nativeSQL (" + string + ")");
        }
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.prepareCall (" + string + ")");
        }
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.prepareStatement (" + string + ")");
        }
        SQLWarning sQLWarning = null;
        PicoPreparedStatement picoPreparedStatement = new PicoPreparedStatement(this, this.odbcApi);
        OdbcStatement odbcStatement = picoPreparedStatement.getHSTMT();
        try {
            this.odbcApi.SQLPrepare(odbcStatement, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            picoPreparedStatement.close();
            throw sQLException;
        }
        picoPreparedStatement.setWarning(sQLWarning);
        this.registerStatement(picoPreparedStatement);
        return picoPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    protected void registerStatement(Statement statement) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Registering Statement " + statement);
        }
        this.statements.put(statement, "");
    }

    public void rollback() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.rollback");
        }
        this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setAutoCommit (" + bl + ")");
        }
        int n = 1;
        this.validateConnection();
        if (!bl) {
            n = 0;
        }
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)102, n);
    }

    public void setCatalog(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setCatalog (" + string + ")");
        }
        this.validateConnection();
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)109, string);
    }

    protected void setLoginTimeout(int n) throws SQLException {
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)103, n);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        block4: {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("*Connection.setReadOnly (" + bl + ")");
            }
            int n = 0;
            this.validateConnection();
            if (bl) {
                n = 1;
            }
            try {
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)101, n);
            }
            catch (SQLException sQLException) {
                if (DriverManager.getLogWriter() == null) break block4;
                DriverManager.println("setReadOnly exception ignored");
            }
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setTransactionIsolation (" + n + ")");
        }
        this.validateConnection();
        switch (n) {
            case 0: {
                this.setAutoCommit(true);
                break;
            }
            case 1: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                break;
            }
            case 2: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                break;
            }
            case 4: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                break;
            }
            case 8: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                break;
            }
            default: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, n);
            }
        }
    }

    public void setTypeMap(Map map) {
        throw new UnsupportedOperationException();
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void validateConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String string) {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

