/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.PicoConnection;
import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoPseudoCol;
import IT.picosoft.jdbc.PicoResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class PicoDatabaseMetaData
implements DatabaseMetaData {
    protected PicoDbApi odbcApi;
    protected PicoConnection con;

    public PicoDatabaseMetaData(PicoDbApi picoDbApi, PicoConnection picoConnection) {
        this.odbcApi = picoDbApi;
        this.con = picoConnection;
    }

    protected String getInfoString(short s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("getInfoString opt=" + s);
        }
        this.validateConnection();
        switch (s) {
            case 19: {
                return "Y";
            }
            case 20: {
                return "N";
            }
            case 46: {
                return String.valueOf(4);
            }
            case 103: {
                return "Y";
            }
            case 41: {
                return "";
            }
            case 42: {
                return "";
            }
            case 17: {
                return "picoSQL";
            }
            case 18: {
                return "4.00.0000";
            }
            case 7: {
                return "4.00.0000";
            }
            case 26: {
                return String.valueOf(1);
            }
            case 94: {
                return "";
            }
            case 29: {
                return " ";
            }
            case 112: {
                return "0";
            }
            case 34: {
                return "0";
            }
            case 108: {
                return "32767";
            }
            case 30: {
                return "30";
            }
            case 97: {
                return "0";
            }
            case 98: {
                return "0";
            }
            case 99: {
                return "0";
            }
            case 100: {
                return "0";
            }
            case 101: {
                return "0";
            }
            case 0: {
                return "0";
            }
            case 31: {
                return "0";
            }
            case 102: {
                return "250";
            }
            case 33: {
                return "0";
            }
            case 104: {
                return "32767";
            }
            case 32: {
                return "0";
            }
            case 105: {
                return "0";
            }
            case 1: {
                return "0";
            }
            case 35: {
                return "30";
            }
            case 106: {
                return "0";
            }
            case 107: {
                return "30";
            }
            case 49: {
                return String.valueOf(0x400001);
            }
            case 40: {
                return "";
            }
            case 89: {
                return "";
            }
            case 39: {
                return "";
            }
            case 14: {
                return "\\";
            }
            case 50: {
                return String.valueOf(7257);
            }
            case 51: {
                return "0";
            }
            case 52: {
                return "0";
            }
            case 47: {
                return "";
            }
            case 114: {
                return "0";
            }
            case 25: {
                return "N";
            }
            case 22: {
                return String.valueOf(1);
            }
            case 85: {
                return String.valueOf(2);
            }
            case 28: {
                return String.valueOf(1);
            }
            case 93: {
                return String.valueOf(1);
            }
            case 86: {
                return "0";
            }
            case 92: {
                return "0";
            }
            case 87: {
                return "Y";
            }
            case 48: {
                return String.valueOf(1);
            }
            case 15: {
                return String.valueOf(1);
            }
            case 95: {
                return String.valueOf(2);
            }
            case 27: {
                return "N";
            }
            case 38: {
                return "Y";
            }
            case 88: {
                return String.valueOf(2);
            }
            case 73: {
                return "N";
            }
            case 113: {
                return "N";
            }
            case 36: {
                return "N";
            }
            case 37: {
                return "N";
            }
            case 75: {
                return "0";
            }
            case 23: 
            case 24: {
                return String.valueOf(2);
            }
            case 80: {
                return "0";
            }
            case 91: {
                return "0";
            }
            case 21: {
                return "N";
            }
            case 74: {
                return String.valueOf(2);
            }
            case 96: {
                return "0";
            }
            case 84: {
                return String.valueOf(0);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int getInfo(short s) throws SQLException {
        return Integer.parseInt(this.getInfoString(s));
    }

    protected short getInfoShort(short s) throws SQLException {
        return Short.parseShort(this.getInfoString(s));
    }

    protected void validateConnection() throws SQLException {
        this.con.validateConnection();
    }

    protected boolean getInfoBooleanString(short s) throws SQLException {
        this.validateConnection();
        String string = "N";
        return string.equalsIgnoreCase("Y");
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.allProceduresAreCallable");
        }
        return this.getInfoBooleanString((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.allTablesAreSelectable");
        }
        return this.getInfoBooleanString((short)19);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        }
        return ((s = this.getInfoShort((short)46)) & 3) > 0;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        }
        return ((s = this.getInfoShort((short)46)) & 4) > 0;
    }

    public boolean deletesAreDetected(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        }
        return this.getInfoBooleanString((short)103);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getBestRowIdentifier (" + string + "," + string2 + "," + string3 + "," + n + "," + bl + ")");
        }
        PicoResultSet picoResultSet = null;
        SQLWarning sQLWarning = null;
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLSpecialColumns(odbcStatement, (short)1, string, string2, string3, n, bl);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        picoResultSet.setSQLTypeColumn(3);
        return picoResultSet;
    }

    public String getCatalogSeparator() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogSeparator");
        }
        return this.getInfoString((short)41);
    }

    public String getCatalogTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogTerm");
        }
        return this.getInfoString((short)42);
    }

    public ResultSet getCatalogs() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogs");
        }
        PicoResultSet picoResultSet = (PicoResultSet)this.getTables("%", "", "", null);
        int[] nArray = new int[]{1};
        picoResultSet.setColumnMappings(nArray);
        return picoResultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        PicoResultSet picoResultSet = null;
        SQLWarning sQLWarning = null;
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLColumns(odbcStatement, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        PicoPseudoCol[] picoPseudoColArray = new PicoPseudoCol[]{new PicoPseudoCol("COLUMN_DEF", 12, 254), new PicoPseudoCol("SQL_DATA_TYPE", 4, 0), new PicoPseudoCol("SQL_DATETIME_SUB", 4, 0), new PicoPseudoCol("CHAR_OCTET_LENGTH", 4, 0), new PicoPseudoCol("ORDINAL_POSITION", 4, 0), new PicoPseudoCol("IS_NULLABLE", 12, 254), new PicoPseudoCol("SCOPE_CATLOG", 12, 254), new PicoPseudoCol("SCOPE_SCHEMA", 12, 254), new PicoPseudoCol("SCOPE_TABLE", 12, 254), new PicoPseudoCol("SOURCE_DATA_TYPE", 5, 0)};
        picoResultSet.setPseudoCols(13, 22, picoPseudoColArray);
        picoResultSet.setSQLTypeColumn(5);
        return picoResultSet;
    }

    public Connection getConnection() {
        return this.con;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCrossReference (" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        }
        throw new UnsupportedOperationException();
    }

    public String getDatabaseProductName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDatabaseProductName");
        }
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDatabaseProductVersion");
        }
        return this.getInfoString((short)18);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDefaultTransactionIsolation");
        }
        return (byte)this.getInfo((short)26);
    }

    public int getDriverMajorVersion() {
        return 4;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public String getDriverName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverName");
        }
        return "picoSQL JDBC driver";
    }

    public String getDriverVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverVersion");
        }
        int n = this.getDriverMinorVersion();
        String string = "";
        if (n < 1000) {
            string = string + "0";
        }
        if (n < 100) {
            string = string + "0";
        }
        if (n < 10) {
            string = string + "0";
        }
        string = string + "" + n;
        return this.getDriverMajorVersion() + "." + string + " (" + this.getInfoString((short)7) + ")";
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getExtraNameCharacters() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getExtraNameCharacters");
        }
        return this.getInfoString((short)94);
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getIdentifierQuoteString");
        }
        return this.getInfoString((short)29);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getIndexInfo (" + string + "," + string2 + "," + string3 + bl + "," + bl2 + ")");
        }
        PicoResultSet picoResultSet = null;
        SQLWarning sQLWarning = null;
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLStatistics(odbcStatement, string, string2, string3, bl, bl2);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        return picoResultSet;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxBinaryLiteralLength");
        }
        return this.getInfo((short)112);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCatalogNameLength");
        }
        return this.getInfoShort((short)34);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCharLiteralLength");
        }
        return this.getInfo((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnNameLength");
        }
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInGroupBy");
        }
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInIndex");
        }
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInOrderBy");
        }
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInSeleted");
        }
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInTable");
        }
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxConnections");
        }
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCursorNameLength");
        }
        return this.getInfo((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxIndexLength");
        }
        return this.getInfo((short)102);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxProcedureNameLength");
        }
        return this.getInfoShort((short)33);
    }

    public int getMaxRowSize() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxRowSize");
        }
        return this.getInfo((short)104);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxSchemaNameLength");
        }
        return this.getInfoShort((short)32);
    }

    public int getMaxStatementLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxStatementLength");
        }
        return this.getInfo((short)105);
    }

    public int getMaxStatements() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxStatements");
        }
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxTableNameLength");
        }
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxTablesInSelect");
        }
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxUserNameLength");
        }
        return this.getInfoShort((short)107);
    }

    public String getNumericFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getNumericFunctions");
        }
        String string = "";
        int n = this.getInfo((short)49);
        if ((n & 1) != 0) {
            string = string + "ABS,";
        }
        if ((n & 2) != 0) {
            string = string + "ACOS,";
        }
        if ((n & 4) != 0) {
            string = string + "ASIN,";
        }
        if ((n & 8) != 0) {
            string = string + "ATAN,";
        }
        if ((n & 0x10) != 0) {
            string = string + "ATAN2,";
        }
        if ((n & 0x20) != 0) {
            string = string + "CEILING,";
        }
        if ((n & 0x40) != 0) {
            string = string + "COS,";
        }
        if ((n & 0x80) != 0) {
            string = string + "COT,";
        }
        if ((n & 0x40000) != 0) {
            string = string + "DEGREES,";
        }
        if ((n & 0x100) != 0) {
            string = string + "EXP,";
        }
        if ((n & 0x200) != 0) {
            string = string + "FLOOR,";
        }
        if ((n & 0x400) != 0) {
            string = string + "LOG,";
        }
        if ((n & 0x80000) != 0) {
            string = string + "LOG10,";
        }
        if ((n & 0x800) != 0) {
            string = string + "MOD,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "PI,";
        }
        if ((n & 0x100000) != 0) {
            string = string + "POWER,";
        }
        if ((n & 0x200000) != 0) {
            string = string + "RADIANS,";
        }
        if ((n & 0x20000) != 0) {
            string = string + "RAND,";
        }
        if ((n & 0x400000) != 0) {
            string = string + "ROUND,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "SIGN,";
        }
        if ((n & 0x2000) != 0) {
            string = string + "SIN,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "SQRT,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "TAN,";
        }
        if ((n & 0x800000) != 0) {
            string = string + "TRUNCATE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getProcedureTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getProcedureTerm");
        }
        return this.getInfoString((short)40);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSQLKeywords() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSQLKeywords");
        }
        return this.getInfoString((short)89);
    }

    public String getSchemaTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSchemaTerm");
        }
        return this.getInfoString((short)39);
    }

    public ResultSet getSchemas() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSchemas");
        }
        PicoResultSet picoResultSet = (PicoResultSet)this.getTables("", "%", "", null);
        int[] nArray = new int[]{2};
        picoResultSet.setColumnMappings(nArray);
        return picoResultSet;
    }

    public String getSearchStringEscape() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSearchStringEscape");
        }
        return this.getInfoString((short)14);
    }

    public String getStringFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getStringFunctions");
        }
        String string = "";
        int n = this.getInfo((short)50);
        if ((n & 0x2000) != 0) {
            string = string + "ASCII,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "CHAR,";
        }
        if ((n & 1) != 0) {
            string = string + "CONCAT,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "DIFFERENCE,";
        }
        if ((n & 2) != 0) {
            string = string + "INSERT,";
        }
        if ((n & 0x40) != 0) {
            string = string + "LCASE,";
        }
        if ((n & 4) != 0) {
            string = string + "LEFT,";
        }
        if ((n & 0x10) != 0) {
            string = string + "LENGTH,";
        }
        if ((n & 0x20) != 0) {
            string = string + "LOCATE,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "LOCATE_2,";
        }
        if ((n & 8) != 0) {
            string = string + "LTRIM,";
        }
        if ((n & 0x80) != 0) {
            string = string + "REPEAT,";
        }
        if ((n & 0x100) != 0) {
            string = string + "REPLACE,";
        }
        if ((n & 0x200) != 0) {
            string = string + "RIGHT,";
        }
        if ((n & 0x400) != 0) {
            string = string + "RTRIM,";
        }
        if ((n & 0x20000) != 0) {
            string = string + "SOUNDEX,";
        }
        if ((n & 0x40000) != 0) {
            string = string + "SPACE,";
        }
        if ((n & 0x800) != 0) {
            string = string + "SUBSTRING,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "UCASE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSystemFunctions");
        }
        String string = "";
        int n = this.getInfo((short)51);
        if ((n & 2) != 0) {
            string = string + "DBNAME,";
        }
        if ((n & 4) != 0) {
            string = string + "IFNULL,";
        }
        if ((n & 1) != 0) {
            string = string + "USERNAME,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getTableTypes() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTableTypes");
        }
        String[] stringArray = new String[]{"%"};
        PicoResultSet picoResultSet = (PicoResultSet)this.getTables("", "", "", stringArray);
        int[] nArray = new int[]{4};
        picoResultSet.setColumnMappings(nArray);
        return picoResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        PicoResultSet picoResultSet = null;
        String string4 = null;
        SQLWarning sQLWarning = null;
        if (stringArray != null) {
            string4 = "";
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                String string5 = stringArray[n];
                if (n > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + string5;
                n = (short)(n + 1);
            }
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTables (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLTables(odbcStatement, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        return picoResultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTimeDateFunctions");
        }
        String string = "";
        int n = this.getInfo((short)52);
        if ((n & 2) != 0) {
            string = string + "CURDATE,";
        }
        if ((n & 0x200) != 0) {
            string = string + "CURTIME,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "DAYNAME,";
        }
        if ((n & 4) != 0) {
            string = string + "DAYOFMONTH,";
        }
        if ((n & 8) != 0) {
            string = string + "DAYOFWEEK,";
        }
        if ((n & 0x10) != 0) {
            string = string + "DAYOFYEAR,";
        }
        if ((n & 0x400) != 0) {
            string = string + "HOUR,";
        }
        if ((n & 0x800) != 0) {
            string = string + "MINUTE,";
        }
        if ((n & 0x20) != 0) {
            string = string + "MONTH,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "MONTHNAME,";
        }
        if ((n & 1) != 0) {
            string = string + "NOW,";
        }
        if ((n & 0x40) != 0) {
            string = string + "QUARTER,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "SECOND,";
        }
        if ((n & 0x2000) != 0) {
            string = string + "TIMESTAMPADD,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "TIMESTAMPDIFF,";
        }
        if ((n & 0x80) != 0) {
            string = string + "WEEK,";
        }
        if ((n & 0x100) != 0) {
            string = string + "YEAR,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTypeInfo");
        }
        PicoResultSet picoResultSet = null;
        SQLWarning sQLWarning = null;
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLGetTypeInfo(odbcStatement, (short)0);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        PicoPseudoCol[] picoPseudoColArray = new PicoPseudoCol[5];
        picoPseudoColArray[0] = new PicoPseudoCol("OdbcDef.SQL_DATA_TYPE", 5, 0);
        picoPseudoColArray[1] = new PicoPseudoCol("OdbcDef.SQL_DATETIME_SUB", 5, 0);
        picoPseudoColArray[2] = new PicoPseudoCol("NUM_PREC_RADIX", 5, 0);
        picoResultSet.setPseudoCols(16, 18, picoPseudoColArray);
        picoResultSet.setSQLTypeColumn(2);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("getTypeInfo rs=" + picoResultSet);
        }
        return picoResultSet;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    public String getURL() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getURL");
        }
        return this.con.getURL();
    }

    public String getUserName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getUserName");
        }
        return this.getInfoString((short)47);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getVersionColumns (" + string + "," + string2 + "," + string3 + ")");
        }
        PicoResultSet picoResultSet = null;
        SQLWarning sQLWarning = null;
        OdbcStatement odbcStatement = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLSpecialColumns(odbcStatement, (short)2, string, string2, string3, 0, false);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            odbcStatement.drop();
            throw sQLException;
        }
        picoResultSet = new PicoResultSet(this.odbcApi, odbcStatement, this.con);
        picoResultSet.setWarning(sQLWarning);
        picoResultSet.setSQLTypeColumn(3);
        return picoResultSet;
    }

    public boolean insertsAreDetected(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean isCatalogAtStart() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.isCatalogAtStart");
        }
        return (s = this.getInfoShort((short)114)) == 1;
    }

    public boolean isReadOnly() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.isReadOnly");
        }
        return this.getInfoBooleanString((short)25);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullPlusNullIsNull");
        }
        return (s = this.getInfoShort((short)22)) == 0;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedAtEnd");
        }
        return (n = this.getInfo((short)85)) == 4;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedAtStart");
        }
        return (n = this.getInfo((short)85)) == 2;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedHigh");
        }
        return (s = this.getInfoShort((short)85)) == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedLow");
        }
        return (n = this.getInfo((short)85)) == 1;
    }

    public boolean othersDeletesAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean othersInsertsAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean othersUpdatesAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean ownDeletesAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean ownInsertsAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean ownUpdatesAreVisible(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesLowerCaseIdentifiers");
        }
        return (s = this.getInfoShort((short)28)) == 2;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        }
        return (s = this.getInfoShort((short)93)) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesMixedCaseIdentifiers");
        }
        return (s = this.getInfoShort((short)28)) == 4;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        }
        return (s = this.getInfoShort((short)93)) == 4;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesUpperCaseIdentifiers");
        }
        return (s = this.getInfoShort((short)28)) == 1;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        }
        return (s = this.getInfoShort((short)93)) == 1;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        }
        return ((n = this.getInfo((short)86)) & 1) > 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        }
        return ((n = this.getInfo((short)86)) & 2) > 0;
    }

    public boolean supportsBatchUpdates() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        }
        return ((n = this.getInfo((short)92)) & 1) > 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        }
        return ((n = this.getInfo((short)92)) & 8) > 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        }
        return ((n = this.getInfo((short)92)) & 0x10) > 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        }
        return ((n = this.getInfo((short)92)) & 2) > 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        }
        return ((n = this.getInfo((short)92)) & 4) > 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsColumnAliasing");
        }
        return this.getInfoBooleanString((short)87);
    }

    public boolean supportsConvert() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsConvert");
        }
        return (n = this.getInfo((short)48)) == 1;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsConvert (" + n + "," + n2 + ")");
        }
        short s = 0;
        boolean bl = false;
        int n3 = 0;
        switch (n) {
            case -7: {
                s = 55;
                break;
            }
            case -6: {
                s = 68;
                break;
            }
            case 5: {
                s = 65;
                break;
            }
            case 4: {
                s = 61;
                break;
            }
            case -5: {
                s = 53;
                break;
            }
            case 6: {
                s = 60;
                break;
            }
            case 7: {
                s = 64;
                break;
            }
            case 8: {
                s = 59;
                break;
            }
            case 2: {
                s = 63;
                break;
            }
            case 3: {
                s = 58;
                break;
            }
            case 1: {
                s = 56;
                break;
            }
            case 12: {
                s = 70;
                break;
            }
            case -1: {
                s = 62;
                break;
            }
            case 91: {
                s = 57;
                break;
            }
            case 92: {
                s = 66;
                break;
            }
            case 93: {
                s = 67;
                break;
            }
            case -2: {
                s = 54;
                break;
            }
            case -3: {
                s = 69;
                break;
            }
            case -4: {
                s = 71;
            }
        }
        int n4 = this.getInfo(s);
        switch (n2) {
            case -7: {
                n3 = 4096;
                break;
            }
            case -6: {
                n3 = 8192;
                break;
            }
            case 5: {
                n3 = 16;
                break;
            }
            case 4: {
                n3 = 8;
                break;
            }
            case -5: {
                n3 = 16384;
                break;
            }
            case 6: {
                n3 = 32;
                break;
            }
            case 7: {
                n3 = 64;
                break;
            }
            case 8: {
                n3 = 128;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 12: {
                n3 = 256;
                break;
            }
            case -1: {
                n3 = 512;
                break;
            }
            case 91: {
                n3 = 32768;
                break;
            }
            case 92: {
                n3 = 65536;
                break;
            }
            case 93: {
                n3 = 131072;
                break;
            }
            case -2: {
                n3 = 1024;
                break;
            }
            case -3: {
                n3 = 2048;
                break;
            }
            case -4: {
                n3 = 262144;
            }
        }
        return (n4 & n3) > 0;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCoreSQLGrammar");
        }
        return (s = this.getInfoShort((short)15)) == 1 || s == 2;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCorrelatedSubqueries");
        }
        return ((n = this.getInfo((short)95)) & 0x10) > 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        }
        return ((s = this.getInfoShort((short)46)) & 2) > 0;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        }
        return ((s = this.getInfoShort((short)46)) & 1) > 0;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        }
        return (s = this.getInfoShort((short)74)) == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsExpressionsInOrderBy");
        }
        return this.getInfoBooleanString((short)27);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsExtendedSQLGrammar");
        }
        return (s = this.getInfoShort((short)15)) == 2;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsFullOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("F");
    }

    public boolean supportsGroupBy() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupBy");
        }
        return (s = this.getInfoShort((short)88)) != 0;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupByBeyondSelect");
        }
        return (s = this.getInfoShort((short)88)) == 2;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupByUnrelated");
        }
        return (s = this.getInfoShort((short)88)) == 3;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        }
        return this.getInfoBooleanString((short)73);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsLikeEscapeClause");
        }
        return this.getInfoBooleanString((short)113);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsLimitedOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("P");
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMinimumSQLGrammar");
        }
        return (s = this.getInfoShort((short)15)) == 0 || s == 1 || s == 2;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        }
        return (s = this.getInfoShort((short)28)) == 4 || s == 1 || s == 2;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        }
        return (s = this.getInfoShort((short)93)) == 4 || s == 1 || s == 2;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMultipleResultSets");
        }
        return this.getInfoBooleanString((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMultipleTransactions");
        }
        return this.getInfoBooleanString((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsNonNullableColumns");
        }
        return (s = this.getInfoShort((short)75)) == 1;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        }
        return (s = this.getInfoShort((short)23)) == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        }
        return (s = this.getInfoShort((short)24)) == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        }
        return (s = this.getInfoShort((short)23)) == 2 || s == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        }
        return (s = this.getInfoShort((short)24)) == 2 || s == 1;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOrderByUnrelated");
        }
        return this.getInfoBooleanString((short)90);
    }

    public boolean supportsOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("N") ^ true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsPositionedDelete");
        }
        return ((n = this.getInfo((short)80)) & 1) > 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsPositionedUpdate");
        }
        return ((n = this.getInfo((short)80)) & 2) > 0;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetType(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInDataManipulation");
        }
        return ((n = this.getInfo((short)91)) & 1) > 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        }
        return ((n = this.getInfo((short)91)) & 8) > 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        }
        return ((n = this.getInfo((short)91)) & 0x10) > 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        }
        return ((n = this.getInfo((short)91)) & 2) > 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        }
        return ((n = this.getInfo((short)91)) & 4) > 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSelectForUpdate");
        }
        return ((n = this.getInfo((short)80)) & 4) > 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsStoredProcedures");
        }
        return this.getInfoBooleanString((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInComparisions");
        }
        return ((n = this.getInfo((short)95)) & 1) > 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInExists");
        }
        return ((n = this.getInfo((short)95)) & 2) > 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInIns");
        }
        return ((n = this.getInfo((short)95)) & 4) > 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        }
        return ((n = this.getInfo((short)95)) & 8) > 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTableCorrelationNames");
        }
        return (s = this.getInfoShort((short)74)) == 1 || s == 2;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTransactionIsolationLevel (" + n + ")");
        }
        if (n == 0) {
            return !this.supportsTransactions();
        }
        int n2 = this.getInfo((short)72);
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = (n2 & 1) > 0;
                break;
            }
            case 2: {
                bl = (n2 & 2) > 0;
                break;
            }
            case 4: {
                bl = (n2 & 4) > 0;
                break;
            }
            case 8: {
                bl = (n2 & 8) > 0;
            }
        }
        return bl;
    }

    public boolean supportsTransactions() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTransactions");
        }
        return (s = this.getInfoShort((short)46)) != 0;
    }

    public boolean supportsUnion() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsUnion");
        }
        return ((n = this.getInfo((short)96)) & 1) > 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        int n;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsUnionAll");
        }
        return ((n = this.getInfo((short)96)) & 2) > 0;
    }

    public boolean supportsSavepoints() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSavepoints");
        }
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return 5;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 4;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean updatesAreDetected(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.usesLocalFilePerTable");
        }
        return (s = this.getInfoShort((short)84)) == 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        short s;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.usesLocalFiles");
        }
        return (s = this.getInfoShort((short)84)) == 2;
    }
}

