/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.PicoBoundParam;
import IT.picosoft.jdbc.PicoConnection;
import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class PicoPreparedStatement
extends PicoStatement
implements PreparedStatement {
    Vector boundParams = new Vector();

    public PicoPreparedStatement(PicoConnection picoConnection, PicoDbApi picoDbApi) throws SQLException {
        super(picoConnection, picoDbApi);
    }

    public void addBatch() {
        throw new UnsupportedOperationException();
    }

    public void clearParameters() throws SQLException {
        this.boundParams.removeAllElements();
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.close hStmt =" + this.hStmt);
        }
        if (!this.myConnection.isClosed()) {
            this.clearMyResultSet();
            try {
                this.clearWarnings();
                if (!this.hStmt.isDropped()) {
                    this.hStmt.drop();
                    this.clearParameters();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute() throws SQLException {
        boolean bl = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.execute");
        }
        this.clearWarnings();
        this.reset();
        try {
            this.odbcApi.SQLExecuteParams(this.hStmt, this.boundParams);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        int n = -1;
        n = this.getColumnCount();
        if (n > 0) {
            bl = true;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.execute nCol=" + n);
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeQuery");
        }
        ResultSet resultSet = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeQuery (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeUpdate");
        }
        int n = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    public int executeUpdate(String string) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeUpdate (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public ResultSetMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public static int getTypeFromObject(Object object) {
        int n = object == null ? 0 : (object instanceof String ? 12 : (object instanceof BigDecimal ? 2 : (object instanceof Boolean ? -7 : (object instanceof Byte ? -6 : (object instanceof Integer ? 4 : (object instanceof Long ? -5 : (object instanceof Float ? 7 : (object instanceof Double ? 8 : (object instanceof byte[] ? -4 : (object instanceof Date ? 91 : (object instanceof Time ? 92 : (object instanceof Timestamp ? 93 : 9999))))))))))));
        return n;
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, PicoPreparedStatement.getTypeFromObject(object));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, Calendar calendar) throws SQLException {
        this.setObject(n, object, n2, 0, calendar);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2, n3, null);
    }

    public void setObject(int n, Object object, int n2, int n3, Calendar calendar) throws SQLException {
        switch (n2) {
            case 0: {
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            default: {
                throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2 + ")");
            }
        }
        if (n + 1 > this.boundParams.size()) {
            this.boundParams.setSize(n + 1);
        }
        this.boundParams.set(n, new PicoBoundParam(1, (short)n2, n3, object, calendar));
    }

    public void setArray(int n, Array array) {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, (Object)bigDecimal, 2, bigDecimal.scale());
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n, Blob blob) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = new Boolean(bl);
        this.setObject(n, (Object)bl2, -7, 0);
    }

    public void setByte(int n, byte by) throws SQLException {
        Byte by2 = new Byte(by);
        this.setObject(n, (Object)by2, -6, 0);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, (Object)byArray, -6, 0);
    }

    public void setCharacterStream(int n, Reader reader, int n2) {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n, Clob clob) {
        throw new UnsupportedOperationException();
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setObject(n, (Object)date, 91, 0);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setObject(n, date, 91, 0, calendar);
    }

    public void setDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, (Object)bigDecimal, 2, bigDecimal.scale());
    }

    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setObject(n, (Object)d2, 8, 0);
    }

    public void setFloat(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        this.setObject(n, (Object)f2, 7, 0);
    }

    public void setReal(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        this.setObject(n, (Object)f2, 7, 0);
    }

    public void setInt(int n, int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        this.setObject(n, (Object)n3, 4, 0);
    }

    public void setLong(int n, long l) throws SQLException {
        Integer n2 = new Integer((int)l);
        this.setObject(n, (Object)n2, 4, 0);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.setNull (" + n + "," + n2 + ")");
        }
        this.setObject(n, null, n2, 0);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setObject(n, null, n2, 0);
    }

    public void setRef(int n, Ref ref) {
        throw new UnsupportedOperationException();
    }

    public void setShort(int n, short s) throws SQLException {
        Integer n2 = new Integer(s);
        this.setObject(n, (Object)n2, 5, 0);
    }

    public void setString(int n, String string) throws SQLException {
        this.setObject(n, (Object)string, 1, 0);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setObject(n, (Object)time, 92, 0);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setObject(n, time, 92, 0, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setObject(n, (Object)timestamp, 93, 0);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setObject(n, timestamp, 93, 0, calendar);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        String string = uRL.toString();
        this.setObject(n, (Object)string, PicoPreparedStatement.getTypeFromObject(string));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

