/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.forms.frmPrefrencesEditor;
import org.I00acres.isql.forms.frmXtendedPropertyEditor;
import org.I00acres.isql.forms.frmiSQLMain;
import org.I00acres.isql.swing.AuthDialog;
import org.I00acres.isql.swing.ClassListCellRenderer;
import org.I00acres.isql.swing.JNumberEditor;
import org.I00acres.isql.swing.JTextComponentPopup;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.util.xProperties;

public final class frmServiceManager
extends JDialog
implements ListSelectionListener,
CaretListener,
FocusListener {
    private iSQLConfig conf = iSQLConfig.getInstance();
    private boolean isCreatingNewService = false;
    frmiSQLMain mMainformRef;
    private ActionListener actionHandler = new ActionHandler();
    private Properties SupportedDrivers = this.conf.getDriverDefinitions();
    private WeakHashMap JDBCPropertyStore = new WeakHashMap();
    private Hashtable JDBCPropertyMap = new Hashtable();
    private xProperties currentAdvancedSettings = null;
    private xProperties mTransientServices = new xProperties();
    private DefaultListModel mServiceListData = new DefaultListModel();
    private Random mRndNumber = new Random(System.currentTimeMillis());
    private JPanel mContentPanel = new JPanel(new GridBagLayout());
    private JPanel mButtonContainer = new JPanel(new GridLayout());
    private JList mServicesList = new JList(this.mServiceListData);
    private JToolBar mServiceToolbar = new JToolBar(0);
    private JScrollPane mServiceContainer = new JScrollPane(this.mServicesList);
    private JTextComponentPopup textPopupMenu = new JTextComponentPopup();
    private JComboBox mDriverList = new JComboBox<String>(((Hashtable)this.SupportedDrivers).keySet().toArray(new String[0]));
    private JTextField mServiceNameField = new JTextField();
    private JTextField mServiceURLField = new JTextField();
    private JTextField mServiceUserIDField = new JTextField();
    private JTextField mServiceDriverField = (JTextField)this.mDriverList.getEditor().getEditorComponent();
    private JTextField mURLExampleField = new JTextField();
    private JCheckBox mchkUseXtendedProps = new JCheckBox();
    private JCheckBox mchkAuthPrompt = new JCheckBox();
    private JPasswordField mServicePasswordField = new JPasswordField(16);
    private JTabbedPane mConfigContainer = new JTabbedPane(1);
    private JButton mbtnOK = new JButton(iSQLUtilites.getString("Ok"));
    private JButton mbtnTest = new JButton(iSQLUtilites.getString("Test"));
    private JButton mbtnXEdit = new JButton(iSQLUtilites.getString("Elipsis"));
    private JButton mbtnApply = new JButton(iSQLUtilites.getString("Save_Apply"));
    private JButton mbtnCancel = new JButton(iSQLUtilites.getString("Cancel"));
    private JButton mbtnNew = new JButton(iSQLUtilites.loadIconResource("New16"));
    private JButton mbtnMvUP = new JButton(iSQLUtilites.loadIconResource("Up16"));
    private JButton mbtnCopy = new JButton(iSQLUtilites.loadIconResource("Copy16"));
    private JButton mbtnMvDown = new JButton(iSQLUtilites.loadIconResource("Down16"));
    private JButton mbtnDelete = new JButton(iSQLUtilites.loadIconResource("Delete16"));
    private JButton mbtnOption = new JButton(iSQLUtilites.loadIconResource("Preferences16"));
    private ButtonGroup optionGroup = new ButtonGroup();
    private JRadioButton useGlobalOption = new JRadioButton(iSQLUtilites.getString("Use_Global_Setting"));
    private JRadioButton enableOption = new JRadioButton(iSQLUtilites.getString("Enable"));
    private JRadioButton disableOption = new JRadioButton(iSQLUtilites.getString("Disable"));
    private JCheckBox useDiscreteConfig = new JCheckBox(iSQLUtilites.getString("Use_Global_JDBC_Settings"));
    private JComboBox advancedOptions = new JComboBox<String>(new String[]{iSQLUtilites.getString("Enable_Auto_Connect_Text"), iSQLUtilites.getString("Enable_Verbose_Text"), iSQLUtilites.getString("Enable_Debug_Text"), iSQLUtilites.getString("Log_Queries_Text"), iSQLUtilites.getString("Echo_Result_Text"), iSQLUtilites.getString("Allow_Escape_Text"), iSQLUtilites.getString("Enable_Reverse_Fetch_Text"), iSQLUtilites.getString("Enable_JDBC_Trace_Text"), iSQLUtilites.getString("Login_TO_Text"), iSQLUtilites.getString("Query_TO_Text"), iSQLUtilites.getString("Max_Field_Text"), iSQLUtilites.getString("Max_Rows_Text")});
    private JNumberEditor optionEditor = new JNumberEditor(0, 6);
    private boolean needSave = false;
    private Frame zParentRef;

    protected frmServiceManager(Frame Owner, frmiSQLMain frmmain) {
        super(Owner, "", true);
        try {
            this.zParentRef = Owner;
            this.mMainformRef = frmmain;
            ((Hashtable)this.mTransientServices).putAll(this.conf.getAllServiceProperties());
            this.loadPropertyMap();
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "frmServiceManager::initUI()", true);
            return;
        }
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.needSave = false;
        }
        super.processWindowEvent(evt);
    }

    public void dispose() {
        if (this.needSave) {
            iSQLConfig iSQLConfig2 = this.conf;
            synchronized (iSQLConfig2) {
                int i = 0;
                while (i < this.mServiceListData.size()) {
                    String Service = (String)this.mServiceListData.elementAt(i);
                    xProperties props = (xProperties)this.JDBCPropertyStore.get(Service);
                    if (!this.mTransientServices.getBooleanProperty("Server." + Service + ".useDiscreteConfig")) {
                        File xFile = new File(iSQLConfig.getiSQLSubDir("ext"), Service.replace(' ', '_').concat(".jdbc.properties"));
                        try {
                            xFile.delete();
                        }
                        catch (Throwable throwable) {}
                    } else if (!((Hashtable)props).isEmpty()) {
                        this.conf.saveJDBCPropertiesForService(props, Service);
                    }
                    ++i;
                }
                this.conf.setServices(this.mTransientServices);
                this.conf.save();
            }
        }
        super.dispose();
    }

    private void loadPropertyMap() {
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Enable_Auto_Connect_Text"), "JDBC.Auto-Connect");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Enable_Verbose_Text"), "JDBC.Verbose");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Enable_Debug_Text"), "JDBC.Debug-Mode");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Log_Queries_Text"), "JDBC.Log-Queries");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Echo_Result_Text"), "JDBC.EchoRecordCount");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Allow_Escape_Text"), "JDBC.EscapeProcess");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Enable_Reverse_Fetch_Text"), "JDBC.FetchReverse");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Enable_JDBC_Trace_Text"), "JDBC.EnableTrace");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Login_TO_Text"), "JDBC.LoginTimeout");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Query_TO_Text"), "JDBC.QueryTimeout");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Max_Field_Text"), "JDBC.MaxFieldSize");
        this.JDBCPropertyMap.put(iSQLUtilites.getString("Max_Rows_Text"), "JDBC.MaxResultSetSize");
    }

    private void initUI() throws Exception {
        Insets ins = new Insets(2, 2, 2, 2);
        this.mServiceToolbar.setFloatable(false);
        this.mServiceToolbar.add(Box.createHorizontalGlue());
        this.mServiceToolbar.add(this.mbtnOption);
        this.mServiceToolbar.addSeparator();
        this.mServiceToolbar.add(this.mbtnNew);
        this.mServiceToolbar.add(this.mbtnMvUP);
        this.mServiceToolbar.add(this.mbtnMvDown);
        this.mServiceToolbar.add(this.mbtnCopy);
        this.mServiceToolbar.add(this.mbtnDelete);
        this.mDriverList.setEditable(true);
        this.mDriverList.setRenderer(new ClassListCellRenderer());
        this.mDriverList.setMaximumRowCount(5);
        this.mDriverList.addActionListener(this.actionHandler);
        this.mbtnXEdit.setPreferredSize(new Dimension(16, 16));
        this.mbtnXEdit.setMinimumSize(new Dimension(16, 16));
        this.mbtnXEdit.setMaximumSize(new Dimension(16, 16));
        this.mchkUseXtendedProps.addActionListener(this.actionHandler);
        this.mchkUseXtendedProps.setSelected(false);
        this.mbtnXEdit.setEnabled(false);
        this.mServicesList.addListSelectionListener(this);
        this.mServiceUserIDField.addCaretListener(this);
        this.mServiceURLField.addCaretListener(this);
        this.mServicePasswordField.addCaretListener(this);
        this.mServiceDriverField.addCaretListener(this);
        this.textPopupMenu.addJTextComponent(this.mServiceNameField);
        this.textPopupMenu.addJTextComponent(this.mServiceDriverField);
        this.textPopupMenu.addJTextComponent(this.mURLExampleField);
        this.textPopupMenu.addJTextComponent(this.mServiceURLField);
        this.textPopupMenu.addJTextComponent(this.mServiceUserIDField);
        this.textPopupMenu.addJTextComponent(this.mServicePasswordField);
        this.mURLExampleField.setEditable(false);
        this.mServiceNameField.addFocusListener(this);
        this.mbtnApply.addActionListener(this.actionHandler);
        this.mbtnApply.setToolTipText(iSQLUtilites.getString("Save_Apply_Tip"));
        this.mbtnOK.addActionListener(this.actionHandler);
        this.mbtnOK.setToolTipText(iSQLUtilites.getString("OK_Tip"));
        this.mbtnCancel.addActionListener(this.actionHandler);
        this.mbtnCancel.setToolTipText(iSQLUtilites.getString("Cancel_Tip"));
        this.mbtnCopy.addActionListener(this.actionHandler);
        this.mbtnCopy.setToolTipText(iSQLUtilites.getString("Copy_Tip"));
        this.mbtnTest.addActionListener(this.actionHandler);
        this.mbtnTest.setToolTipText(iSQLUtilites.getString("Test_Tip"));
        this.mbtnMvDown.addActionListener(this.actionHandler);
        this.mbtnMvDown.setToolTipText(iSQLUtilites.getString("Move_Down_Tip"));
        this.mbtnMvUP.addActionListener(this.actionHandler);
        this.mbtnMvUP.setToolTipText(iSQLUtilites.getString("Move_Up_Tip"));
        this.mbtnDelete.addActionListener(this.actionHandler);
        this.mbtnDelete.setToolTipText(iSQLUtilites.getString("Delete_Tip"));
        this.mbtnNew.addActionListener(this.actionHandler);
        this.mbtnNew.setToolTipText(iSQLUtilites.getString("New_Tip"));
        this.useDiscreteConfig.addActionListener(this.actionHandler);
        this.useDiscreteConfig.setToolTipText(iSQLUtilites.getString("Use_Discrete_Config_Tip"));
        this.mbtnOption.addActionListener(this.actionHandler);
        this.mbtnOption.setToolTipText(iSQLUtilites.getString("Service_Option_Tip"));
        this.mchkUseXtendedProps.addActionListener(this.actionHandler);
        this.mchkUseXtendedProps.setText(iSQLUtilites.getString("Extended_Properties"));
        this.mchkUseXtendedProps.setToolTipText(iSQLUtilites.getString("Extended_Properties_Tip"));
        this.mchkAuthPrompt.addActionListener(this.actionHandler);
        this.mchkAuthPrompt.setText(iSQLUtilites.getString("SERV_Auth_Prompt"));
        this.mchkAuthPrompt.setToolTipText(iSQLUtilites.getString("SERV_Auth_Prompt_Tip"));
        this.mbtnXEdit.addActionListener(this.actionHandler);
        this.mbtnXEdit.setToolTipText(iSQLUtilites.getString("Extended_Properties_Tip"));
        this.useGlobalOption.addActionListener(this.actionHandler);
        this.enableOption.addActionListener(this.actionHandler);
        this.advancedOptions.addActionListener(this.actionHandler);
        this.disableOption.addActionListener(this.actionHandler);
        this.mButtonContainer.add(this.mbtnOK);
        this.mButtonContainer.add(this.mbtnCancel);
        this.mButtonContainer.add(this.mbtnApply);
        this.mButtonContainer.add(this.mbtnTest);
        JPanel basicConfig = new JPanel(new GridBagLayout());
        JPanel advConfig = new JPanel(new GridBagLayout());
        this.mConfigContainer.addTab(iSQLUtilites.getString("General_Tab_Label"), basicConfig);
        this.mConfigContainer.addTab(iSQLUtilites.getString("Advanced_Tab_Label"), advConfig);
        this.optionGroup.add(this.useGlobalOption);
        this.optionGroup.add(this.enableOption);
        this.optionGroup.add(this.disableOption);
        this.optionEditor.setEnabled(false);
        this.optionEditor.addCaretListener(this);
        advConfig.add((Component)this.useDiscreteConfig, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)new JLabel(iSQLUtilites.getString("Select_JDBC_Option")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)this.advancedOptions, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)this.useGlobalOption, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)this.enableOption, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)this.disableOption, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 0, ins, 0, 0));
        advConfig.add((Component)this.optionEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        advConfig.add(Box.createVerticalGlue(), new GridBagConstraints(0, 5, 3, 1, 0.0, 1.0, 17, 0, ins, 0, 0));
        advConfig.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 6, 1.0, 0.0, 17, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_Name_Label")), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_Driver_Label")), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_Ex_URL_Label")), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_URL_Label")), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_User_Label")), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)new JLabel(iSQLUtilites.getString("SERV_Pass_Label")), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)this.mServiceNameField, new GridBagConstraints(3, 0, 1, 1, 0.9, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mDriverList, new GridBagConstraints(2, 1, 2, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mURLExampleField, new GridBagConstraints(2, 2, 2, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mServiceURLField, new GridBagConstraints(2, 3, 2, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mServiceUserIDField, new GridBagConstraints(2, 4, 2, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mServicePasswordField, new GridBagConstraints(2, 5, 2, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        basicConfig.add((Component)this.mbtnXEdit, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        basicConfig.add((Component)this.mchkUseXtendedProps, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        basicConfig.add((Component)this.mchkAuthPrompt, new GridBagConstraints(2, 7, 2, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        basicConfig.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 4, 1, 0.0, 1.0, 10, 0, ins, 0, 0));
        basicConfig.add(Box.createHorizontalGlue(), new GridBagConstraints(5, 0, 1, 8, 1.0, 0.0, 10, 0, ins, 0, 0));
        this.mContentPanel.add((Component)this.mServiceToolbar, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, ins, 0, 0));
        this.mContentPanel.add((Component)this.mServiceContainer, new GridBagConstraints(0, 1, 1, 1, 0.1, 1.0, 10, 1, ins, 0, 0));
        this.mContentPanel.add((Component)this.mConfigContainer, new GridBagConstraints(1, 0, 1, 2, 0.9, 1.0, 10, 1, ins, 0, 0));
        this.getContentPane().add((Component)this.mContentPanel, "Center");
        this.getContentPane().add((Component)this.mButtonContainer, "South");
        this.clearGUIComponents();
        this.refreshList();
        try {
            this.mServicesList.setSelectedIndex(0);
        }
        catch (Exception exception) {}
        if (this.mServiceListData.size() >= 1) {
            this.allowEditing(true);
        } else {
            this.allowEditing(false);
        }
        this.pack();
    }

    private void handleActionPreformed(Object src, int modifiers) {
        if (src.equals(this.mbtnApply)) {
            this.actionSave(this.mServiceNameField.getText());
        } else if (src == this.mbtnNew) {
            this.actionAddNew(false);
        } else if (src == this.mbtnOption) {
            frmPrefrencesEditor.editSinglePropertyPage(frmiSQLMain.zParent, 2);
        } else if (src == this.mbtnMvUP) {
            this.actionMoveUP();
        } else if (src == this.mbtnMvDown) {
            this.actionMoveDown();
        } else if (src == this.mbtnCopy) {
            this.actionAddNew(true);
        } else if (src == this.mbtnOK) {
            if (this.mServicesList.getSelectedIndex() >= 0) {
                this.actionSave((String)this.mServicesList.getSelectedValue());
            }
            this.needSave = true;
            this.dispose();
        } else if (src == this.advancedOptions) {
            boolean isNotBooleanOption;
            Object prop = this.JDBCPropertyMap.get(this.advancedOptions.getSelectedItem());
            boolean bl = isNotBooleanOption = this.advancedOptions.getSelectedIndex() >= this.advancedOptions.getModel().getSize() - 4;
            if (prop != null) {
                if (((Hashtable)this.currentAdvancedSettings).containsKey(prop) && !isNotBooleanOption) {
                    this.optionEditor.setEnabled(false);
                    boolean value = this.currentAdvancedSettings.getBooleanProperty((String)prop);
                    if (value) {
                        this.enableOption.setSelected(true);
                    } else {
                        this.disableOption.setSelected(true);
                    }
                } else if (!isNotBooleanOption) {
                    this.useGlobalOption.setSelected(true);
                } else if (isNotBooleanOption && ((Hashtable)this.currentAdvancedSettings).containsKey(prop)) {
                    if (this.currentAdvancedSettings.getIntProperty((String)prop) >= 1) {
                        this.enableOption.setSelected(true);
                    } else if (this.currentAdvancedSettings.getIntProperty((String)prop) == this.conf.getIntProperty((String)prop)) {
                        ((Hashtable)this.currentAdvancedSettings).remove(prop);
                        this.useGlobalOption.setSelected(true);
                    } else {
                        this.disableOption.setSelected(true);
                    }
                    this.optionEditor.setEnabled(this.enableOption.isSelected());
                    this.optionEditor.setText(this.currentAdvancedSettings.getProperty((String)prop));
                }
            }
        } else if (src == this.useGlobalOption) {
            Object prop = this.JDBCPropertyMap.get(this.advancedOptions.getSelectedItem());
            if (prop != null) {
                ((Hashtable)this.currentAdvancedSettings).remove(prop);
            }
            this.needSave = true;
            this.optionEditor.setEnabled(false);
        } else if (src == this.enableOption) {
            boolean isNotBooleanOption = this.advancedOptions.getSelectedIndex() >= this.advancedOptions.getModel().getSize() - 4;
            Object prop = this.JDBCPropertyMap.get(this.advancedOptions.getSelectedItem());
            if (prop != null && !isNotBooleanOption) {
                ((Hashtable)this.currentAdvancedSettings).put(prop, "true");
            } else if (isNotBooleanOption) {
                this.optionEditor.setEnabled(true);
            }
            this.needSave = true;
        } else if (src == this.disableOption) {
            boolean isNotBooleanOption = this.advancedOptions.getSelectedIndex() >= this.advancedOptions.getModel().getSize() - 4;
            Object prop = this.JDBCPropertyMap.get(this.advancedOptions.getSelectedItem());
            if (prop != null && !isNotBooleanOption) {
                ((Hashtable)this.currentAdvancedSettings).put(prop, "false");
            } else if (isNotBooleanOption) {
                this.optionEditor.setEnabled(false);
                this.optionEditor.setText("0");
                ((Hashtable)this.currentAdvancedSettings).put(prop, this.optionEditor.getText());
            }
            this.needSave = true;
        } else if (src == this.mbtnTest) {
            this.actionSave(this.mServiceNameField.getText());
            this.actionTest(this.mServiceNameField.getText());
        } else if (src == this.mbtnDelete) {
            this.actionDelete(this.mServiceNameField.getText());
        } else if (src == this.useDiscreteConfig) {
            this.setAdvancedOptionEnabled(!this.useDiscreteConfig.isSelected());
            this.mTransientServices.setBooleanProperty("Server." + this.mServiceNameField.getText() + ".useDiscreteConfig", !this.useDiscreteConfig.isSelected());
            this.advancedOptions.setSelectedIndex(0);
        } else if (src == this.mbtnXEdit) {
            this.showPropertyEditor();
        } else if (src == this.mchkAuthPrompt) {
            this.mTransientServices.setBooleanProperty("Server." + this.mServiceNameField.getText() + ".prompt", this.mchkAuthPrompt.isSelected());
            this.mServiceUserIDField.setEnabled(!this.mchkAuthPrompt.isSelected());
            this.mServicePasswordField.setEnabled(!this.mchkAuthPrompt.isSelected());
        } else if (src == this.mchkUseXtendedProps) {
            this.mbtnXEdit.setEnabled(this.mchkUseXtendedProps.isSelected());
            this.mTransientServices.setBooleanProperty("Server." + this.mServiceNameField.getText() + ".useExt", this.mchkUseXtendedProps.isSelected());
        } else if (src == this.mbtnCancel) {
            this.actionCancel();
        } else if (src == this.mDriverList) {
            this.mURLExampleField.setText(this.SupportedDrivers.getProperty(this.mDriverList.getSelectedItem().toString(), ""));
            this.mURLExampleField.setCaretPosition(0);
        }
    }

    public static int showDialog(Frame Owner, frmiSQLMain main) {
        frmServiceManager lDialog = new frmServiceManager(Owner, main);
        lDialog.setDefaultCloseOperation(2);
        lDialog.setLocationRelativeTo(Owner);
        lDialog.show();
        return 1;
    }

    private void refreshList() {
        ((Hashtable)this.mTransientServices).clear();
        ((Hashtable)this.mTransientServices).putAll(this.conf.getAllServiceProperties());
        this.refreshList(this.conf.getAvailableServices());
    }

    private void refreshList(Object[] newList) {
        this.mServiceListData.removeAllElements();
        this.JDBCPropertyStore.clear();
        int i = 0;
        while (i < newList.length) {
            this.mServiceListData.addElement(newList[i]);
            this.JDBCPropertyStore.put(newList[i], this.conf.loadJDBCPropertiesForService(newList[i].toString()));
            ++i;
        }
    }

    private synchronized void clearGUIComponents() {
        this.setTitle(iSQLUtilites.getString("Service_Manager_Title", ""));
        this.mServiceNameField.setText("");
        this.mServiceURLField.setText("");
        this.mDriverList.setSelectedItem("");
        this.mServiceUserIDField.setText("");
        ((JTextComponent)this.mServicePasswordField).setText("");
        this.mchkUseXtendedProps.setSelected(false);
    }

    private synchronized void allowEditing(boolean f) {
        this.mServiceNameField.setEnabled(f);
        this.mServiceURLField.setEnabled(f);
        this.mDriverList.setEnabled(f);
        this.mServiceUserIDField.setEnabled(f);
        this.mServicePasswordField.setEnabled(f);
        this.mchkUseXtendedProps.setEnabled(f);
        this.mchkAuthPrompt.setEnabled(f);
        this.mConfigContainer.setEnabled(f);
        this.mbtnCopy.setEnabled(f);
        this.mbtnMvDown.setEnabled(f);
        this.mbtnMvUP.setEnabled(f);
        this.mbtnDelete.setEnabled(f);
    }

    private synchronized void setAdvancedOptionEnabled(boolean f) {
        this.useGlobalOption.setEnabled(f);
        this.enableOption.setEnabled(f);
        this.disableOption.setEnabled(f);
        this.advancedOptions.setEnabled(f);
        this.optionEditor.setEnabled(false);
    }

    private void loadGUIComponents(String ServiceName) {
        this.setTitle(iSQLUtilites.getString("Service_Manager_Title", ServiceName));
        this.mServiceNameField.setText(ServiceName);
        this.mServiceURLField.setText(this.mTransientServices.getStringProperty("Server." + ServiceName + ".url", ""));
        this.mDriverList.setSelectedItem(this.mTransientServices.getStringProperty("Server." + ServiceName + ".driver", ""));
        this.mServiceUserIDField.setText(this.mTransientServices.getStringProperty("Server." + ServiceName + ".user", ""));
        ((JTextComponent)this.mServicePasswordField).setText(this.mTransientServices.getStringProperty("Server." + ServiceName + ".pass", ""));
        this.mchkUseXtendedProps.setSelected(this.mTransientServices.getBooleanProperty("Server." + ServiceName + ".useExt", false));
        this.mchkAuthPrompt.setSelected(this.mTransientServices.getBooleanProperty("Server." + ServiceName + ".prompt", false));
        this.mbtnXEdit.setEnabled(this.mchkUseXtendedProps.isSelected());
        this.mServiceUserIDField.setEnabled(!this.mchkAuthPrompt.isSelected());
        this.mServicePasswordField.setEnabled(!this.mchkAuthPrompt.isSelected());
        this.useDiscreteConfig.setSelected(!this.mTransientServices.getBooleanProperty("Server." + ServiceName + ".useDiscreteConfig", false));
        this.setAdvancedOptionEnabled(!this.useDiscreteConfig.isSelected());
    }

    private void actionCancel() {
        this.needSave = false;
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void actionTest(String ServiceName) {
        block9: {
            block8: {
                String Key2 = "Server." + ServiceName;
                try {
                    try {
                        DatabaseConnection db = this.mTransientServices.getBooleanProperty(String.valueOf(Key2) + ".useExt", false) ? new DatabaseConnection(this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".url", ""), this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".driver", ""), this.conf.loadXtendedPropertiesForService(ServiceName)) : new DatabaseConnection(this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".url", ""), this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".user", ""), this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".pass", ""), this.mTransientServices.getStringProperty(String.valueOf(Key2) + ".driver", ""));
                        if (this.conf.isConnectionPromptRequired(ServiceName)) {
                            String[] newTokens = AuthDialog.showDialog(this.zParentRef);
                            if (newTokens == null) {
                                System.out.println(iSQLUtilites.getString("Connect_Cancelled", ServiceName));
                                Object var6_6 = null;
                                break block8;
                            }
                            db.updateAutheticationTokens(newTokens[0], newTokens[1]);
                        }
                        if (db.init()) {
                            JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Connect_Sucess_Message", ServiceName));
                        } else {
                            JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Connect_Failed", db.getLastError().toString()), iSQLUtilites.getString("Error"), 0);
                        }
                        db.disconnect();
                        db = null;
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Connect_Failed", ex.toString()), iSQLUtilites.getString("Error"), 0);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    System.gc();
                    System.runFinalization();
                    throw throwable;
                }
            }
            System.gc();
            System.runFinalization();
            return;
        }
        Object var6_8 = null;
        System.gc();
        System.runFinalization();
    }

    private void actionSave(String ServiceName) {
        if (ServiceName.trim().length() >= 0) {
            ServiceName.replace(',', '_');
            new String(this.mServicePasswordField.getPassword());
            String slist = this.mTransientServices.getStringProperty("ServerList", "");
            if (slist.lastIndexOf(44) < 0) {
                slist = String.valueOf(ServiceName) + ",";
            } else if (slist.indexOf(ServiceName) < 0) {
                slist = slist.concat(String.valueOf(ServiceName) + ",");
            }
            String Key2 = "Server." + ServiceName;
            this.mTransientServices.setStringProperty("ServerList", slist);
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".url", this.mServiceURLField.getText());
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".driver", this.mDriverList.getSelectedItem().toString());
            if (!this.mchkAuthPrompt.isSelected()) {
                this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".user", this.mServiceUserIDField.getText());
                this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".pass", new String(this.mServicePasswordField.getPassword()));
            } else {
                ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".user");
                ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".pass");
            }
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".useExt", this.mchkUseXtendedProps.isSelected());
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".Prompt", this.mchkAuthPrompt.isSelected());
            this.mServicesList.setSelectedValue(ServiceName, true);
        }
        if (!this.needSave) {
            this.needSave = true;
        }
        this.conf.setServices(this.mTransientServices);
    }

    private void actionDelete(String ServiceName) {
        new String(this.mServicePasswordField.getPassword());
        String slist = this.mTransientServices.getStringProperty("ServerList", "");
        this.clearGUIComponents();
        if (slist.indexOf(String.valueOf(ServiceName) + ",") >= 0) {
            int start = slist.indexOf(String.valueOf(ServiceName) + ",");
            int end = start + ServiceName.length() + 1;
            slist = String.valueOf(slist.substring(0, start)) + slist.substring(end);
            this.mTransientServices.setStringProperty("ServerList", slist);
        }
        if (slist.trim().length() == 0) {
            ((Hashtable)this.mTransientServices).remove("ServerList");
        }
        String Key2 = "Server." + ServiceName;
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".url");
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".driver");
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".user");
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".pass");
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".useExt");
        ((Hashtable)this.mTransientServices).remove(String.valueOf(Key2) + ".Prompt");
        int idx = this.mServiceListData.indexOf(ServiceName) - 1;
        this.mServiceListData.remove(idx + 1);
        this.mServicesList.validate();
        if (this.mServiceListData.size() <= 0) {
            this.allowEditing(false);
        } else {
            this.mServicesList.setSelectedIndex(0);
        }
        if (!this.needSave) {
            this.needSave = true;
        }
    }

    private void showPropertyEditor() {
        frmXtendedPropertyEditor.showDialog(this, this.mServicesList.getSelectedValue().toString());
    }

    private synchronized void actionAddNew(boolean isCopy) {
        this.isCreatingNewService = true;
        if (!isCopy) {
            this.clearGUIComponents();
        }
        String ServiceName = Integer.toHexString(this.mRndNumber.nextInt());
        String slist = this.mTransientServices.getStringProperty("ServerList", "");
        if (slist.lastIndexOf(44) < 0) {
            slist = String.valueOf(ServiceName) + ",";
        } else if (slist.indexOf(ServiceName) < 0) {
            slist = slist.concat(String.valueOf(ServiceName) + ",");
        }
        this.mTransientServices.setStringProperty("ServerList", slist);
        String Key2 = "Server." + ServiceName;
        this.mServiceNameField.setName(ServiceName);
        if (isCopy) {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".url", this.mServiceURLField.getText());
        } else {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".url", "");
        }
        this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".useDiscreteConfig", "false");
        if (isCopy) {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".driver", this.mServiceDriverField.getText());
        } else {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".driver", "");
        }
        if (isCopy) {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".user", this.mServiceUserIDField.getText());
        } else {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".user", System.getProperty("user.name"));
        }
        if (isCopy) {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".pass", new String(this.mServicePasswordField.getPassword()));
        } else {
            this.mTransientServices.setStringProperty(String.valueOf(Key2) + ".pass", "");
        }
        if (isCopy) {
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".useExt", this.mchkUseXtendedProps.isSelected());
        } else {
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".useExt", false);
        }
        if (isCopy) {
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".prompt", this.mchkAuthPrompt.isSelected());
        } else {
            this.mTransientServices.setBooleanProperty(String.valueOf(Key2) + ".prompt", false);
        }
        this.isCreatingNewService = false;
        this.mServiceListData.addElement(ServiceName);
        this.mServicesList.setSelectedIndex(this.mServiceListData.indexOf(ServiceName));
        if (this.mServiceListData.size() >= 1) {
            this.allowEditing(true);
        }
    }

    private void actionMoveUP() {
        int idx = this.mServicesList.getSelectedIndex();
        if (idx < 1 && idx <= this.mServiceListData.getSize()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Object selected = this.mServiceListData.getElementAt(idx);
        Object other = this.mServiceListData.getElementAt(idx - 1);
        this.mServiceListData.setElementAt(selected, idx - 1);
        this.mServiceListData.setElementAt(other, idx);
        this.mServicesList.setSelectedIndex(idx - 1);
    }

    private void actionMoveDown() {
        int idx = this.mServicesList.getSelectedIndex();
        if (idx >= this.mServiceListData.getSize() - 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Object selected = this.mServiceListData.getElementAt(idx);
        Object other = this.mServiceListData.getElementAt(idx + 1);
        this.mServiceListData.setElementAt(selected, idx + 1);
        this.mServiceListData.setElementAt(other, idx);
        this.mServicesList.setSelectedIndex(idx + 1);
    }

    private synchronized void saveServerList() {
        StringBuffer newOrder = new StringBuffer("");
        int i = 0;
        while (i < this.mServiceListData.getSize()) {
            newOrder.append(this.mServiceListData.elementAt(i) + ",");
            ++i;
        }
        this.mTransientServices.setStringProperty("ServerList", newOrder.toString());
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource().equals(this.mServiceNameField) && !this.mServiceNameField.getText().equals(this.mDriverList.getSelectedItem())) {
            String Oldname = this.mServiceListData.elementAt(this.mServicesList.getSelectedIndex()).toString();
            String Newname = this.mServiceNameField.getText();
            if (this.mServiceListData.contains(Newname) || Newname.trim().length() == 0) {
                this.mServiceNameField.setText(Oldname);
                return;
            }
            StringBuffer slist = new StringBuffer(this.mTransientServices.getStringProperty("ServerList", ""));
            try {
                int start = slist.toString().indexOf(Oldname);
                int stop = slist.toString().indexOf(",", start);
                slist.replace(start, stop, Newname);
            }
            catch (Exception exception) {}
            this.mTransientServices.setStringProperty("ServerList", slist.toString());
            this.mTransientServices.renameProperty("Server." + Oldname + ".url", "Server." + Newname + ".url");
            this.mTransientServices.renameProperty("Server." + Oldname + ".driver", "Server." + Newname + ".driver");
            this.mTransientServices.renameProperty("Server." + Oldname + ".user", "Server." + Newname + ".user");
            this.mTransientServices.renameProperty("Server." + Oldname + ".pass", "Server." + Newname + ".pass");
            this.mTransientServices.renameProperty("Server." + Oldname + ".useExt", "Server." + Newname + ".useExt");
            this.mTransientServices.renameProperty("Server." + Oldname + ".prompt", "Server." + Newname + ".prompt");
            this.mTransientServices.renameProperty("Server." + Oldname + ".useDiscreteConfig", "Server." + Newname + ".useDiscreteConfig");
            this.mServiceListData.setElementAt(Newname, this.mServiceListData.indexOf(Oldname));
            this.mServicesList.setSelectedValue(Newname, true);
        }
    }

    public void caretUpdate(CaretEvent evt) {
        if (this.mServiceListData.size() <= 0) {
            return;
        }
        String ServiceName = this.mServicesList.getSelectedValue().toString();
        if (evt.getSource().equals(this.mServicePasswordField) && !this.isCreatingNewService) {
            this.mTransientServices.setStringProperty("Server." + ServiceName + ".pass", new String(this.mServicePasswordField.getPassword()));
        } else if (evt.getSource().equals(this.mServiceUserIDField) && !this.isCreatingNewService) {
            this.mTransientServices.setStringProperty("Server." + ServiceName + ".user", this.mServiceUserIDField.getText());
        } else if (evt.getSource().equals(this.mServiceURLField) && !this.isCreatingNewService) {
            this.mTransientServices.setStringProperty("Server." + ServiceName + ".url", this.mServiceURLField.getText());
        } else if (evt.getSource().equals(this.mServiceDriverField) && !this.isCreatingNewService) {
            this.mTransientServices.setStringProperty("Server." + ServiceName + ".driver", this.mServiceDriverField.getText());
        } else if (evt.getSource() == this.optionEditor) {
            boolean isNotBooleanOption;
            Object prop = this.JDBCPropertyMap.get(this.advancedOptions.getSelectedItem());
            boolean bl = isNotBooleanOption = this.advancedOptions.getSelectedIndex() >= this.advancedOptions.getModel().getSize() - 4;
            if (isNotBooleanOption) {
                this.currentAdvancedSettings.setProperty((String)prop, this.optionEditor.getText());
            }
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        String Service = (String)this.mServicesList.getSelectedValue();
        this.loadGUIComponents(Service);
        this.mConfigContainer.setSelectedIndex(0);
        this.currentAdvancedSettings = (xProperties)this.JDBCPropertyStore.get(Service);
        this.advancedOptions.setSelectedIndex(0);
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            frmServiceManager.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    frmServiceManager.this.handleActionPreformed(evt.getSource(), evt.getModifiers());
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                frmServiceManager.this.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            Object var3_4 = null;
            frmServiceManager.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

