/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.I00acres.isql.util.iSQLUtilites;

public class BatchControlEditor
extends JComponent
implements TableCellEditor,
ActionListener,
TableCellRenderer {
    protected int clickCountToStart = 1;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    private JToggleButton btn = new JToggleButton();
    static /* synthetic */ Class class$0;

    public BatchControlEditor() {
        try {
            this.initUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initUI() throws Exception {
        this.setLayout(new BorderLayout(4, 3));
        this.btn.addActionListener(this);
        this.add((Component)new JLabel(), "South");
        this.add((Component)new JLabel(), "North");
        this.add((Component)new JLabel(), "West");
        this.add((Component)new JLabel(), "East");
        this.add((Component)this.btn, "Center");
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        boolean v = false;
        this.btn.setVisible(table.isCellEditable(row, column));
        try {
            v = (Boolean)value;
        }
        catch (Exception exception) {}
        this.btn.setSelected(v);
        if (v) {
            this.btn.setIcon(iSQLUtilites.loadIconResource("Play16"));
        } else {
            this.btn.setIcon(iSQLUtilites.loadIconResource("Pause16"));
        }
        return this;
    }

    public Object getCellEditorValue() {
        return new Boolean(this.btn.isSelected());
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.CellEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.CellEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.CellEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.CellEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.btn.setVisible(table.isCellEditable(row, column));
        boolean v = false;
        try {
            v = (Boolean)value;
        }
        catch (Exception exception) {}
        this.btn.setSelected(v);
        if (v) {
            this.btn.setIcon(iSQLUtilites.loadIconResource("Play16"));
        } else {
            this.btn.setIcon(iSQLUtilites.loadIconResource("Pause16"));
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        return this;
    }
}

