/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JNumberEditor
extends JTextField
implements ComboBoxEditor {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());

    public JNumberEditor() {
        this(0, 10);
    }

    public JNumberEditor(int value) {
        this(value, 10);
    }

    public JNumberEditor(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        try {
            this.setText(this.integerFormatter.format(value));
        }
        catch (Exception exception) {
            this.setText("0");
        }
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    public Component getEditorComponent() {
        return this;
    }

    public void setItem(Object anObject) {
        this.setValue(Integer.parseInt(anObject.toString()));
    }

    public Object getItem() {
        return "" + this.getValue();
    }

    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            int i = 0;
            while (i < result.length) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                } else {
                    toolkit.beep();
                }
                ++i;
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

