/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.util.iSQLUtilites;

public class JTextComponentPopup
extends JPopupMenu
implements MouseListener,
ActionListener {
    private JMenuItem pu_cut = new JMenuItem(iSQLUtilites.getString("Cut"), iSQLUtilites.loadIconResource("Cut16"));
    private JMenuItem pu_copy = new JMenuItem(iSQLUtilites.getString("Copy"), iSQLUtilites.loadIconResource("Copy16"));
    private JMenuItem pu_paste = new JMenuItem(iSQLUtilites.getString("Paste"), iSQLUtilites.loadIconResource("Paste16"));
    private JMenuItem pu_clear = new JMenuItem(iSQLUtilites.getString("Clear_All"));
    private JMenuItem pu_save = new JMenuItem(iSQLUtilites.getString("Save_To_File"), iSQLUtilites.loadIconResource("Save16"));
    private JMenuItem pu_selectAll = new JMenuItem(iSQLUtilites.getString("Select_All"));
    private JTextComponent console;

    public JTextComponentPopup() {
        this.add(this.pu_cut);
        this.add(this.pu_copy);
        this.add(this.pu_paste);
        this.add(this.pu_save);
        this.addSeparator();
        this.add(this.pu_clear);
        this.add(this.pu_selectAll);
        this.pu_paste.setAccelerator(iSQLUtilites.createKeyStroke(86, 2));
        this.pu_copy.setAccelerator(iSQLUtilites.createKeyStroke(67, 2));
        this.pu_selectAll.setAccelerator(iSQLUtilites.createKeyStroke(65, 2));
        this.pu_cut.setAccelerator(iSQLUtilites.createKeyStroke(88, 2));
        this.pu_selectAll.addActionListener(this);
        this.pu_cut.addActionListener(this);
        this.pu_copy.addActionListener(this);
        this.pu_paste.addActionListener(this);
        this.pu_clear.addActionListener(this);
        this.pu_save.addActionListener(this);
    }

    public final JMenu toJMenu() {
        JMenu r = new JMenu(iSQLUtilites.getString("Edit"));
        r.setMnemonic('E');
        r.add(this.pu_cut);
        r.add(this.pu_copy);
        r.add(this.pu_paste);
        r.add(this.pu_save);
        r.addSeparator();
        r.add(this.pu_clear);
        r.add(this.pu_selectAll);
        return r;
    }

    public final void removeJTextComponent(JTextComponent jtc) {
        this.console = jtc;
        jtc.removeMouseListener(this);
        jtc.remove(this);
    }

    public final void addJTextComponent(JTextComponent jtc) {
        this.addJTextComponent(jtc, true);
    }

    public final void addJTextComponent(JTextComponent jtc, boolean f) {
        this.console = jtc;
        if (f) {
            jtc.addMouseListener(this);
            jtc.add(this);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        JMenuItem src = (JMenuItem)ae.getSource();
        if (src.equals(this.pu_copy)) {
            this.console.copy();
        } else if (src.equals(this.pu_paste)) {
            this.console.paste();
        } else if (src.equals(this.pu_selectAll)) {
            this.console.selectAll();
        } else if (src.equals(this.pu_cut)) {
            this.console.copy();
            if (this.console.isEditable()) {
                this.console.cut();
            }
        } else if (src.equals(this.pu_clear)) {
            if (this.console.isEnabled()) {
                this.console.setText("");
                this.console.setCaretPosition(0);
            }
        } else if (src.equals(this.pu_save)) {
            this.Save();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void Save() {
        block7: {
            block6: {
                try {
                    try {
                        File f = iSQLUtilites.saveSystemFile(this);
                        if (f == null) {
                            Object var4_2 = null;
                            break block6;
                        }
                        if (!f.exists()) {
                            f.createNewFile();
                        }
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(this.console.getText().getBytes());
                        fos.close();
                        fos = null;
                        f = null;
                    }
                    catch (Exception exception) {}
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    System.gc();
                    System.runFinalization();
                    throw throwable;
                }
            }
            System.gc();
            System.runFinalization();
            return;
        }
        Object var4_4 = null;
        System.gc();
        System.runFinalization();
    }

    public void show(Component com, int x, int y) {
        if (com instanceof JTextComponent) {
            this.console = (JTextComponent)com;
            this.pu_paste.setEnabled(this.console.isEditable());
            super.show(com, x, y);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
            this.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

