/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;

import java.sql.Types;

public class OdbcDef
{

    public OdbcDef()
    {
    }

    public static int jdbcTypeToOdbc(int i)
    {
        int j = i;
        switch(i)
        {
        case 91: // '['
            j = 9;
            break;

        case 92: // '\\'
            j = 10;
            break;

        case 93: // ']'
            j = 11;
            break;

        }
        return j;
    }

    public static int odbcTypeToJdbc(int i)
    {
        int j = i;
        switch(i)
        {
        case 9: // '\t'
            j = 91;
            break;

        case 10: // '\n'
            j = 92;
            break;

        case 11: // '\013'
            j = 93;
            break;

        }
        return j;
    }

    public static final short SQL_SUCCESS = 0;
    public static final short SQL_SUCCESS_WITH_INFO = 1;
    public static final short SQL_NO_DATA = 100;
    public static final short SQL_NO_DATA_FOUND = 100;
    public static final short SQL_ERROR = -1;
    public static final short SQL_INVALID_HANDLE = -2;
    public static final short SQL_STILL_EXECUTING = 2;
    public static final short SQL_NEED_DATA = 99;
    public static final short SQL_TRUE = 1;
    public static final short SQL_FALSE = 0;

    public static final short SQL_CHAR = 1;
    public static final short SQL_NUMERIC = 2;
    public static final short SQL_DECIMAL = 3;
    public static final short SQL_INTEGER = 4;
    public static final short SQL_SMALLINT = 5;
    public static final short SQL_FLOAT = 6;
    public static final short SQL_REAL = 7;
    public static final short SQL_DOUBLE = 8;
    public static final short SQL_DATE = 9;
    public static final short SQL_TIME = 10;
    public static final short SQL_TIMESTAMP = 11;
    public static final short SQL_VARCHAR = 12;
    public static final short SQL_LONGVARCHAR = -1;
    public static final short SQL_BINARY = -2;
    public static final short SQL_VARBINARY = -3;
    public static final short SQL_LONGVARBINARY = -4;
    public static final short SQL_BIGINT = -5;
    public static final short SQL_TINYINT = -6;
    public static final short SQL_BIT = -7;

    public static final short SQL_C_BINARY = -2;
    public static final short SQL_C_BIT = -7;
    public static final short SQL_C_BOOKMARK = -18;
    public static final short SQL_C_CHAR = 1;
    public static final short SQL_C_DEFAULT = 99;
    public static final short SQL_C_DOUBLE = 8;
    public static final short SQL_C_FLOAT = 7;
    public static final short SQL_C_LONG = 4;
    public static final short SQL_C_SHORT = 5;
    public static final short SQL_C_SLONG = -16;
    public static final short SQL_C_SSHORT = -15;
    public static final short SQL_C_STINYINT = -26;
    public static final short SQL_C_DATE = 91;
    public static final short SQL_C_TIME = 92;
    public static final short SQL_C_TIMESTAMP = 93;
    public static final short SQL_C_TINYINT = -6;
    public static final short SQL_C_ULONG = -18;
    public static final short SQL_C_USHORT = -17;
    public static final short SQL_C_UTINYINT = -28;
    public static final short SQL_TYPE_NULL = 0;
    public static final short SQL_TYPE_UNKNOWN = 9999;
    public static final int SQL_NULL_HENV = 0;
    public static final int SQL_NULL_HDBC = 0;
    public static final int SQL_NULL_HSTMT = 0;
    public static final int SQL_NULL_DATA = -1;
    public static final int SQL_NO_TOTAL = -4;
    public static final short SQL_CLOSE = 0;
    public static final short SQL_DROP = 1;
    public static final short SQL_UNBIND = 2;
    public static final short SQL_RESET_PARAMS = 3;
    public static final short SQL_ACCESS_MODE = 101;
    public static final int SQL_MODE_READ_WRITE = 0;
    public static final int SQL_MODE_READ_ONLY = 1;
    public static final short SQL_AUTOCOMMIT = 102;
    public static final int SQL_AUTOCOMMIT_OFF = 0;
    public static final int SQL_AUTOCOMMIT_ON = 1;
    public static final short SQL_LOGIN_TIMEOUT = 103;
    public static final short SQL_TXN_ISOLATION = 108;
    public static final short SQL_CURRENT_QUALIFIER = 109;
    public static final short SQL_ACTIVE_CONNECTIONS = 0;
    public static final short SQL_ACTIVE_STATEMENTS = 1;
    public static final short SQL_DRIVER_NAME = 6;
    public static final short SQL_DRIVER_VER = 7;
    public static final short SQL_ODBC_VER = 10;
    public static final short SQL_SEARCH_PATTERN_ESCAPE = 14;
    public static final short SQL_ODBC_SQL_CONFORMANCE = 15;
    public static final short SQL_OSC_MINIMUM = 0;
    public static final short SQL_OSC_CORE = 1;
    public static final short SQL_OSC_EXTENDED = 2;
    public static final short SQL_DATABASE_NAME = 16;
    public static final short SQL_DBMS_NAME = 17;
    public static final short SQL_DBMS_VER = 18;
    public static final short SQL_ACCESSIBLE_TABLES = 19;
    public static final short SQL_ACCESSIBLE_PROCEDURES = 20;
    public static final short SQL_PROCEDURES = 21;
    public static final short SQL_CONCAT_NULL_BEHAVIOR = 22;
    public static final short SQL_CB_NULL = 0;
    public static final short SQL_CB_NON_NULL = 1;
    public static final short SQL_CURSOR_COMMIT_BEHAVIOR = 23;
    public static final short SQL_CURSOR_ROLLBACK_BEHAVIOR = 24;
    public static final short SQL_CB_DELETE = 0;
    public static final short SQL_CB_CLOSE = 1;
    public static final short SQL_CB_PRESERVE = 2;
    public static final short SQL_DATA_SOURCE_READ_ONLY = 25;
    public static final short SQL_DEFAULT_TXN_ISOLATION = 26;
    public static final short SQL_EXPRESSIONS_IN_ORDERBY = 27;
    public static final short SQL_IDENTIFIER_CASE = 28;
    public static final short SQL_IC_UPPER = 1;
    public static final short SQL_IC_LOWER = 2;
    public static final short SQL_IC_SENSITIVE = 3;
    public static final short SQL_IC_MIXED = 4;
    public static final short SQL_IDENTIFIER_QUOTE_CHAR = 29;
    public static final short SQL_MAX_COLUMN_NAME_LEN = 30;
    public static final short SQL_MAX_CURSOR_NAME_LEN = 31;
    public static final short SQL_MAX_OWNER_NAME_LEN = 32;
    public static final short SQL_MAX_PROCEDURE_NAME_LEN = 33;
    public static final short SQL_MAX_QUALIFIER_NAME_LEN = 34;
    public static final short SQL_MAX_TABLE_NAME_LEN = 35;
    public static final short SQL_MULT_RESULT_SETS = 36;
    public static final short SQL_MULTIPLE_ACTIVE_TXN = 37;
    public static final short SQL_OUTER_JOINS = 38;
    public static final short SQL_OWNER_TERM = 39;
    public static final short SQL_PROCEDURE_TERM = 40;
    public static final short SQL_QUALIFIER_NAME_SEPARATOR = 41;
    public static final short SQL_QUALIFIER_TERM = 42;
    public static final short SQL_TXN_CAPABLE = 46;
    public static final short SQL_TC_NONE = 0;
    public static final short SQL_TC_DML = 1;
    public static final short SQL_TC_ALL = 2;
    public static final short SQL_TC_DDL_COMMIT = 3;
    public static final short SQL_TC_DDL_IGNORE = 4;
    public static final short SQL_USER_NAME = 47;
    public static final short SQL_CONVERT_FUNCTIONS = 48;
    public static final int SQL_FN_CVT_CONVERT = 1;
    public static final short SQL_NUMERIC_FUNCTIONS = 49;
    public static final int SQL_FN_NUM_ABS = 1;
    public static final int SQL_FN_NUM_ACOS = 2;
    public static final int SQL_FN_NUM_ASIN = 4;
    public static final int SQL_FN_NUM_ATAN = 8;
    public static final int SQL_FN_NUM_ATAN2 = 16;
    public static final int SQL_FN_NUM_CEILING = 32;
    public static final int SQL_FN_NUM_COS = 64;
    public static final int SQL_FN_NUM_COT = 128;
    public static final int SQL_FN_NUM_EXP = 256;
    public static final int SQL_FN_NUM_FLOOR = 512;
    public static final int SQL_FN_NUM_LOG = 1024;
    public static final int SQL_FN_NUM_MOD = 2048;
    public static final int SQL_FN_NUM_SIGN = 4096;
    public static final int SQL_FN_NUM_SIN = 8192;
    public static final int SQL_FN_NUM_SQRT = 16384;
    public static final int SQL_FN_NUM_TAN = 32768;
    public static final int SQL_FN_NUM_PI = 0x10000;
    public static final int SQL_FN_NUM_RAND = 0x20000;
    public static final int SQL_FN_NUM_DEGREES = 0x40000;
    public static final int SQL_FN_NUM_LOG10 = 0x80000;
    public static final int SQL_FN_NUM_POWER = 0x100000;
    public static final int SQL_FN_NUM_RADIANS = 0x200000;
    public static final int SQL_FN_NUM_ROUND = 0x400000;
    public static final int SQL_FN_NUM_TRUNCATE = 0x800000;
    public static final short SQL_STRING_FUNCTIONS = 50;
    public static final int SQL_FN_STR_CONCAT = 1;
    public static final int SQL_FN_STR_INSERT = 2;
    public static final int SQL_FN_STR_LEFT = 4;
    public static final int SQL_FN_STR_LTRIM = 8;
    public static final int SQL_FN_STR_LENGTH = 16;
    public static final int SQL_FN_STR_LOCATE = 32;
    public static final int SQL_FN_STR_LCASE = 64;
    public static final int SQL_FN_STR_REPEAT = 128;
    public static final int SQL_FN_STR_REPLACE = 256;
    public static final int SQL_FN_STR_RIGHT = 512;
    public static final int SQL_FN_STR_RTRIM = 1024;
    public static final int SQL_FN_STR_SUBSTRING = 2048;
    public static final int SQL_FN_STR_UCASE = 4096;
    public static final int SQL_FN_STR_ASCII = 8192;
    public static final int SQL_FN_STR_CHAR = 16384;
    public static final int SQL_FN_STR_DIFFERENCE = 32768;
    public static final int SQL_FN_STR_LOCATE_2 = 0x10000;
    public static final int SQL_FN_STR_SOUNDEX = 0x20000;
    public static final int SQL_FN_STR_SPACE = 0x40000;
    public static final short SQL_SYSTEM_FUNCTIONS = 51;
    public static final int SQL_FN_SYS_USERNAME = 1;
    public static final int SQL_FN_SYS_DBNAME = 2;
    public static final int SQL_FN_SYS_IFNULL = 4;
    public static final short SQL_TIMEDATE_FUNCTIONS = 52;
    public static final int SQL_FN_TD_NOW = 1;
    public static final int SQL_FN_TD_CURDATE = 2;
    public static final int SQL_FN_TD_DAYOFMONTH = 4;
    public static final int SQL_FN_TD_DAYOFWEEK = 8;
    public static final int SQL_FN_TD_DAYOFYEAR = 16;
    public static final int SQL_FN_TD_MONTH = 32;
    public static final int SQL_FN_TD_QUARTER = 64;
    public static final int SQL_FN_TD_WEEK = 128;
    public static final int SQL_FN_TD_YEAR = 256;
    public static final int SQL_FN_TD_CURTIME = 512;
    public static final int SQL_FN_TD_HOUR = 1024;
    public static final int SQL_FN_TD_MINUTE = 2048;
    public static final int SQL_FN_TD_SECOND = 4096;
    public static final int SQL_FN_TD_TIMESTAMPADD = 8192;
    public static final int SQL_FN_TD_TIMESTAMPDIFF = 16384;
    public static final int SQL_FN_TD_DAYNAME = 32768;
    public static final int SQL_FN_TD_MONTHNAME = 0x10000;
    public static final short SQL_CONVERT_BIGINT = 53;
    public static final short SQL_CONVERT_BINARY = 54;
    public static final short SQL_CONVERT_BIT = 55;
    public static final short SQL_CONVERT_CHAR = 56;
    public static final short SQL_CONVERT_DATE = 57;
    public static final short SQL_CONVERT_DECIMAL = 58;
    public static final short SQL_CONVERT_DOUBLE = 59;
    public static final short SQL_CONVERT_FLOAT = 60;
    public static final short SQL_CONVERT_INTEGER = 61;
    public static final short SQL_CONVERT_LONGVARCHAR = 62;
    public static final short SQL_CONVERT_NUMERIC = 63;
    public static final short SQL_CONVERT_REAL = 64;
    public static final short SQL_CONVERT_SMALLINT = 65;
    public static final short SQL_CONVERT_TIME = 66;
    public static final short SQL_CONVERT_TIMESTAMP = 67;
    public static final short SQL_CONVERT_TINYINT = 68;
    public static final short SQL_CONVERT_VARBINARY = 69;
    public static final short SQL_CONVERT_VARCHAR = 70;
    public static final short SQL_CONVERT_LONGVARBINARY = 71;
    public static final int SQL_CVT_CHAR = 1;
    public static final int SQL_CVT_NUMERIC = 2;
    public static final int SQL_CVT_DECIMAL = 4;
    public static final int SQL_CVT_INTEGER = 8;
    public static final int SQL_CVT_SMALLINT = 16;
    public static final int SQL_CVT_FLOAT = 32;
    public static final int SQL_CVT_REAL = 64;
    public static final int SQL_CVT_DOUBLE = 128;
    public static final int SQL_CVT_VARCHAR = 256;
    public static final int SQL_CVT_LONGVARCHAR = 512;
    public static final int SQL_CVT_BINARY = 1024;
    public static final int SQL_CVT_VARBINARY = 2048;
    public static final int SQL_CVT_BIT = 4096;
    public static final int SQL_CVT_TINYINT = 8192;
    public static final int SQL_CVT_BIGINT = 16384;
    public static final int SQL_CVT_DATE = 32768;
    public static final int SQL_CVT_TIME = 0x10000;
    public static final int SQL_CVT_TIMESTAMP = 0x20000;
    public static final int SQL_CVT_LONGVARBINARY = 0x40000;
    public static final short SQL_TXN_ISOLATION_OPTION = 72;
    public static final int SQL_TXN_READ_UNCOMMITTED = 1;
    public static final int SQL_TXN_READ_COMMITTED = 2;
    public static final int SQL_TXN_REPEATABLE_READ = 4;
    public static final int SQL_TXN_SERIALIZABLE = 8;
    public static final int SQL_TXN_VERSIONING = 16;
    public static final short SQL_CORRELATION_NAME = 74;
    public static final short SQL_CN_NONE = 0;
    public static final short SQL_CN_DIFFERENT = 1;
    public static final short SQL_CN_ANY = 2;
    public static final short SQL_ODBC_SQL_OPT_IEF = 73;
    public static final short SQL_NON_NULLABLE_COLUMNS = 75;
    public static final short SQL_NNC_NULL = 0;
    public static final short SQL_NNC_NON_NULL = 1;
    public static final short SQL_POSITIONED_STATEMENTS = 80;
    public static final int SQL_PS_POSITIONED_DELETE = 1;
    public static final int SQL_PS_POSITIONED_UPDATE = 2;
    public static final int SQL_PS_SELECT_FOR_UPDATE = 4;
    public static final short SQL_FILE_USAGE = 84;
    public static final short SQL_FILE_NOT_SUPPORTED = 0;
    public static final short SQL_FILE_TABLE = 1;
    public static final short SQL_FILE_QUALIFIER = 2;
    public static final short SQL_NULL_COLLATION = 85;
    public static final short SQL_NC_HIGH = 0;
    public static final short SQL_NC_LOW = 1;
    public static final short SQL_NC_START = 2;
    public static final short SQL_NC_END = 4;
    public static final short SQL_ALTER_TABLE = 86;
    public static final int SQL_AT_ADD_COLUMN = 1;
    public static final int SQL_AT_DROP_COLUMN = 2;
    public static final short SQL_COLUMN_ALIAS = 87;
    public static final short SQL_GROUP_BY = 88;
    public static final short SQL_GB_NOT_SUPPORTED = 0;
    public static final short SQL_GB_GROUP_BY_EQUALS_SELECT = 1;
    public static final short SQL_GB_GROUP_BY_CONTAINS_SELECT = 2;
    public static final short SQL_GB_NO_RELATION = 3;
    public static final short SQL_KEYWORDS = 89;
    public static final short SQL_ORDER_BY_COLUMNS_IN_SELECT = 90;
    public static final short SQL_OWNER_USAGE = 91;
    public static final int SQL_OU_DML_STATEMENTS = 1;
    public static final int SQL_OU_PROCEDURE_INVOCATION = 2;
    public static final int SQL_OU_TABLE_DEFINITION = 4;
    public static final int SQL_OU_INDEX_DEFINITION = 8;
    public static final int SQL_OU_PRIVILEGE_DEFINITION = 16;
    public static final short SQL_QUALIFIER_USAGE = 92;
    public static final int SQL_QU_DML_STATEMENTS = 1;
    public static final int SQL_QU_PROCEDURE_INVOCATION = 2;
    public static final int SQL_QU_TABLE_DEFINITION = 4;
    public static final int SQL_QU_INDEX_DEFINITION = 8;
    public static final int SQL_QU_PRIVILEGE_DEFINITION = 16;
    public static final short SQL_QUOTED_IDENTIFIER_CASE = 93;
    public static final short SQL_SPECIAL_CHARACTERS = 94;
    public static final short SQL_SUBQUERIES = 95;
    public static final int SQL_SQ_COMPARISON = 1;
    public static final int SQL_SQ_EXISTS = 2;
    public static final int SQL_SQ_IN = 4;
    public static final int SQL_SQ_QUANTIFIED = 8;
    public static final int SQL_SQ_CORRELATED_SUBQUERIES = 16;
    public static final short SQL_UNION = 96;
    public static final int SQL_U_UNION = 1;
    public static final int SQL_U_UNION_ALL = 2;
    public static final short SQL_MAX_COLUMNS_IN_GROUP_BY = 97;
    public static final short SQL_MAX_COLUMNS_IN_INDEX = 98;
    public static final short SQL_MAX_COLUMNS_IN_ORDER_BY = 99;
    public static final short SQL_MAX_COLUMNS_IN_SELECT = 100;
    public static final short SQL_MAX_COLUMNS_IN_TABLE = 101;
    public static final short SQL_MAX_INDEX_SIZE = 102;
    public static final short SQL_MAX_ROW_SIZE_INCLUDES_LONG = 103;
    public static final short SQL_MAX_ROW_SIZE = 104;
    public static final short SQL_MAX_STATEMENT_LEN = 105;
    public static final short SQL_MAX_TABLES_IN_SELECT = 106;
    public static final short SQL_MAX_USER_NAME_LEN = 107;
    public static final short SQL_MAX_CHAR_LITERAL_LEN = 108;
    public static final short SQL_MAX_BINARY_LITERAL_LEN = 112;
    public static final short SQL_LIKE_ESCAPE_CLAUSE = 113;
    public static final short SQL_QUALIFIER_LOCATION = 114;
    public static final short SQL_QL_START = 1;
    public static final short SQL_QL_END = 2;
    public static final short SQL_COLUMN_NAME = 1;
    public static final short SQL_COLUMN_TYPE = 2;
    public static final short SQL_COLUMN_LENGTH = 3;
    public static final short SQL_COLUMN_PRECISION = 4;
    public static final short SQL_COLUMN_SCALE = 5;
    public static final short SQL_COLUMN_DISPLAY_SIZE = 6;
    public static final short SQL_COLUMN_NULLABLE = 7;
    public static final short SQL_NO_NULLS = 0;
    public static final short SQL_NULLABLE = 1;
    public static final short SQL_INDEX_UNIQUE = 0;
    public static final short SQL_INDEX_ALL = 1;
    public static final short SQL_QUICK = 0;
    public static final short SQL_ENSURE = 1;
    public static final short SQL_COLUMN_UNSIGNED = 8;
    public static final short SQL_COLUMN_MONEY = 9;
    public static final short SQL_COLUMN_UPDATABLE = 10;
    public static final short SQL_ATTR_READONLY = 0;
    public static final short SQL_ATTR_WRITE = 1;
    public static final short SQL_ATTR_READWRITE_UNKNOWN = 2;
    public static final short SQL_COLUMN_AUTO_INCREMENT = 11;
    public static final short SQL_COLUMN_CASE_SENSITIVE = 12;
    public static final short SQL_COLUMN_SEARCHABLE = 13;
    public static final short SQL_UNSEARCHABLE = 0;
    public static final short SQL_SEARCHABLE = 3;
    public static final short SQL_COLUMN_TYPE_NAME = 14;
    public static final short SQL_COLUMN_TABLE_NAME = 15;
    public static final short SQL_COLUMN_OWNER_NAME = 16;
    public static final short SQL_COLUMN_QUALIFIER_NAME = 17;
    public static final short SQL_COLUMN_LABEL = 18;
    public static final short SQL_QUERY_TIMEOUT = 0;
    public static final short SQL_MAX_ROWS = 1;
    public static final short SQL_NOSCAN = 2;
    public static final int SQL_NOSCAN_OFF = 0;
    public static final int SQL_NOSCAN_ON = 1;
    public static final short SQL_MAX_LENGTH = 3;
    public static final short SQL_CONCURRENCY = 7;
    public static final int SQL_CONCUR_READ_ONLY = 1;
    public static final int SQL_CONCUR_LOCK = 2;
    public static final int SQL_CONCUR_ROWVER = 3;
    public static final int SQL_CONCUR_VALUES = 4;
    public static final short SQL_GET_BOOKMARK = 13;
    public static final short SQL_ROW_NUMBER = 14;
    public static final short SQL_BEST_ROWID = 1;
    public static final short SQL_ROWVER = 2;
    public static final short SQL_ALL_TYPES = 0;
    public static final short SQL_COMMIT = 0;
    public static final short SQL_ROLLBACK = 1;
    public static final short SQL_PARAM_TYPE_UNKNOWN = 0;
    public static final short SQL_PARAM_INPUT = 1;
    public static final short SQL_PARAM_INPUT_OUTPUT = 2;
    public static final short SQL_RESULT_COL = 3;
    public static final short SQL_PARAM_OUTPUT = 4;
    public static final short SQL_RETURN_VALUE = 5;
}
