/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import sun.io.*;

public class PicoUtil {
   public static String BytesToChars(String s, byte abyte0[])
      throws UnsupportedEncodingException {
      String s1 = new String();
      char ac[] = new char[PicoLimits.DEFAULT_BUFFER_LENGTH];
      int i = PicoLimits.DEFAULT_BUFFER_LENGTH;
      byte abyte1[] = new byte[i];
      int j = 0;
      ByteToCharConverter btcc = ByteToCharConverter.getConverter(s);
      char ac1[] = {
         '?'
      };
      btcc.setSubstitutionMode(true);
      btcc.setSubstitutionChars(ac1);
      btcc.reset();
      for(int k = 0; k < abyte0.length - 1;) {
         for (int l = 0;
              (k <= abyte0.length - 1)&(l < PicoLimits.DEFAULT_BUFFER_LENGTH);
              l++) {
            abyte1[l] = abyte0[k];
            i = l;
            k++;
         }

         try {
            btcc.convert(abyte1, j, i + 1, ac, 0,
                                            PicoLimits.DEFAULT_BUFFER_LENGTH);
            j = 0;
         } catch(MalformedInputException ex) {
            j += btcc.getBadInputLength();
         } catch(ConversionBufferFullException ex) {
            System.out.println("Buffer full exx");
            j = btcc.nextByteIndex();
         } catch(UnknownCharacterException unknowncharacterexception) {
            System.out.println(unknowncharacterexception);
            ac[j] = '?';
            j = btcc.getBadInputLength();
         } finally {
            String s2 = new String(ac, 0, btcc.nextCharIndex());
            s1 = s1 + s2;
         }
      }

      char ac2[] = s1.toCharArray();
      boolean flag = true;
      int i1;
      for(i1 = 0; flag; i1++) {
         byte byte0 = (byte)ac2[i1];
         if(byte0 == 0)
            flag = false;
      }

      char ac3[] = new char[i1 - 1];
      System.arraycopy(ac2, 0, ac3, 0, i1 - 1);
      s1 = new String(ac3);
      return s1;
   }

   public static byte[] CharsToBytes(String s, char ac[])
                            throws UnsupportedEncodingException {
      byte abyte0[] = new byte[0];
      int c = PicoLimits.DEFAULT_BUFFER_LENGTH * 3;
      byte abyte1[] = new byte[c];
      char ac1[] = new char[PicoLimits.DEFAULT_BUFFER_LENGTH];
      int j = 0;
      CharToByteConverter ctbc = CharToByteConverter.getConverter(s);
      ctbc.reset();
      int k = 0;
      boolean flag = false;
      for(boolean flag1 = false; !flag1;)
      {
         if(ac.length - k < PicoLimits.DEFAULT_BUFFER_LENGTH)
            flag1 = true;
         int l;
         for(l = 0; (k < ac.length)&(l<PicoLimits.DEFAULT_BUFFER_LENGTH);l++){
            ac1[l] = ac[k];
            k++;
         }

         int i = l;
         if(flag1) {
            ac1[l] = '\0';
            i++;
         }
         try {
            ctbc.convert(ac1, j, i, abyte1, 0, c);
            j = 0;
         } catch(MalformedInputException ex) {
            j += ctbc.getBadInputLength();
         } catch(ConversionBufferFullException ex) {
            j = ctbc.nextCharIndex();
         } catch(UnknownCharacterException ex) {
            System.out.println(ex);
            abyte1[j] = 63;
            j = ctbc.getBadInputLength();
         } finally {
            byte abyte2[] = new byte[abyte0.length + ctbc.nextCharIndex()];
            System.arraycopy(abyte0, 0, abyte2, 0, abyte0.length);
            System.arraycopy(abyte1, 0, abyte2, abyte0.length,
                                                         ctbc.nextCharIndex());
            abyte0 = new byte[abyte2.length];
            System.arraycopy(abyte2, 0, abyte0, 0, abyte2.length);
         }
      }

      return abyte0;
   }

   protected static void dumpByte(byte abyte0[], int i) {
      trace("Dump (" + i + " bytes):");
      for(int j = 0; j * 16 < i; j++) {
         String s = toHex(j * 16);
         trace(" " + hexPad(s, 8) + "  ", false);
         String s2 = "";
         for(int k = 0; k < 16; k++) {
            int l = j * 16 + k;
            String s1;
            if(l >= i) {
               s1 = "  ";
               s2 = s2 + " ";
            } else {
               s1 = toHex(abyte0[l]);
               s1 = hexPad(s1, 2);
               if(abyte0[l] < 32 || abyte0[l] > 128)
                  s2 = s2 + ".";
               else
                  s2 = s2 + new String(abyte0, l, 1);
            }
            trace(s1 + " ", false);
         }
         trace("   " + s2);
      }

   }

   public static String hexPad(String s, int i) {
      if(!s.startsWith("0x"))
         return s;
      String s1 = s.substring(2);
      int j = s1.length();
      if(j > i)
         s1 = s1.substring(j - i);
      else if(j < i) {
         String s2 = "0000000000000000";
         String s3 = s2.substring(0, i - j) + s1;
         s1 = s3;
      }
      s1 = s1.toUpperCase();
      return s1;
   }

   public static int hexPairToInt(String s) throws NumberFormatException {
      String s1 = "0123456789ABCDEF";
      String s2 = s.toUpperCase();
      int i = 0;
      boolean flag = false;
      int k = s2.length();
      if(k > 2)
         k = 2;
      for(int l = 0; l < k; l++) {
         int j = s1.indexOf(s2.substring(l, l + 1));
         if(j < 0)
            throw new NumberFormatException();
         if(l == 0)
            j *= 16;
         i += j;
      }
      return i;
   }

   public static byte[] hexStringToByteArray(String s)
      throws NumberFormatException {
      int i = s.length();
      int j = (i + 1) / 2;
      byte abyte0[] = new byte[j];
      for(int k = 0; k < j; k++)
         abyte0[k] = (byte)hexPairToInt(s.substring(k * 2, (k + 1) * 2));

      return abyte0;
   }

   protected static boolean isTracing() {
      return DriverManager.getLogWriter() != null;
   }

   public static String toHex(int i) {
      char ac[] = new char[8];
      String s = "0123456789ABCDEF";
      for(int j = 0; j < 4; j++) {
         byte byte0 = (byte)(i & 0xff);
         ac[6 - j * 2] = s.charAt(byte0 >> 4 & 0xf);
         ac[7 - j * 2] = s.charAt(byte0 & 0xf);
         i >>= 8;
      }
      return "0x" + new String(ac);
   }

   protected static void trace(String s) {
      PrintWriter pw = DriverManager.getLogWriter();
      if (pw != null)
         pw.println(s);
   }

   protected static void trace(String s, boolean flag) {
      if(flag)
         trace(s);
      PrintWriter pw = DriverManager.getLogWriter();
      if (pw != null)
         pw.print(s);
   }
}

