/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picocpp - basic objects library for picoSQL 

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef pmemman_h
# define pmemman_h  "$Id: pmemman.h 1.2 96/09/16 15:46:27 picoSoft Exp Locker: ROOT_DOS $"
# include "pbool.h"
# include "pobject.h"

class PMemManObj : public PObject {
   PCLASS (PMemManObj,PObject)
   void init(PBool lock);
   PBool IsLocked;
   char * data;
   unsigned long size;
   char * gets();
public:
   PMemManObj (PMemManObj &);
   PMemManObj (unsigned long, int lock = 0, char ini = -1);
   ~PMemManObj ();
   void Alloc(unsigned long n);
   void Unlock();
   operator char*() { return gets(); }
   PMemManObj & operator=(PMemManObj &);
   PBool operator==(PMemManObj &);
   unsigned long sizeOf() { return size; }
};

# endif /* memman_h */
