/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef except_h
#define except_h "$Id: except.h,v 1.1 1999/06/03 11:41:16 picoSoft Exp $"

# include "corba.h"

typedef enum tErrorCode {
   ErrorCode_NO_ERROR = 0,
   ErrorCode_NOT_INIT,
   ErrorCode_NO_METHOD_FOUND,
   ErrorCode_MISSING_PARAM,
   ErrorCode_INVALID_HEADER,
   ErrorCode_COMM_ERROR,
   ErrorCode_EXC_RESPONSE,
   ErrorCode_GENERAL_ERROR
} ErrorCode;

typedef struct tException {
   ErrorCode code;
   char *description;
   char *file;
   int line;
   CORBA_Boolean status;
} Exception;

Exception * Exception_new();
void Exception_delete(Exception *This);

void Exception_setFull (Exception *This,ErrorCode cod,
                        char *des,char *fil,int lin);
CORBA_Boolean Exception_isException (Exception *This);
void Exception_print (Exception *This);
void Exception_log (Exception *This);

#define Exception_set(t,c,d) Exception_setFull(t,c,d,__FILE__,__LINE__)
#define Exception_isException(t) (t->status)
#define Exception_reset(t) Exception_delete(t),t=Exception_new()

# endif
