/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifdef WIN32
# include <io.h>
# else
# include <unistd.h>
# endif
# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>
# include <stdarg.h>
# include <string.h>
# include "log.h"
static char rcsid[] = "$Id: log.c,v 1.1 1999/06/03 11:42:53 picoSoft Exp $";
static char rcsidh[] = log_h;

int logFile = -1;

void
_pI__setLogFile (const char * fileName)
{
   if (logFile >= 0)
      close (logFile);
   logFile = open (fileName, O_WRONLY|O_CREAT|O_TRUNC, 0666);
}

void
_pI__printLoc (const char * file, int line)
{
   if (logFile >= 0) {
      char intBuffer[256];
      sprintf (intBuffer, "%s:%d,", file, line);
      write (logFile, intBuffer, strlen(intBuffer));
   }
}

void
_pI__printLog (const char * p, ...)
{
   va_list a;
   char buffer[256];
   char *intBuffer = buffer;
   if (strlen (p) > 128)
      intBuffer = malloc (strlen(p) + 128);
   if (logFile >= 0) {
      va_start(a, p);
      vsprintf(intBuffer, p, a);
# ifdef WINDOWS
      strcat(intBuffer, "\r\n");
# else
      strcat(intBuffer, "\n");
# endif
      write (logFile, intBuffer, strlen(intBuffer));
   }
   if (intBuffer != buffer)
      free (intBuffer);
}

