/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef message_h
#define message_h "$Id: message.h,v 1.1 1999/06/03 11:42:53 picoSoft Exp $"

# include "except.h"

#define Message_DEFAULT_SIZE 1430

typedef struct tMessage {
   CORBA_Octet *phisicBuffer;
   CORBA_Octet *logicBuffer;
   unsigned int lenBuffer;
   unsigned int unusedSpace;
   CORBA_Octet *currPnt;
   CORBA_Boolean msgByteOrder; /* True = LittleEndian, False = BigEndian */
   CORBA_Boolean myByteOrder; /* This machine byteOrder */
} Message;

Message *Message_new ();
void Message_delete (Message *This);
CORBA_Boolean Message_grow (Message *This, int incr);
CORBA_Octet *Message_skipBytes (Message *This, unsigned int nBytes);

CORBA_Boolean Message_putByte (Message *This, unsigned char c);
CORBA_Boolean Message_putBoolean (Message *This, CORBA_Boolean c);
CORBA_Boolean Message_putShort (Message *This, CORBA_Short c);
CORBA_Boolean Message_putLong (Message *This, CORBA_Long c);
CORBA_Boolean Message_putString (Message *This, CORBA_String c);
CORBA_Boolean Message_putPrincipal (Message *This, CORBA_Principal *c);

/* Assume the floating point number are in IEEE format */
CORBA_Boolean Message_putDouble (Message *This, CORBA_Double c);
CORBA_Boolean Message_putFloat (Message *This, CORBA_Float c);

#define Message_putChar(t,c) Message_putByte(t,(unsigned char)c)
#define Message_putOctet(t,c) Message_putByte(t,(unsigned char)c)

#define Message_putUShort(t,c) Message_putShort(t,(CORBA_Short)c)
#define Message_putULong(t,c) Message_putLong(t,(CORBA_Long)c)

CORBA_Boolean Message_getByte (Message *This, unsigned char *c);
CORBA_Boolean Message_getBoolean (Message *This, CORBA_Boolean *c);
CORBA_Boolean Message_getShort (Message *This, CORBA_Short *c);
CORBA_Boolean Message_getLong (Message *This, CORBA_Long *c);
CORBA_Boolean Message_getString (Message *This, CORBA_String *c,
                                 CORBA_Boolean autoAlloc);
CORBA_Boolean Message_getPrincipal (Message *This, CORBA_Principal **c,
                                    CORBA_Boolean autoAlloc);

/* Assume the floating point number are in IEEE format */
CORBA_Boolean Message_getDouble (Message *This, CORBA_Double *c);

#define Message_getFloat(t,c) Message_getLong(t,(CORBA_Long *) c)

#define Message_getChar(t,c) Message_getByte(t,(unsigned char *)c)
#define Message_getOctet(t,c) Message_getByte(t,(unsigned char *)c)

#define Message_getUShort(t,c) Message_getShort(t,(CORBA_Short *)c)
#define Message_getULong(t,c) Message_getLong(t,(CORBA_Long *)c)

#define Message_getSize(This) (This->currPnt - This->logicBuffer)

unsigned char * Message_getBuffer (Message *This, unsigned int reqLen,
                                   CORBA_Boolean byteOrd);
CORBA_Boolean Message_encode (Message *This, Exception *ex,
                              const CORBA_TCKindDesc *k, const void *data);
CORBA_Boolean Message_decode (Message *This, Exception *ex,
                              const CORBA_TCKindDesc *k,
                              void **data, CORBA_Boolean autoAlloc);

#endif
