/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef picoisam_h
# define picoisam_h "$Id: picoisam.h,v 1.6 2002/05/06 11:27:43 picoSoft Exp $"

extern int pIserrno;             /* isam error return code       */
extern int pIserrio;             /* system call error code       */
extern UINT4 pIsrecnum;          /* record number of last call   */
extern char pIsstat1;            /* cobol status characters      */
extern char pIsstat2;

int ISAM_API pIsbuild (char * , int , struct keydesc *, int);
int ISAM_API pIswrite (int, char *);
int ISAM_API pIswrcurr (int, char *);
int ISAM_API pIsreplace (int, char *);
int ISAM_API pIsrewrite (int, char *);
int ISAM_API pIsrewcurr (int, char *);
int ISAM_API pIsrewrec (int, long, char *);
int ISAM_API pIsstart (int, struct keydesc * , int , char *, int);
int ISAM_API pIsread (int, char * , int);
int ISAM_API pIsopen (char * , int);
int ISAM_API pIsclose (int);
int ISAM_API pIsdelcurr (int);
int ISAM_API pIsdelete (int, char *);
int ISAM_API pIsdelrec (int, long);
int ISAM_API pIsaddindex (int, struct keydesc *);
int ISAM_API pIsdelindex (int , struct keydesc *);
int ISAM_API pIsindexinfo (int , void *, int);
int ISAM_API pIserase (char *);
int ISAM_API pIsrename (char *, char *);
int ISAM_API pIslock (int);
int ISAM_API pIsunlock (int);
int ISAM_API pIsrelease (int);
#ifdef AUDIT_TRAIL
int ISAM_API pIsaudit (int, char * , int);
#endif
#ifdef TRANSACTION
int ISAM_API pIslogopen (char *);
int ISAM_API pIslogclose ();
int ISAM_API pIsbegin ();
int ISAM_API pIscommit ();
int ISAM_API pIsrollback ();
int ISAM_API pIsrecover ();
#endif

/*
 * picoIsam extended function for DLL
 */

UINT4 ISAM_API pIsGetRecnum(void);
void  ISAM_API pIsSetRecnum(UINT4);
int   ISAM_API pIsGetErrno(void);
int   ISAM_API pIsGetVersion(int);
int pIsbuildNodeSize (char * filename, int recordlength, struct keydesc *keyd,
                      int mode, int headersize, int nodesize);
int pIsrebuild (int isfd);
int pIslockWait (int isfd);
int pIswriteLock (int, char *);

#endif
