/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSqlNet - picoSQL client library

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static char rcsid[] = "$Id: catalog.cpp 4.0 1998/10/27 16:19:54 picoSoft Exp $";
# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
extern "C" {
# include "sqltype.h"
}
# endif
# include <stdio.h>
# include "sqlhndls.h"
# include "dberror.h"
extern "C" {


//  Have DBMS set up result set of Columns.

RETCODE SQL_API SQLColumns(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{ 
   RETCODE Return = SQL_SUCCESS;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[10];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName) || 
            notOk (szColumnName,     cbColumnName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      return SQL_ERROR;
   }
   DelError(0,0,myHstmt);

   argv[0] = &Return;
   argv[1] = &myHstmt->srvHstmt;
   argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
   argv[3] = &cbTableQualifier;
   argv[4] = toCorbaString (szTableOwner, cbTableOwner);
   argv[5] = &cbTableOwner;
   argv[6] = toCorbaString (szTableName, cbTableName);
   argv[7] = &cbTableName;
   argv[8] = toCorbaString (szColumnName, cbColumnName);
   argv[9] = &cbColumnName;
   
   Exception *ex = Exception_new();
   if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLColumns",argv)) {
      char stat[6];
      sprintf (stat,"08%03d", ex->code);
      AddError (0, 0, myHstmt, stat, ex->code, ex->description);
      Exception_log(ex);
   }
   if (argv[2] != szTableQualifier)
      delete (char *) argv[2];
   if (argv[4] != szTableOwner)
      delete (char *) argv[4];
   if (argv[6] != szTableName)
      delete (char *) argv[6];
   if (argv[8] != szColumnName)
      delete (char *) argv[8];
   Exception_delete (ex);
   return Return;
}


//  Have DBMS set up result set of Tables.

RETCODE SQL_API SQLTables(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szTableType,
    SWORD     cbTableType)
{ 
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[10];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName) || 
            notOk (szTableType,      cbTableType)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      return SQL_ERROR;
   }
   DelError(0,0,myHstmt);

   argv[0] = &Return;
   argv[1] = &myHstmt->srvHstmt;
   argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
   argv[3] = &cbTableQualifier;
   argv[4] = toCorbaString (szTableOwner, cbTableOwner);
   argv[5] = &cbTableOwner;
   argv[6] = toCorbaString (szTableName, cbTableName);
   argv[7] = &cbTableName;
   argv[8] = toCorbaString (szTableType, cbTableType);
   argv[9] = &cbTableType;
   
   Exception *ex = Exception_new();
   if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLTables",argv)) {
      char stat[6];
      sprintf (stat,"08%03d", ex->code);
      AddError (0, 0, myHstmt, stat, ex->code, ex->description);
      Exception_log(ex);
   }
   if (argv[2] != szTableQualifier)
      delete (char *) argv[2];
   if (argv[4] != szTableOwner)
      delete (char *) argv[4];
   if (argv[6] != szTableName)
      delete (char *) argv[6];
   if (argv[8] != szTableType)
      delete (char *) argv[8];
   Exception_delete (ex);
   return Return;
}


//  Have DBMS set up result set of Statistics.


RETCODE SQL_API SQLStatistics(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UWORD     fUnique,
    UWORD     fAccuracy)    
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[10];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else if (fUnique != SQL_INDEX_UNIQUE && fUnique != SQL_INDEX_ALL) {
      AddError(0, 0, myHstmt, "S1100", 0, "Uniqueness option type out of range");
      Return = SQL_ERROR;
   } else if (fAccuracy != SQL_ENSURE && fAccuracy != SQL_QUICK) {
      AddError(0, 0, myHstmt, "S1101", 0, "Accuracy option type out of range");
      Return = SQL_ERROR;
   } else {
       DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
      argv[3] = &cbTableQualifier;
      argv[4] = toCorbaString (szTableOwner, cbTableOwner);
      argv[5] = &cbTableOwner;
      argv[6] = toCorbaString (szTableName, cbTableName);
      argv[7] = &cbTableName;
      argv[8] = &fUnique;
      argv[9] = &fAccuracy;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLStatistics",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szTableQualifier)
         delete (char *) argv[2];
      if (argv[4] != szTableOwner)
         delete (char *) argv[4];
      if (argv[6] != szTableName)
         delete (char *) argv[6];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of SpecialColumns.

RETCODE SQL_API SQLSpecialColumns(
    HSTMT     hstmt,
    UWORD     fColType,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UWORD     fScope,
    UWORD     fNullable)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[11];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
       DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = &fColType;
      argv[3] = toCorbaString (szTableQualifier, cbTableQualifier);
      argv[4] = &cbTableQualifier;
      argv[5] = toCorbaString (szTableOwner, cbTableOwner);
      argv[6] = &cbTableOwner;
      argv[7] = toCorbaString (szTableName, cbTableName);
      argv[8] = &cbTableName;
      argv[9] = &fScope;
      argv[10] = &fNullable;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLSpecialColumns",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[3] != szTableQualifier)
         delete (char *) argv[3];
      if (argv[5] != szTableOwner)
         delete (char *) argv[5];
      if (argv[7] != szTableName)
         delete (char *) argv[7];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of TablePrivileges.

RETCODE SQL_API SQLTablePrivileges(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[8];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
      argv[3] = &cbTableQualifier;
      argv[4] = toCorbaString (szTableOwner, cbTableOwner);
      argv[5] = &cbTableOwner;
      argv[6] = toCorbaString (szTableName, cbTableName);
      argv[7] = &cbTableName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLTablePrivileges",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szTableQualifier)
         delete (char *) argv[2];
      if (argv[4] != szTableOwner)
         delete (char *) argv[4];
      if (argv[6] != szTableName)
         delete (char *) argv[6];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of ColumnPrivileges.

RETCODE SQL_API SQLColumnPrivileges(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[10];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName) || 
            notOk (szColumnName,     cbColumnName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
      argv[3] = &cbTableQualifier;
      argv[4] = toCorbaString (szTableOwner, cbTableOwner);
      argv[5] = &cbTableOwner;
      argv[6] = toCorbaString (szTableName, cbTableName);
      argv[7] = &cbTableName;
      argv[8] = toCorbaString (szColumnName, cbColumnName);
      argv[9] = &cbColumnName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLColumnPrivileges",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szTableQualifier)
         delete (char *) argv[2];
      if (argv[4] != szTableOwner)
         delete (char *) argv[4];
      if (argv[6] != szTableName)
         delete (char *) argv[6];
      if (argv[8] != szColumnName)
         delete (char *) argv[8];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of PrimaryKeys.

RETCODE SQL_API SQLPrimaryKeys(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[8];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) || 
            notOk (szTableName,      cbTableName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szTableQualifier, cbTableQualifier);
      argv[3] = &cbTableQualifier;
      argv[4] = toCorbaString (szTableOwner, cbTableOwner);
      argv[5] = &cbTableOwner;
      argv[6] = toCorbaString (szTableName, cbTableName);
      argv[7] = &cbTableName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLPrimaryKeys",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szTableQualifier)
         delete (char *) argv[2];
      if (argv[4] != szTableOwner)
         delete (char *) argv[4];
      if (argv[6] != szTableName)
         delete (char *) argv[6];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of ForeignKeys.

RETCODE SQL_API SQLForeignKeys(
    HSTMT     hstmt,
    UCHAR FAR *szPkTableQualifier,
    SWORD     cbPkTableQualifier,
    UCHAR FAR *szPkTableOwner,
    SWORD     cbPkTableOwner,
    UCHAR FAR *szPkTableName,
    SWORD     cbPkTableName,
    UCHAR FAR *szFkTableQualifier,
    SWORD     cbFkTableQualifier,
    UCHAR FAR *szFkTableOwner,
    SWORD     cbFkTableOwner,
    UCHAR FAR *szFkTableName,
    SWORD     cbFkTableName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[14];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szPkTableQualifier, cbPkTableQualifier) ||
            notOk (szPkTableOwner,     cbPkTableOwner) || 
            notOk (szPkTableName,      cbPkTableName) ||
            notOk (szFkTableQualifier, cbFkTableQualifier) ||
            notOk (szFkTableOwner,     cbFkTableOwner) || 
            notOk (szFkTableName,      cbFkTableName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szPkTableQualifier, cbPkTableQualifier);
      argv[3] = &cbPkTableQualifier;
      argv[4] = toCorbaString (szPkTableOwner, cbPkTableOwner);
      argv[5] = &cbPkTableOwner;
      argv[6] = toCorbaString (szPkTableName, cbPkTableName);
      argv[7] = &cbPkTableName;
      argv[8] = toCorbaString (szFkTableQualifier, cbFkTableQualifier);
      argv[9] = &cbFkTableQualifier;
      argv[10] = toCorbaString (szFkTableOwner, cbFkTableOwner);
      argv[11] = &cbFkTableOwner;
      argv[12] = toCorbaString (szFkTableName, cbFkTableName);
      argv[13] = &cbFkTableName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLForeignKeys",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szPkTableQualifier)
         delete (char *) argv[2];
      if (argv[4] != szPkTableOwner)
         delete (char *) argv[4];
      if (argv[6] != szPkTableName)
         delete (char *) argv[6];
      if (argv[8] != szFkTableQualifier)
         delete (char *) argv[8];
      if (argv[10] != szFkTableOwner)
         delete (char *) argv[10];
      if (argv[12] != szFkTableName)
         delete (char *) argv[12];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of Procedures.

RETCODE SQL_API SQLProcedures(
    HSTMT     hstmt,
    UCHAR FAR *szProcQualifier,
    SWORD     cbProcQualifier,
    UCHAR FAR *szProcOwner,
    SWORD     cbProcOwner,
    UCHAR FAR *szProcName,
    SWORD     cbProcName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[8];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szProcQualifier, cbProcQualifier) ||
            notOk (szProcOwner,     cbProcOwner) || 
            notOk (szProcName,      cbProcName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szProcQualifier, cbProcQualifier);
      argv[3] = &cbProcQualifier;
      argv[4] = toCorbaString (szProcOwner, cbProcOwner);
      argv[5] = &cbProcOwner;
      argv[6] = toCorbaString (szProcName, cbProcName);
      argv[7] = &cbProcName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLProcedures",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szProcQualifier)
         delete (char *) argv[2];
      if (argv[4] != szProcOwner)
         delete (char *) argv[4];
      if (argv[6] != szProcName)
         delete (char *) argv[6];
      Exception_delete (ex);
   }

   return Return;
}

//  Have DBMS set up result set of ProcedureColumns.

RETCODE SQL_API SQLProcedureColumns(
    HSTMT     hstmt,
    UCHAR FAR *szProcQualifier,
    SWORD     cbProcQualifier,
    UCHAR FAR *szProcOwner,
    SWORD     cbProcOwner,
    UCHAR FAR *szProcName,
    SWORD     cbProcName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[10];

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;
   else if (notOk (szProcQualifier, cbProcQualifier) ||
            notOk (szProcOwner,     cbProcOwner) || 
            notOk (szProcName,      cbProcName) || 
            notOk (szColumnName,    cbColumnName)) {
      AddError(0, 0, myHstmt, "S1090", 0, "Invalid string or buffer length");
      Return = SQL_ERROR;
   } else {
      DelError(0,0,myHstmt);
      argv[0] = &Return;
      argv[1] = &myHstmt->srvHstmt;
      argv[2] = toCorbaString (szProcQualifier, cbProcQualifier);
      argv[3] = &cbProcQualifier;
      argv[4] = toCorbaString (szProcOwner, cbProcOwner);
      argv[5] = &cbProcOwner;
      argv[6] = toCorbaString (szProcName, cbProcName);
      argv[7] = &cbProcName;
      argv[8] = toCorbaString (szColumnName, cbColumnName);
      argv[9] = &cbColumnName;

      Exception *ex = Exception_new();
      if (!Invoke_invoke (myHstmt->hdbc->call,ex,"SQLProcedureColumns",argv)) {
         char stat[6];
         sprintf (stat,"08%03d", ex->code);
         AddError (0, 0, myHstmt, stat, ex->code, ex->description);
         Exception_log(ex);
      }
      if (argv[2] != szProcQualifier)
         delete (char *) argv[2];
      if (argv[4] != szProcOwner)
         delete (char *) argv[4];
      if (argv[6] != szProcName)
         delete (char *) argv[6];
      if (argv[8] != szColumnName)
         delete (char *) argv[8];
      Exception_delete (ex);
   }

   return Return;
}

};
