/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSqlNet - picoSQL client library

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static char rcsid[] = "$Id: dberror.cpp 4.0 1998/10/27 16:20:26 picoSoft Exp $";
# include "dberror.h"
extern "C" {
# ifdef MSDOS
# define strcpy lstrcpy
# define strncpy lstrcpyn
# define strlen lstrlen
# else
# include <string.h>
# endif
};
static DBErrorList Errors;

void
AddError (ClntHenv *henv, ClntHdbc *hdbc, ClntHstmt *hstmt,
          const PString &sqlState, long nativeError, const PString & errorMsg)
{
   PString mess = "[picoSoft][ODBC picoSQL driver]";
   if (errorMsg[0] == '[')
      Errors.AddItem (new DBError (henv, hdbc, hstmt,
                      sqlState, nativeError, errorMsg));
   else
      Errors.AddItem (new DBError (henv, hdbc, hstmt,
                      sqlState, nativeError, mess + errorMsg));
}

RETCODE
GetError (ClntHenv *he, ClntHdbc *hd, ClntHstmt *hs,
          unsigned char *outSqlState, long &outNativeError, unsigned char * outErrorMsg, 
          int cbErrorMsgMax, short &pcbErrorMsg)
{
   DBError *db;
   RETCODE Return = SQL_NO_DATA_FOUND;

   if (outSqlState != 0)
      strcpy((char*)outSqlState, "00000");
   if (&outNativeError != 0)
      outNativeError = 0;
   if (outErrorMsg != 0)
      outErrorMsg[0] = 0;
   if (&pcbErrorMsg != 0)
      pcbErrorMsg = 0;

   if (hs != 0) {
      he = 0;
      hd = 0;
   } else if (hd != 0)
      he = 0;
   for (db = Errors.GetLast(); db != 0; db = Errors.GetPrevious())
      if ((he == 0 || db->henv == he) &&
          (hd == 0 || db->hdbc == hd) &&
          (hs == 0|| db->hstmt== hs)) {
        Return = SQL_SUCCESS;
        if (outSqlState != 0)
           strcpy((char*)outSqlState, db->sqlState.gets());
        if (&outNativeError != 0)
           outNativeError = db->nativeError;
        if (outErrorMsg != 0)
           if (db->errorMsg.size() < cbErrorMsgMax) {
              strcpy((char*)outErrorMsg, db->errorMsg.gets());
              if (&pcbErrorMsg != 0)
                 pcbErrorMsg = (short) db->errorMsg.size();
           } else {
              strncpy((char*)outErrorMsg, db->errorMsg.gets(), cbErrorMsgMax - 1); 
              outErrorMsg[cbErrorMsgMax - 1] = 0;
              if (&pcbErrorMsg != 0)
                 pcbErrorMsg = cbErrorMsgMax - 1;
           }
        delete(db);
        Errors.DeleteCurrent();
        break;
      }
   return Return;     
}
void
DelError (ClntHenv *he, ClntHdbc *hd, ClntHstmt *hs)
{
   DBError *db;

   if (hs != 0) {
      he = 0;
      hd = 0;
   } else if (hd != 0)
      he = 0;
   for (db = Errors.GetFirst(); db != 0;)
      if ((he == 0 || db->henv == he) &&
          (hd == 0 || db->hdbc == hd) &&
          (hs == 0|| db->hstmt== hs)) {
         delete(db);
         db = Errors.DeleteCurrent(); 
      } else
         db = Errors.GetNext();
}

/*
RETCODE
LookError (void * hv, DataBase * hd, SqlParser *sp)
{
   DBError *db;
   RETCODE Return = SQL_SUCCESS;

   if (sp != SQL_NULL_HSTMT) {
      hv = SQL_NULL_HENV;
      hd = SQL_NULL_HDBC;
   } else if (hd != SQL_NULL_HDBC)
      hv = SQL_NULL_HENV;
   for (db = Errs.GetFirst(); db != 0; db = Errs.GetNext())
      if ((hv == SQL_NULL_HENV || db->henv == hv) &&
          (hd == SQL_NULL_HDBC || db->hdbc == hd) &&
          (sp == SQL_NULL_HSTMT|| db->hstmt== sp)) {
         if (db->ClassNum == WARNING && Return != SQL_ERROR)
            Return = SQL_SUCCESS_WITH_INFO;
         else {
            Return = SQL_ERROR;
            break;
         }
      }
   return Return;
}
*/
