/*
    token.h

    Copyright (c) 1995, by picoSoft
    ALL RIGHTS RESERVED.

    Revision History:
    -----------------
*/

# ifndef token_h
# define token_h "$Id: token.h 5.1 2000/05/16 14:20:44 picoSoft Exp Marco $"
 
# include "pbool.h"
# include "pstring.h"
# include "plist.h"
# include "piteratr.h"
extern "C" {
# include <stdio.h>
};

typedef enum {
   OPEN_BOOL_PAR = '\x01',
   CLOSE_BOOL_PAR = '\x02',
   _OJ_ = '\x03',    // Operatore fittizio per outer join (il codice deve essere <= 64)
   START_SUBQUERY = '\x04',
   END_SUBQUERY = '\x05',
   UNKNOWN = 256,
   _GE_,
   _LE_,
   _NE_,
   UOK_WORD,
   NUMBER,
   STR_LITERAL,

// Token SQL 
   ABS,
   ACOS,
   ADD,
   ALL,
   ALTER,
   AND,
   AS,
   ASC,
   ASCII,
   ASIN,
   ATAN,
   AVG,
   BETWEEN,
   BLOB_,
   BY,
   CALL,
   CEILING,
   CHAR_,
   CHECK,
   CLOB,
   COLUMN,
   CONCAT,
   CONVERT,
   COS,
   COT,
   COUNT,
   CREATE,
   CURRENT,
   CURRENT_TIMESTAMP,
   CURRENT_TIMESTAMP_28,
   DATE_,
   DAYOFMONTH,
   DEFAULT,
   DELETE_,
   DESC,
   DISTINCT,
   DOUBLE_,
   DROP,
   EXISTS,
   EXP,
   FILLER,
   FLOAT_,
   FLOOR,
   FOR,
   FOREIGN,
   FROM,
   FULL,
   GRANT,
   GROUP,
   HAVING,
   HOUR,
   IN_,
   INDEX,
   INNER,
   INSERT,
   INT_,
   INTEGER,
   INTO,
   IS,
   JOIN,
   KEY,
   LCASE,
   LEFT,
   LENGTH,
   LIKE,
   LIMIT,
   LOCATE,
   LOG,
   LOG10,
   LONGVARCHAR,
   LOWER,
   LTRIM,
   MAX,
   MILLISECOND,
   MIN,
   MINUTE,
   MONTH,
   NOT,
   NULL_,
   NUMERIC,
   OF,
   OFFSET,
   ON,
   OPTION,
   OR,
   ORDER,
   OUTER,
   PRIMARY,
   REAL,
   REFERENCES,
   RENAME,
   REPLACE,
   REVOKE,
   RIGHT,
   ROUND,
   RTRIM,
   SECOND,
   SELECT,
   SERIAL,
   SET,
   SIGN,
   SIN,
   SMALLINT,
   SPACE,
   SQRT,
   SUBSTRING,
   SUM,
   TABLE,
   TAN,
   TIME,
   TIMESTAMP,
   TRUNCATE,
   UCASE,
   UNION,
   UNIQUE,
   UPDATE,
   UPPER,
   VALUES,
   VARCHAR,
   VIEW,
   WHERE,
   WITH,
   YEAR,
//
   NOT_BETWEEN,
   BETWEEN_AND,
   NOT_IN,
   OPEN_IN,
   CLOSE_IN,
   OPEN_BLT,
   CLOSE_BLT,
   OPEN_FUN,
   CLOSE_FUN,
   NOT_LIKE,
   IS_NULL,
   IS_NOT_NULL,
   USER_NAME,
   TO_CHAR,
   TO_DOUBLE,
   NOT_EXISTS,
   CURRENT_TIMESTAMP_NOARG,
//
   CREATE_TABLE,
   DROP_TABLE,
   CREATE_INDEX,
   CREATE_UNIQUE_INDEX,
   DROP_INDEX,
   CREATE_VIEW,
   DROP_VIEW,
   ALTER_TABLE_ADD,
   ALTER_TABLE_DROP,
   ALTER_TABLE_RENAME
} toknum;

class Token : public PObject
{
   PCLASS (Token, PObject)
public:
   PString word;
   toknum token;
   void operator=(Token & k) { word = k.word; token = k.token; }
   Token() {}
   Token(toknum t, const PString &val) { word = val; token = t; }
   Token(toknum t, const char *val) { word = val; token = t; }
   Token(Token &t) { *this = t; }
   ~Token() {}
};

PLIST(Token);
PITERATOR(Token);
# endif
