/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import org.I00acres.isql.swing.FilterEditor;
import org.I00acres.isql.util.ExtensionFactory;
import org.I00acres.isql.util.TableFilter;
import org.I00acres.isql.util.iSQLUtilites;

public final class frmExportWizard
extends JDialog {
    private Object mExportableData;
    private JLabel mTitleLabel = new JLabel(iSQLUtilites.getString("Export_Filter_Select"));
    private JButton mNextButton = new JButton(iSQLUtilites.getString("BATCH_Next_Text"), iSQLUtilites.loadIconResource("Export24"));
    private JButton btnOk = new JButton(iSQLUtilites.getString("Ok"));
    private FilterEditor mFilterEditor = new FilterEditor(1);
    private ActionListener actionHandler = new ActionHandler();
    private Thread exportThread;
    private ProgressMonitor exportProgressMonitor;
    private Frame zOwner = null;
    private NumberFormat pf = NumberFormat.getPercentInstance();

    public frmExportWizard(Frame zParent, Object data) {
        super(zParent, iSQLUtilites.getString("Export_Wizard_Title"), false);
        this.zOwner = zParent;
        this.mExportableData = data;
        this.pf.setMaximumFractionDigits(0);
        this.pf.setMaximumIntegerDigits(3);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, "frmExportWizard::initUI()", true);
            this.dispose();
        }
        ((Component)this).setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(zParent);
    }

    private synchronized void initUI() throws Exception {
        this.setDefaultCloseOperation(2);
        this.mTitleLabel.setFont(this.mTitleLabel.getFont().deriveFont(1, 26.0f));
        this.mTitleLabel.setHorizontalTextPosition(2);
        this.btnOk.setPreferredSize(new Dimension(2 * this.btnOk.getPreferredSize().width, this.btnOk.getPreferredSize().height));
        iSQLUtilites.lockComponentToPerferredSize(this.btnOk);
        this.btnOk.setToolTipText(iSQLUtilites.getString("Close_This_Dialog"));
        JToolBar mToolBar = new JToolBar();
        mToolBar.setOrientation(0);
        mToolBar.setFloatable(false);
        mToolBar.add(this.mTitleLabel);
        mToolBar.add(Box.createHorizontalGlue());
        mToolBar.add(this.mNextButton);
        this.getContentPane().add((Component)mToolBar, "North");
        mToolBar = new JToolBar();
        mToolBar.setFloatable(false);
        mToolBar.add(Box.createHorizontalGlue());
        mToolBar.add(this.btnOk);
        this.getContentPane().add((Component)this.mFilterEditor, "Center");
        this.getContentPane().add((Component)mToolBar, "South");
        this.mFilterEditor.setFilterContent(this.mExportableData);
        this.btnOk.addActionListener(this.actionHandler);
        this.mNextButton.addActionListener(this.actionHandler);
    }

    public void dispose() {
        ExtensionFactory.close();
        super.dispose();
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 205) {
            this.mFilterEditor.setSelectedFilterIndex(this.mFilterEditor.getSelectedFilterIndex());
        }
        super.processWindowEvent(evt);
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src.equals(frmExportWizard.this.mNextButton)) {
                frmExportWizard.this.exportThread = new Thread(new ExportProcess());
                frmExportWizard.this.exportThread.start();
            } else if (src instanceof TableFilter && frmExportWizard.this.exportProgressMonitor != null) {
                if (frmExportWizard.this.exportProgressMonitor.isCanceled()) {
                    frmExportWizard.this.exportThread.interrupt();
                    return;
                }
                frmExportWizard.this.exportProgressMonitor.setProgress(evt.getID());
                if (evt.getActionCommand().trim().length() == 0) {
                    String ps = frmExportWizard.this.pf.format((double)evt.getID() / 100.0);
                    frmExportWizard.this.exportProgressMonitor.setNote(iSQLUtilites.getString("Percent_Complete", ps));
                } else {
                    frmExportWizard.this.exportProgressMonitor.setNote(evt.getActionCommand());
                }
            } else if (src.equals(frmExportWizard.this.btnOk)) {
                frmExportWizard.this.dispose();
            }
        }
    }

    private class ExportProcess
    implements Runnable {
        ExportProcess() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block8: {
                block9: {
                    try {
                        try {
                            TableFilter filter = frmExportWizard.this.mFilterEditor.getCurrentFilter(true);
                            if (filter == null) {
                                JOptionPane.showMessageDialog(frmExportWizard.this, iSQLUtilites.getString("Export_No_Filter_Error"));
                                Object var4_3 = null;
                                frmExportWizard.this.exportProgressMonitor.close();
                                return;
                            }
                            filter.setProgressListener(frmExportWizard.this.actionHandler);
                            frmExportWizard.this.exportProgressMonitor = new ProgressMonitor(frmExportWizard.this, iSQLUtilites.getString("Export_Wizard_Title"), "-", 0, 100);
                            frmExportWizard.this.exportProgressMonitor.setNote(iSQLUtilites.getString("Export_Notice"));
                            frmExportWizard.this.exportProgressMonitor.setMillisToDecideToPopup(0);
                            frmExportWizard.this.exportProgressMonitor.setMillisToPopup(0);
                            if (filter.isFileRequired()) {
                                File f = iSQLUtilites.saveSystemFile(new JFrame());
                                if (f != null) {
                                    frmExportWizard.this.exportProgressMonitor.setProgress(1);
                                    filter.filter(frmExportWizard.this.mExportableData, f);
                                    System.out.println(iSQLUtilites.getString("Export_Finished_Msg"));
                                    break block8;
                                }
                                JOptionPane.showMessageDialog(frmExportWizard.this, iSQLUtilites.getString("Export_Cancelled"));
                                break block9;
                            }
                            frmExportWizard.this.exportProgressMonitor.setProgress(1);
                            filter.filter(frmExportWizard.this.mExportableData, (File)null);
                            break block8;
                        }
                        catch (InterruptedException interruptedException) {
                            JOptionPane.showMessageDialog(frmExportWizard.this, iSQLUtilites.getString("Export_Cancelled"));
                            Object var4_5 = null;
                            frmExportWizard.this.exportProgressMonitor.close();
                            return;
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(frmExportWizard.this, iSQLUtilites.getString("Export_Exception", "" + e));
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        frmExportWizard.this.exportProgressMonitor.close();
                        throw throwable;
                    }
                }
                Object var4_4 = null;
                frmExportWizard.this.exportProgressMonitor.close();
                return;
            }
            Object var4_7 = null;
            frmExportWizard.this.exportProgressMonitor.close();
        }
    }
}

