/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.forms.frmWarningViewer;
import org.I00acres.isql.swing.FilterEditor;
import org.I00acres.isql.swing.TableSelector;
import org.I00acres.isql.swing.WizardPanel;
import org.I00acres.isql.swing.action.iSQLActionConstants;
import org.I00acres.isql.swing.table.ImportMapTableModel;
import org.I00acres.isql.swing.table.iSQLTableModel;
import org.I00acres.isql.util.ExtensionFactory;
import org.I00acres.isql.util.TableFilter;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;
import org.I00acres.lib.sql.ResultSetUtilities;

public final class frmImportWizard
extends JDialog {
    private iSQLConfig config = iSQLConfig.getInstance();
    private GridBagLayout gbl = new GridBagLayout();
    private WizardPanel mContentPanel = new WizardPanel();
    private DatabaseConnection databaseConnection;
    private DataMapPanel dataMapper = null;
    private Thread importThread;
    private DefaultTableModel importedDataModel = new iSQLTableModel();
    private NumberFormat pf = NumberFormat.getPercentInstance();
    private FilterEditor mFilterSelector = new FilterEditor(0);
    private JLabel mTitleLabel = new JLabel(iSQLUtilites.getString("Import_Filter_Select"));
    private JButton btnNext = new JButton(iSQLUtilites.getString("BATCH_Next_Text"), iSQLUtilites.loadIconResource("Forward24"));
    private JButton btnBack = new JButton(iSQLUtilites.getString("BATCH_Prev_Text"), iSQLUtilites.loadIconResource("Back24"));
    private JButton btnCancel = new JButton(iSQLUtilites.getString("Cancel"));
    private ProgressMonitor importProgressMonitor = null;
    private ActionListener actionHandler = new ActionHandler();
    private ChangeListener changeHandler = new ChangeHandler();
    private Frame zOwner = null;

    public frmImportWizard(Frame parent, DatabaseConnection dbc) {
        super(parent, iSQLUtilites.getString("Import_Wizard_Title"), false);
        this.zOwner = parent;
        try {
            this.pf.setMaximumFractionDigits(0);
            this.pf.setMaximumIntegerDigits(3);
            this.databaseConnection = dbc;
            this.dataMapper = new DataMapPanel();
            this.initUI();
        }
        catch (Throwable throwable) {}
        this.mFilterSelector.setSelectedFilterIndex(this.config.getIntProperty("Session.LastTableTool", 0));
        this.pack();
        ((Component)this).setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(parent);
    }

    public void dispose() {
        this.config.setIntProperty("Session.LastTableTool", this.mFilterSelector.getSelectedFilterIndex());
        ExtensionFactory.close();
        super.dispose();
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 205) {
            this.mFilterSelector.setSelectedFilterIndex(this.mFilterSelector.getSelectedFilterIndex());
        }
        super.processWindowEvent(evt);
    }

    private void initUI() {
        this.setDefaultCloseOperation(2);
        this.mContentPanel.add((Component)this.mFilterSelector, "Config");
        this.mContentPanel.add((Component)this.dataMapper, "Map");
        this.mContentPanel.addChangeListener(this.changeHandler);
        this.mContentPanel.showCard("Select");
        this.mTitleLabel.setFont(new Font("Lucinda Sans", 1, 26));
        this.mTitleLabel.setHorizontalTextPosition(2);
        this.btnBack.setVisible(false);
        this.btnNext.addActionListener(this.actionHandler);
        this.btnBack.addActionListener(this.actionHandler);
        this.btnCancel.addActionListener(this.actionHandler);
        this.btnNext.setToolTipText(iSQLUtilites.getString("BATCH_Next_Tip"));
        this.btnBack.setToolTipText(iSQLUtilites.getString("BATCH_Prev_Tip"));
        this.btnCancel.setToolTipText(iSQLUtilites.getString("Close_This_Dialog"));
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(this.mTitleLabel);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnBack);
        tb.add(this.btnNext);
        this.getContentPane().add((Component)tb, "North");
        this.getContentPane().add((Component)this.mContentPanel, "Center");
        tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnCancel);
        this.getContentPane().add((Component)tb, "South");
    }

    private static String getTypeStringForObject(Object o) {
        if (o instanceof Short) {
            return "SMALLINT";
        }
        if (o instanceof Integer) {
            return "INTEGER";
        }
        if (o instanceof Double) {
            return "DOUBLE";
        }
        if (o instanceof Float) {
            return "FLOAT";
        }
        if (o instanceof BigDecimal) {
            return "DECIMAL";
        }
        if (o instanceof Timestamp) {
            return "TIMESTAMP";
        }
        if (o instanceof Time) {
            return "TIME";
        }
        if (o instanceof Date) {
            return "DATE";
        }
        if (o instanceof byte[]) {
            return "LONGVARBINARY";
        }
        return "VARCHAR";
    }

    private class DataMapPanel
    extends JPanel {
        private DefaultTableModel importDataModel = new ImportMapTableModel();
        private JSplitPane contentContainer = new JSplitPane(0);
        private DefaultComboBoxModel columnDataModel = new DefaultComboBoxModel();
        private JComboBox columnTypeSelector;
        private JComboBox columnSelector;
        private JButton btnDelete = new JButton(iSQLUtilites.loadIconResource("RowDelete16"));
        private JCheckBox chkUseBatch = new JCheckBox(iSQLUtilites.getString("Import_Batch_Opt"));
        private JCheckBox chkUseTx = new JCheckBox(iSQLUtilites.getString("Import_Trans_Opt"));
        private TableSelector tableSelector;
        private JTable importMapTable = new JTable(this.importDataModel);
        private JTable importDataTable;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public DataMapPanel() {
            this.importDataTable = new JTable(frmImportWizard.this.importedDataModel);
            try {
                this.initUI();
            }
            catch (Throwable t) {
                iSQLUtilites.HandleException(t, "DataMapPanel()::initUI()", true);
            }
        }

        public void update() {
            this.importDataModel.setRowCount(frmImportWizard.this.importedDataModel.getColumnCount());
            int i = 0;
            while (i < this.importDataModel.getRowCount()) {
                this.importDataModel.setValueAt(frmImportWizard.this.importedDataModel.getColumnName(i), i, 0);
                this.importDataModel.setValueAt(frmImportWizard.this.importedDataModel.getColumnName(i), i, 1);
                this.importDataModel.setValueAt(frmImportWizard.getTypeStringForObject(frmImportWizard.this.importedDataModel.getValueAt(0, i)), i, 2);
                this.importDataModel.setValueAt(Boolean.FALSE, i, 3);
                ++i;
            }
            frmImportWizard.this.changeHandler.stateChanged(new ChangeEvent(this.tableSelector));
        }

        private void loadColumns(String cat, String schema, String tab) {
            this.columnDataModel.removeAllElements();
            try {
                Object[] cols = ResultSetUtilities.getSingleColumn(frmImportWizard.this.databaseConnection.getDatabaseInformation().getColumns(cat, schema, tab, null), "COLUMN_NAME");
                if (cols != null) {
                    int i = 0;
                    while (i < cols.length) {
                        this.columnDataModel.addElement(cols[i]);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {}
        }

        private void initUI() {
            Insets ins = new Insets(1, 1, 1, 1);
            this.tableSelector = new TableSelector(frmImportWizard.this.databaseConnection.getDatabaseInformation(), true);
            this.tableSelector.addChangeListener(frmImportWizard.this.changeHandler);
            this.columnTypeSelector = new JComboBox<String>(DatabaseConnection.getSQLTypes());
            this.columnSelector = new JComboBox(this.columnDataModel);
            this.columnSelector.setEditable(true);
            this.columnSelector.setMaximumRowCount(4);
            this.columnTypeSelector.setLightWeightPopupEnabled(true);
            this.columnTypeSelector.setMaximumRowCount(4);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.importMapTable.setDefaultEditor(clazz, new DefaultCellEditor(this.columnTypeSelector));
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.importMapTable.setDefaultEditor(clazz2, new DefaultCellEditor(this.columnSelector));
            this.importMapTable.getTableHeader().setReorderingAllowed(false);
            this.importDataTable.getTableHeader().setReorderingAllowed(false);
            this.btnDelete.setToolTipText(iSQLActionConstants.CMD_ROWDELE_S_DESC);
            this.btnDelete.addActionListener(frmImportWizard.this.actionHandler);
            this.chkUseTx.setEnabled(frmImportWizard.this.databaseConnection.isTransactionsSupported());
            this.chkUseBatch.setEnabled(frmImportWizard.this.databaseConnection.isBatchSupported());
            this.setLayout(new BorderLayout());
            JPanel PreviewPanel = new JPanel(new BorderLayout());
            PreviewPanel.add((Component)new JScrollPane(this.importDataTable), "Center");
            JToolBar tb = new JToolBar(0);
            tb.setFloatable(false);
            tb.add(new JLabel(iSQLUtilites.getString("Imported_Data_Preview"), iSQLUtilites.loadIconResource("Import16"), 2));
            tb.add(Box.createHorizontalGlue());
            tb.add(this.btnDelete);
            PreviewPanel.add((Component)tb, "North");
            this.contentContainer.setTopComponent(new JScrollPane(this.importMapTable));
            this.contentContainer.setBottomComponent(PreviewPanel);
            JPanel pan = new JPanel(new GridBagLayout());
            this.chkUseBatch.setToolTipText(iSQLUtilites.getString("Import_Batch_Tip"));
            this.chkUseTx.setToolTipText(iSQLUtilites.getString("Import_Trans_Tip"));
            pan.add((Component)this.tableSelector, new GridBagConstraints(0, 0, 2, 2, 1.0, 0.0, 18, 2, ins, 0, 0));
            pan.add((Component)this.chkUseTx, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, ins, 0, 0));
            pan.add((Component)this.chkUseBatch, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, ins, 0, 0));
            this.add((Component)pan, "North");
            this.add((Component)this.contentContainer, "Center");
        }

        private int getSkipCount() {
            int cnt = 0;
            int i = 0;
            while (i < this.importDataModel.getRowCount()) {
                if (((Boolean)this.importDataModel.getValueAt(i, 3)).booleanValue()) {
                    ++cnt;
                }
                ++i;
            }
            return cnt;
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent evt) {
            Object src = evt.getSource();
            if (src == frmImportWizard.this.dataMapper.tableSelector) {
                frmImportWizard.this.dataMapper.loadColumns(frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog(), frmImportWizard.this.dataMapper.tableSelector.getSelectedSchema(), frmImportWizard.this.dataMapper.tableSelector.getSelectedTable());
            } else if (src == frmImportWizard.this.mContentPanel) {
                String card = frmImportWizard.this.mContentPanel.getCurrentCard();
                frmImportWizard.this.btnCancel.setText(iSQLUtilites.getString("Cancel"));
                if (card.equalsIgnoreCase("Map")) {
                    frmImportWizard.this.btnBack.setVisible(true);
                    frmImportWizard.this.mTitleLabel.setText(iSQLUtilites.getString("Import_Map_SQL"));
                } else if (card.equalsIgnoreCase("Config")) {
                    frmImportWizard.this.btnBack.setVisible(false);
                    frmImportWizard.this.dataMapper.contentContainer.setDividerLocation(0.5);
                    frmImportWizard.this.mTitleLabel.setText(iSQLUtilites.getString("Import_Filter_Select"));
                }
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            int res;
            Object src = evt.getSource();
            if (src == frmImportWizard.this.btnCancel) {
                frmImportWizard.this.dispose();
            } else if (src == frmImportWizard.this.btnNext) {
                String card = frmImportWizard.this.mContentPanel.getCurrentCard();
                if (card.equalsIgnoreCase("Config")) {
                    frmImportWizard.this.importThread = new Thread(new ImportProcess(1));
                    frmImportWizard.this.importThread.start();
                } else if (card.equalsIgnoreCase("Map")) {
                    if (frmImportWizard.this.dataMapper.getSkipCount() == frmImportWizard.this.dataMapper.importMapTable.getRowCount()) {
                        JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Selection_Error"));
                        return;
                    }
                    frmImportWizard.this.importThread = new Thread(new ImportProcess(2));
                    frmImportWizard.this.importThread.start();
                }
            } else if (src == frmImportWizard.this.dataMapper.btnDelete) {
                iSQLUtilites.removeSelectedRows(frmImportWizard.this.dataMapper.importDataTable);
            } else if (src instanceof TableFilter && frmImportWizard.this.importProgressMonitor != null) {
                if (frmImportWizard.this.importProgressMonitor.isCanceled()) {
                    frmImportWizard.this.importThread.interrupt();
                    return;
                }
                frmImportWizard.this.importProgressMonitor.setProgress(evt.getID());
                if (evt.getActionCommand().trim().length() == 0) {
                    String ps = frmImportWizard.this.pf.format((double)evt.getID() / 100.0);
                    frmImportWizard.this.importProgressMonitor.setNote(iSQLUtilites.getString("Percent_Complete", ps));
                } else {
                    frmImportWizard.this.importProgressMonitor.setNote(evt.getActionCommand());
                }
            } else if (src == frmImportWizard.this.btnBack && (res = JOptionPane.showConfirmDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Loss_Warning"), "", 0)) == 0) {
                frmImportWizard.this.mContentPanel.showCard("Config");
            }
        }
    }

    private class ImportProcess
    implements Runnable {
        public static final int MODE_DATA_FILTER = 1;
        public static final int MODE_DATA_IMPORT = 2;
        private int opMode = 0;
        private boolean debug = false;

        public ImportProcess(int mode) {
            if (mode != 1 && mode != 2) {
                throw new IllegalArgumentException();
            }
            this.opMode = mode;
            this.debug = DatabaseConnection.getDebugOn();
        }

        public void run() {
            try {
                switch (this.opMode) {
                    case 1: {
                        this.filterData();
                        break;
                    }
                    case 2: {
                        try {
                            this.importData();
                            frmImportWizard.this.btnCancel.setText(iSQLUtilites.getString("Ok"));
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Cancelled"));
                            return;
                        }
                    }
                }
            }
            catch (Exception ex) {
                iSQLUtilites.showExceptionPopup(frmImportWizard.this, ex, iSQLUtilites.getString("Import_Exception"));
                iSQLUtilites.HandleException(ex, iSQLUtilites.getString("Import_Exception"), ex instanceof SQLException && this.debug);
            }
            frmImportWizard.this.importProgressMonitor.setProgress(100);
            frmImportWizard.this.importProgressMonitor.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void filterData() {
            frmImportWizard.this.importedDataModel.setColumnCount(0);
            frmImportWizard.this.importedDataModel.setRowCount(0);
            frmImportWizard.this.importedDataModel.getDataVector().clear();
            try {
                TableFilter filter = frmImportWizard.this.mFilterSelector.getCurrentFilter(true);
                if (filter == null) {
                    JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_No_Filter_Error"));
                    return;
                }
                filter.setProgressListener(frmImportWizard.this.actionHandler);
                frmImportWizard.this.importProgressMonitor = new ProgressMonitor(frmImportWizard.this, iSQLUtilites.getString("Import_Notice"), "-", 0, 100);
                frmImportWizard.this.importProgressMonitor.setMillisToPopup(0);
                frmImportWizard.this.importProgressMonitor.setMillisToDecideToPopup(0);
                if (filter.isFileRequired()) {
                    File f = iSQLUtilites.getSystemFile(frmImportWizard.this);
                    if (f == null) {
                        JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Cancelled"));
                        return;
                    }
                    frmImportWizard.this.importProgressMonitor.setProgress(1);
                    filter.filter(frmImportWizard.this.importedDataModel, f);
                } else {
                    frmImportWizard.this.importProgressMonitor.setProgress(1);
                    filter.filter(frmImportWizard.this.importedDataModel, (File)null);
                }
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Cancelled"));
                return;
            }
            catch (Throwable t) {
                iSQLUtilites.showExceptionPopup(frmImportWizard.this, t, iSQLUtilites.getString("Error_Importing"));
            }
            frmImportWizard.this.importedDataModel.fireTableDataChanged();
            iSQLUtilites.optimizeTableView(frmImportWizard.this.dataMapper.importDataTable);
            frmImportWizard.this.dataMapper.update();
            if (frmImportWizard.this.importedDataModel.getRowCount() <= 0) {
                JOptionPane.showMessageDialog(frmImportWizard.this, iSQLUtilites.getString("Import_Empty_Error"));
                return;
            }
            frmImportWizard.this.mContentPanel.showCard("Map");
        }

        private void importData() throws SQLException, InterruptedException {
            int skip = frmImportWizard.this.dataMapper.getSkipCount();
            String[] cols = new String[frmImportWizard.this.importedDataModel.getColumnCount() - skip];
            int[] types = new int[frmImportWizard.this.importedDataModel.getColumnCount() - skip];
            int k = 0;
            boolean useTransaction = frmImportWizard.this.dataMapper.chkUseTx.isSelected();
            boolean useBatch = frmImportWizard.this.dataMapper.chkUseBatch.isSelected();
            boolean useDebug = DatabaseConnection.getDebugOn();
            boolean echoStatement = DatabaseConnection.getQueryEchoOn();
            boolean autoCommitState = frmImportWizard.this.databaseConnection.getAutoCommit();
            String origonalCatalog = frmImportWizard.this.databaseConnection.getCatalog();
            TableFilter filter = frmImportWizard.this.mFilterSelector.getCurrentFilter();
            frmImportWizard.this.importProgressMonitor = new ProgressMonitor(frmImportWizard.this, iSQLUtilites.getString("Import_Notice"), "-", 0, 100);
            frmImportWizard.this.importProgressMonitor.setMillisToPopup(0);
            frmImportWizard.this.importProgressMonitor.setMillisToDecideToPopup(0);
            frmImportWizard.this.databaseConnection.setAutoCommit(!useTransaction);
            int i = 0;
            while (i < frmImportWizard.this.importedDataModel.getColumnCount()) {
                if (!((Boolean)frmImportWizard.this.dataMapper.importDataModel.getValueAt(i, 3)).booleanValue()) {
                    cols[k] = (String)frmImportWizard.this.dataMapper.importDataModel.getValueAt(i, 1);
                    types[k] = DatabaseConnection.getTypeforName((String)frmImportWizard.this.dataMapper.importDataModel.getValueAt(i, 2));
                    ++k;
                }
                ++i;
            }
            PreparedStatement ps = frmImportWizard.this.databaseConnection.requestInsertPreparedStatement(frmImportWizard.this.dataMapper.tableSelector.getSelectedTable(), cols);
            String Catalog = frmImportWizard.this.databaseConnection.getCatalog();
            try {
                if (frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog() != null && !frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog().equals(origonalCatalog)) {
                    frmImportWizard.this.databaseConnection.changeCatalog(frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog());
                }
            }
            catch (Throwable t) {
                iSQLUtilites.HandleException(t, iSQLUtilites.getString("Catalog_Change_Exception", frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog()), useDebug);
            }
            int r = 0;
            while (r < frmImportWizard.this.importedDataModel.getRowCount()) {
                k = 0;
                int i2 = 0;
                while (i2 < frmImportWizard.this.importedDataModel.getColumnCount()) {
                    if (!((Boolean)frmImportWizard.this.dataMapper.importDataModel.getValueAt(i2, 3)).booleanValue()) {
                        ps.setObject(k + 1, frmImportWizard.this.importedDataModel.getValueAt(r, i2), types[k]);
                        ++k;
                    }
                    ++i2;
                }
                if (useBatch) {
                    try {
                        ps.addBatch();
                    }
                    catch (Throwable t) {
                        iSQLUtilites.HandleException(t, null, t instanceof SQLException && useDebug);
                        try {
                            frmWarningViewer.addResultsetWarnings(ps.getWarnings());
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    try {
                        ps.execute();
                        frmImportWizard.this.actionHandler.actionPerformed(new ActionEvent(filter, (int)((double)(r + 1) / (double)frmImportWizard.this.importedDataModel.getRowCount() * 100.0), ""));
                        k = ps.getUpdateCount();
                        if (echoStatement) {
                            System.out.println(iSQLUtilites.getString("Import_Echo", new String[]{"" + k, ps.toString()}));
                        }
                        try {
                            frmWarningViewer.addResultsetWarnings(ps.getWarnings());
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable t) {
                        if (useTransaction) {
                            frmImportWizard.this.databaseConnection.performRollBack();
                        }
                        frmImportWizard.this.databaseConnection.setAutoCommit(!useTransaction);
                        iSQLUtilites.HandleException(t, null, t instanceof SQLException && useDebug);
                        try {
                            frmWarningViewer.addResultsetWarnings(ps.getWarnings());
                        }
                        catch (Throwable throwable) {}
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    if (useTransaction) {
                        frmImportWizard.this.databaseConnection.performRollBack();
                    }
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {}
                    frmImportWizard.this.databaseConnection.setAutoCommit(autoCommitState);
                    try {
                        if (frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog() != null && !frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog().equals(origonalCatalog)) {
                            frmImportWizard.this.databaseConnection.changeCatalog(Catalog);
                        }
                    }
                    catch (Throwable t) {
                        iSQLUtilites.HandleException(t, iSQLUtilites.getString("Catalog_Change_Exception", frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog()), useDebug);
                    }
                    throw ie;
                }
                ++r;
            }
            if (useBatch) {
                try {
                    ps.executeBatch();
                    try {
                        frmWarningViewer.addResultsetWarnings(ps.getWarnings());
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    if (useTransaction) {
                        frmImportWizard.this.databaseConnection.performRollBack();
                    }
                    iSQLUtilites.HandleException(t, null, t instanceof SQLException && useDebug);
                    try {
                        frmWarningViewer.addResultsetWarnings(ps.getWarnings());
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (useTransaction) {
                frmImportWizard.this.databaseConnection.setAutoCommit(autoCommitState);
            }
            try {
                ps.close();
            }
            catch (Throwable throwable) {}
            try {
                if (frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog() != null && !frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog().equals(origonalCatalog)) {
                    frmImportWizard.this.databaseConnection.changeCatalog(Catalog);
                }
            }
            catch (Throwable t) {
                iSQLUtilites.HandleException(t, iSQLUtilites.getString("Catalog_Change_Exception", frmImportWizard.this.dataMapper.tableSelector.getSelectedCatalog()), useDebug);
            }
        }
    }
}

