/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.I00acres.isql.forms.frmiSQLMain;
import org.I00acres.isql.swing.AbstractTableTool;
import org.I00acres.isql.util.ExtensionFactory;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.DatabaseConnection;

public class frmTableTools
extends JDialog
implements ListSelectionListener {
    private JButton actionReset = new JButton(iSQLUtilites.loadToolbarIconResource("New"));
    private JButton actionEdit = new JButton(iSQLUtilites.loadToolbarIconResource("Edit"));
    private JButton actionExecute = new JButton(iSQLUtilites.loadToolbarIconResource("Play"));
    private JButton btnOK = new JButton(iSQLUtilites.getString("Ok"));
    protected iSQLConfig config = iSQLConfig.getInstance();
    DefaultListModel mTools = new DefaultListModel();
    JList mToolList = new JList(this.mTools);
    JSplitPane mRootSplit = new JSplitPane();
    JScrollPane mToolContainer = new JScrollPane();
    JToolBar mToolbar;
    JToolBar mRootToolBar = new JToolBar();
    DatabaseConnection dbc;
    AbstractTableTool currentTool = null;

    public frmTableTools(DatabaseConnection dbc) {
        super(frmiSQLMain.zParent, "", false);
        try {
            this.setDefaultCloseOperation(2);
            this.dbc = dbc;
            this.initUI();
            this.mToolList.setSelectedIndex(this.config.getIntProperty("Session.LastTableTool", 0));
            this.updateTitle();
        }
        catch (Throwable throwable) {}
    }

    public void dispose() {
        this.config.setIntProperty("Session.LastTableTool", this.mToolList.getSelectedIndex());
        Enumeration enumeration = this.mTools.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AbstractTableTool)enumeration.nextElement()).updateConnection(null);
            }
            catch (Throwable throwable) {}
        }
        ExtensionFactory.close();
        super.dispose();
    }

    public static int showDialog(Frame parent, DatabaseConnection dbc) {
        frmTableTools dlg = new frmTableTools(dbc);
        dlg.setLocationRelativeTo(parent);
        dlg.show();
        return 1;
    }

    private void initToolTable() {
        ExtensionFactory factory = ExtensionFactory.getInstance();
        AbstractTableTool[] tools = factory.getTableTools();
        int i = 0;
        while (i < tools.length) {
            tools[i].reset();
            SwingUtilities.updateComponentTreeUI(tools[i]);
            this.mTools.addElement(tools[i]);
            ++i;
        }
    }

    private void updateTitle() {
        AbstractTableTool tool = (AbstractTableTool)this.mTools.elementAt(this.mToolList.getSelectedIndex());
        String[] params = new String[]{"iSQL-Viewer", tool != null ? tool.getToolName() : ""};
        this.setTitle(iSQLUtilites.getString("Table_Tools_Title", params));
    }

    private void initUI() throws Exception {
        this.initToolTable();
        ActionHandler al = new ActionHandler();
        this.actionEdit.addActionListener(al);
        this.actionReset.addActionListener(al);
        this.actionExecute.addActionListener(al);
        this.btnOK.addActionListener(al);
        this.actionEdit.setToolTipText("");
        this.actionReset.setToolTipText("");
        this.actionExecute.setToolTipText("");
        this.btnOK.setToolTipText(iSQLUtilites.getString("Close_This_Dialog"));
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        iSQLUtilites.lockComponentToPerferredSize(this.btnOK);
        this.mRootSplit.setRightComponent(this.mToolContainer);
        this.mRootSplit.setLeftComponent(new JScrollPane(this.mToolList));
        this.mRootSplit.setOrientation(1);
        this.mRootSplit.setOneTouchExpandable(false);
        this.mToolList.setCellRenderer(new ToolCellRenderer());
        this.mToolList.addListSelectionListener(this);
        this.mRootToolBar.add(this.actionReset);
        this.mRootToolBar.add(this.actionEdit);
        this.mRootToolBar.add(this.actionExecute);
        this.mRootToolBar.add(Box.createHorizontalGlue());
        this.mRootToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.mRootSplit, "Center");
        this.getContentPane().add((Component)this.mRootToolBar, "North");
        JToolBar tb = new JToolBar(0);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnOK);
        tb.setFloatable(false);
        this.getContentPane().add((Component)tb, "South");
        ((Component)this).setSize(640, 480);
    }

    public void valueChanged(ListSelectionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.currentTool = (AbstractTableTool)this.mTools.elementAt(this.mToolList.getSelectedIndex());
            this.mRootSplit.setRightComponent(this.currentTool);
            this.mToolContainer.getViewport().setPreferredSize(this.currentTool.getPreferredSize());
            this.mRootSplit.setDividerLocation(this.mToolList.getPreferredSize().width + this.mRootSplit.getDividerSize());
            this.currentTool.pack();
            this.currentTool.updateConnection(this.dbc);
        }
        catch (Throwable throwable) {}
        this.updateTitle();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private class ToolCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ToolCellRenderer() {
            this.setForeground(Color.black);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setFont(this.getFont().deriveFont(1, 11.0f));
        }

        public Component getListCellRendererComponent(JList tree, Object value, int index, boolean selected, boolean hasFocus) {
            AbstractTableTool tool = (AbstractTableTool)value;
            this.setIcon(tool.toIcon());
            this.setText(tool.getToolName());
            this.setOpaque(selected);
            return this;
        }
    }

    private class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (frmTableTools.this.currentTool == null) {
                return;
            }
            if (src == frmTableTools.this.actionEdit) {
                frmTableTools.this.currentTool.edit();
            } else if (src == frmTableTools.this.btnOK) {
                frmTableTools.this.dispose();
            } else if (src == frmTableTools.this.actionReset) {
                frmTableTools.this.currentTool.reset();
            } else if (src == frmTableTools.this.actionExecute) {
                frmTableTools.this.currentTool.execute();
            }
        }
    }
}

