/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql;

import java.awt.Component;
import java.sql.DriverManager;
import org.I00acres.isql.iSQLFrame;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public final class iSQLViewer {
    public static final ThreadGroup SHUT_DOWN_THREAD_GROUP = new ThreadGroup("isql-shutdown-hooks");
    private static iSQLConfig config = iSQLConfig.getInstance();

    public iSQLViewer() {
        iSQLUtilites.setLookAndFeel(config.getStringProperty("General.LAF"));
        iSQLFrame frame = new iSQLFrame();
        ((Component)frame).setVisible(true);
    }

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(new BasicShutdownHook()));
        try {
            iSQLViewer.handCMDLine(args);
        }
        catch (Exception e) {
            iSQLUtilites.HandleException(e, iSQLUtilites.getString("CMD_Line_Error"), true);
            System.exit(-1);
        }
        try {
            new iSQLViewer();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, iSQLUtilites.getString("iSQL_Init_Error"), true);
            System.exit(-1);
        }
    }

    private static void handCMDLine(String[] args) {
        if (args.length >= 1) {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equalsIgnoreCase("--version") || arg.equalsIgnoreCase("-v")) {
                    System.out.println("iSQL-Viewer v.2.1.0");
                    System.exit(1);
                } else if (arg.equalsIgnoreCase("--nosplash") || arg.equalsIgnoreCase("-ns")) {
                    config.setBooleanProperty("General.ShowSplash", false);
                } else if (arg.equalsIgnoreCase("--help") || arg.equalsIgnoreCase("-h")) {
                    System.out.println("iSQL-Viewer v.2.1.0");
                    System.out.println("--help");
                    System.out.println("       Shows This Screen");
                    System.out.println("--version, -v");
                    System.out.println("       Shows iSQL-Version");
                    System.out.println("--nosplash, -ns");
                    System.out.println("       Do Not Show Splash Screen regardless of Prefrences.");
                    System.out.println("       This Option is Recommended For UNIX Users if App Crashes on Startup");
                    System.exit(1);
                }
                ++i;
            }
        }
    }

    protected static class BasicShutdownHook
    extends Thread {
        public BasicShutdownHook() {
            super(SHUT_DOWN_THREAD_GROUP, "stream-closer");
        }

        public void run() {
            try {
                DriverManager.getLogWriter().close();
            }
            catch (Exception exception) {}
            try {
                try {
                    System.err.close();
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                iSQLUtilites.restoreSystemErr();
                throw throwable;
            }
            Object var2_4 = null;
            iSQLUtilites.restoreSystemErr();
            try {
                try {
                    System.out.close();
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                iSQLUtilites.restoreSystemOut();
                throw throwable;
            }
            Object var3_6 = null;
            iSQLUtilites.restoreSystemOut();
        }
    }
}

