/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing.table;

import java.sql.DatabaseMetaData;
import java.util.Random;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.ResultSetUtilities;

public class TableWizardModel
extends DefaultTableModel {
    private String[] DEFAULT_TYPES = new String[]{iSQLUtilites.getString("SQL_TYPE_CHARACTER"), iSQLUtilites.getString("SQL_TYPE_BIGINT"), iSQLUtilites.getString("SQL_TYPE_VARCHAR"), iSQLUtilites.getString("SQL_TYPE_VARCHAR2"), iSQLUtilites.getString("SQL_TYPE_INTEGER"), iSQLUtilites.getString("SQL_TYPE_FLOAT"), iSQLUtilites.getString("SQL_TYPE_BIGINT"), iSQLUtilites.getString("SQL_TYPE_SMALLINT"), iSQLUtilites.getString("SQL_TYPE_TINYINT"), iSQLUtilites.getString("SQL_TYPE_BIT"), iSQLUtilites.getString("SQL_TYPE_DATE"), iSQLUtilites.getString("SQL_TYPE_TIME"), iSQLUtilites.getString("SQL_TYPE_TIMESTAMP"), iSQLUtilites.getString("SQL_TYPE_CLOB"), iSQLUtilites.getString("SQL_TYPE_BLOB")};
    String[] columnHeader = new String[]{iSQLUtilites.getString("Table_Column_Name"), iSQLUtilites.getString("Column_Type"), iSQLUtilites.getString("Column_Precision"), iSQLUtilites.getString("Column_Scale"), iSQLUtilites.getString("Not_Null"), iSQLUtilites.getString("Is_Unique"), iSQLUtilites.getString("Default_Value"), iSQLUtilites.getString("PrimaryKey"), iSQLUtilites.getString("Check")};
    private JComboBox sqlTypeEditor;
    private Random rndNumber = new Random(System.currentTimeMillis());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public TableWizardModel() {
        super(0, 9);
        this.setColumnIdentifiers(this.columnHeader);
    }

    public synchronized void clearTable() {
        this.dataVector.clear();
        System.runFinalization();
    }

    public String getSQLStringforRow(int r) {
        Boolean f;
        StringBuffer buff = new StringBuffer("");
        Object[] row = this.dataVector.get(r).toArray();
        buff.append(row[0] == null ? "" : row[0].toString());
        buff.append(row[1] == null ? "" : " " + row[1].toString());
        if (row[2] != null && row[2].toString().trim().length() >= 1) {
            buff.append("(" + row[2].toString());
            if (row[3] != null) {
                if (row[3].toString().trim().length() >= 1) {
                    buff.append("," + row[3].toString() + ")");
                } else {
                    buff.append(")");
                }
            } else {
                buff.append(")");
            }
        }
        if ((f = (Boolean)row[4]) != null && f.booleanValue()) {
            buff.append(" " + iSQLUtilites.getString("SQL_NOT_NULL"));
        }
        if ((f = (Boolean)row[5]) != null && f.booleanValue()) {
            buff.append(" " + iSQLUtilites.getString("SQL_UNIQUE"));
        }
        if (row[6] != null && row[6].toString().trim().length() >= 1) {
            buff.append(" " + iSQLUtilites.getString("SQL_DEFAULT", row[6].toString()));
        }
        if ((f = (Boolean)row[7]) != null && f.booleanValue()) {
            buff.append(" " + iSQLUtilites.getString("SQL_PRIMARY_KEY"));
        }
        if (row[8] != null && row[8].toString().trim().length() >= 1) {
            buff.append(" " + iSQLUtilites.getString("SQL_CHECK", row[8].toString()));
        }
        return buff.toString();
    }

    public void insertBlankRow(int row) {
        Object[] objectArray = new Object[9];
        objectArray[0] = Long.toHexString(this.rndNumber.nextLong());
        objectArray[1] = "";
        Object[] blankrow = objectArray;
        try {
            this.insertRow(row, blankrow);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.addRow(blankrow);
        }
    }

    public DefaultCellEditor getSQLTypeEditor(DatabaseMetaData md) {
        try {
            this.sqlTypeEditor = new JComboBox<Object>(ResultSetUtilities.getSingleColumn(md.getTypeInfo(), "TYPE_NAME"));
        }
        catch (Exception exception) {
            this.sqlTypeEditor = new JComboBox<String>(this.DEFAULT_TYPES);
        }
        this.sqlTypeEditor.setEditable(true);
        this.sqlTypeEditor.setMaximumRowCount(5);
        this.sqlTypeEditor.setPopupVisible(false);
        return new DefaultCellEditor(this.sqlTypeEditor);
    }

    public Class getColumnClass(int idx) {
        switch (idx) {
            default: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.sql.Types");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: 
            case 3: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: 
            case 5: 
            case 7: 
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

